cc.Class({
    extends: cc.Component,

    properties: {
        //星星预制体
        starPrefab:{
            default: null,
            type: cc.Prefab
        },
        //地面节点，星星生成高度
        ground:{
            default: null,
            type: cc.Node
        },
        //主角跳跃高度和行动控制开关
        player:{
            default:null,
            type: cc.Node
        },
        //得分
        scoreDisplay:{
            default:null,
            type: cc.Label
        },
        //得分音效
        ScoreAudio:{
            default:null,
            type: cc.AudioClip
        },

        startBtn:{
            default: null,
            type: cc.Button
        },
        player: {
            default: null,
            type: cc.Node
        },

        BtnParent: cc.Node,

        //星星生成后消失时间范围
        maxTimeDuration: 0,
        minTimeDuration: 0,
    },

    onLoad: function(){
        //获取地平面的y轴坐标
        this.groundY=this.groundY + this.height/2;

        //初始化计时器
        this.timer = 0;
        this.starDuration = 0;

        //初始化游戏状态
        this.gameStatus = false;

        //生成一个星星
        this.spawnNewStar();

        //初始化得分
        this.score = 0;
    },

    start () {
        this.theGameResume();
    },

    update: function (dt) {
        if(this.gameStatus == true){
            // 每帧更新计时器，超过限度还没有生成新的星星
            // 就会调用游戏失败逻辑
            if (this.timer > this.starDuration) {
                this.gameOver();
                return;
            }
            this.timer += dt;
        }
    },
    spawnNewStar: function(){
        //使用给定的模板在场景中生成一个新的节点
        var newStar = cc.instantiate(this.starPrefab);
        
        //将新增的节点添加到Canvas节点下面
        this.node.addChild(newStar);

        //为星星设置一个随机的位置
        newStar.setPosition(this.getNewStarPosition());


        newStar.getComponent('Star').game=this;

        this.starDuration = this.minTimeDuration + Math.random() * (this.maxTimeDuration - this.minTimeDuration);
        this.timer=0;
    },
    getNewStarPosition: function(){
        
        var randX=0;
        //根据地平面位置和主角跳跃高度，随机得到一个星星的y坐标
        var randY = this.groundY + Math.random() * this.player.getComponent('playercontrol').jumpHeight+50;
        //根据屏幕宽度，随机得到一个星星x坐标
        var maxX=this.node.width/2;
        //randX = cc.randomMinus1To1() * maxX;
        randX = (Math.random() - 0.5) * 2 * maxX;
        //返回星星坐标
        return cc.v2(randX,randY);
    },
    getScore: function(){
        this.score += 1;
        //更新场景显示的分数
        this.scoreDisplay.string='Score: '+this.score.toString();
        //播放得分音效
        cc.audioEngine.playEffect(this.ScoreAudio,false);
    },

    gameOver:function(){
        this.theGameResume();
        this.gameStatus=false;
        this.player.xSpeed = 0;
        cc.director.loadScene('Game');
    },

    theGameStart:function(){
        this.player.resumeAllActions();
        this.BtnParent.active = false;
        this.gameStatus = true;
    },

    theGameResume:function(){
        this.player.pauseAllActions();
        this.BtnParent.active = true;
    },
});
