"use strict";
cc._RF.push(module, '131a1ko9sVM5ZZBhFLeZz1d', 'Star');
// scripts/javascripts/Star.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {

        //星星和主角之间的距离小于当前值时，收集
        pickRadius: 0,

        //暂存Game对象的引用
        game: {
            default: null,
            serializable: false
        }
    },
    onLoad: function onLoad() {
        this.game = cc.director.getScene().getChildByName("Canvas").getComponent("GameManager");
        this.player = this.game.player;
        this.timer = this.game.timer;
        this.starDuration = this.game.starDuration;
    },
    start: function start() {},


    getPlayerDistance: function getPlayerDistance() {
        //根据player节点位置判断距离
        var playerPos = this.player.getPosition();
        //根据两点位置计算两点之间的距离
        var dist = this.node.position.sub(playerPos).mag();
        // var dist=cc.pDistance(this.node.position,playerPos);
        return dist;
    },
    onPicked: function onPicked() {
        //当星星被收集时，调用Game脚本中的接口，生成一个新的星星
        this.game.spawnNewStar();
        //调用Game脚本中的得分方法
        this.game.getScore();
        //然后销毁当前星星节点
        this.node.destroy();
    },
    update: function update(dt) {
        //每帧判断和主角之间的距离是否小于收集距离
        if (this.getPlayerDistance() < this.pickRadius) {
            //调用收集行为
            this.onPicked();
            return;
        }
        //根据Game脚本中的计时器更新星星的透明度
        var opacityRatio = 1 - this.timer / this.starDuration;
        var minOpacity = 50;
        this.node.opacity = minOpacity + Math.floor(opacityRatio * (255 - minOpacity));
    }
});

cc._RF.pop();