(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scripts/javascripts/playercontrol.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'a620eULdKpB64iox1ikvNcL', 'playercontrol', __filename);
// scripts/javascripts/playercontrol.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        //跳跃音效
        jumpAudio: {
            default: null,
            type: cc.AudioClip
        },

        theGame: {
            default: null,
            type: cc.Node
        },
        //高度
        jumpHeight: 0,
        //持续时间
        jumpDuration: 0,
        //最大速度
        moveMaxSpeed: 0,
        //加速度
        accel: 0
    },

    onLoad: function onLoad() {
        // 初始化跳跃动作
        this.jumpAction = this.setJumpAction();
        this.node.runAction(this.jumpAction);

        //加速移动开关
        this.accLeft = false;
        this.accRight = false;

        //当前速度
        this.xSpeed = 0;

        //初始化键盘监听
        // this.setInputControl();

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    },
    start: function start() {},


    setJumpAction: function setJumpAction() {
        //起跳
        var theJumpUp = cc.moveBy(this.jumpDuration, cc.v2(0, this.jumpHeight)).easing(cc.easeCubicActionOut());
        //下降
        var theJumpDown = cc.moveBy(this.jumpDuration, cc.v2(0, -this.jumpHeight)).easing(cc.easeCubicActionIn());
        //添加一个回调函数，用于在动作结束时调用我们定义的其他方法
        var callback = cc.callFunc(this.playJumpSound, this);
        //不断重复
        return cc.repeatForever(cc.sequence(theJumpUp, theJumpDown));
    },
    playJumpSound: function playJumpSound() {
        //调用声音引擎播放声音
        cc.audioEngine.playEffect(this.jumpAudio, false);
    },
    // setInputControl: function(){
    //     var self = this;

    //     //添加时间监听
    //     //按下按键
    //     cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, function(event){
    //         switch(event.keyCode){
    //             case cc.KEY.a:
    //             self.accLeft=true;
    //             break;
    //             case cc.KEY.d:
    //             self.accRight=true;
    //             break;
    //         }
    //     });
    //     cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,function(event){
    //         switch(event.keyCode){
    //             case cc.KEY.a:
    //             self.accLeft=false;
    //             break;
    //             case cc.KEY.d:
    //             self.accRight=false;
    //             break;
    //         }
    //     });
    // },

    onKeyDown: function onKeyDown(event) {
        // set a flag when key pressed
        switch (event.keyCode) {
            case cc.macro.KEY.a:
                this.accLeft = true;
                break;
            case cc.macro.KEY.d:
                this.accRight = true;
                break;
        }
    },
    onKeyUp: function onKeyUp(event) {
        // unset a flag when key released
        switch (event.keyCode) {
            case cc.macro.KEY.a:
                this.accLeft = false;
                break;
            case cc.macro.KEY.d:
                this.accRight = false;
                break;
        }
    },


    update: function update(dt) {
        if (this.theGame.getComponent('GameManager').gameStatus == true) {
            //根据加速度更新速度
            if (this.accLeft) {
                this.xSpeed -= this.accel * dt;
            } else if (this.accRight) {
                this.xSpeed += this.accel * dt;
            }

            //限制最大速度
            if (Math.abs(this.xSpeed) > this.moveMaxSpeed) {
                this.xSpeed = this.moveMaxSpeed * this.xSpeed / Math.abs(this.xSpeed);
            }
            //更新主角位置
            this.node.x += this.xSpeed * dt;

            if (this.node.x > this.node.parent.width / 2) {
                this.node.x = this.node.parent.width / 2;
                this.xSpeed = 0;
            } else if (this.node.x < -this.node.parent.width / 2) {
                this.node.x = -this.node.parent.width / 2;
                this.xSpeed = 0;
            }
        }
    }
    // onDestroy () {
    //     // 取消键盘输入监听
    //     cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    //     cc.systemEvent.off(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    // },
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=playercontrol.js.map
        