const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    start () {
        // init logic
        this.label.string = this.text;
        cc.loader.loadRes("main_scene", cc.AudioClip, function (err: Error, obj: cc.AudioClip) {
            if(obj instanceof cc.AudioClip) {
                cc.audioEngine.setMusicVolume(1);
                cc.audioEngine.playEffect(obj, false);
            }
        });
    }
}
