
cc.Class({
    extends: cc.Component,

    properties: {
        fixPosY: {  // 横屏的情况下 是否要y轴的安全区域修正
            default: false,
            visible() {
                return this.node.width > this.node.height;
            },
        }
    },
    onEnable(){
        this.updateArea();
        cc.view.on('canvas-resize', this.updateArea, this);
    },
    
    onDisable () {
        cc.view.off('canvas-resize', this.updateArea, this);
    },
    
    updateArea() {
        let widget = this.node.getComponent( cc.Widget);
        if (!widget) {
            widget = this.node.addComponent( cc.Widget);
        }
        
        // widget.alignMode = cc.Widget.AlignMode.ONCE;
        widget.top = widget.bottom = widget.left = widget.right = 0;
        widget.isAlignTop = widget.isAlignBottom = widget.isAlignLeft = widget.isAlignRight = true;

        widget.updateAlignment();

        let lastPos = this.node.position;

        let lastAnchorPoint = this.node.getAnchorPoint();
        //
        widget.isAlignTop = widget.isAlignBottom = widget.isAlignLeft = widget.isAlignRight = true;
        
        let screenWidth = cc.winSize.width, screenHeight = cc.winSize.height;
        let safeArea = cc.sys.getSafeAreaRect();
        console.log( "safeArea:", JSON.stringify(safeArea ));
        let fixPosY = this.fixPosY;
        
        // 安全区域 如果是竖屏的 强制刷新
        if( safeArea.width < safeArea.height ) {
            fixPosY = true;
        }

        widget.top = fixPosY? screenHeight - safeArea.y - safeArea.height:0;
        widget.bottom = fixPosY?safeArea.y:0;
        
        widget.left = screenWidth - safeArea.x - safeArea.width;
        widget.right = safeArea.x;
        widget.updateAlignment();

        // set anchor, keep the original position unchanged
        let curPos = this.node.position;
        let anchorX = lastAnchorPoint.x - (curPos.x - lastPos.x) / this.node.width;
        let anchorY = lastAnchorPoint.y - (curPos.y - lastPos.y) / this.node.height;
        this.node.setAnchorPoint(anchorX, anchorY);
        // IMPORTANT: restore to lastPos even if widget is not ALWAYS
        widget.enabled = true;
    }
});