const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property(cc.Label)
    move: cc.Label = null;

    text: string = '点击有效,1秒后重置...';
    init: string = '点击按钮后长按背景任意位置测试';

    nowTime = 5;
    isMove = false;

    onLoad() {
        cc.macro.ENABLE_MULTI_TOUCH = false;

    }
    update(dt) {
        if (this.isMove) {
            this.nowTime -= dt
            let time = Math.floor(this.nowTime * 10) / 10;
            if (time > 0) {
                this.move.string = 'MOVE中别松手,还剩' + time + '秒...'
            } else {
                this.move.string = '可以松手了,下方按钮已经无效...'
                this.node.off(cc.Node.EventType.TOUCH_START, this.startTouch, this)
                this.node.off(cc.Node.EventType.TOUCH_MOVE, this.moveTouch, this)
                this.node.off(cc.Node.EventType.TOUCH_END, this.endTouch, this)
                this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.endTouch, this)
            }
        }
    }

    public click() {
        this.node.on(cc.Node.EventType.TOUCH_START, this.startTouch, this)
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.moveTouch, this)
        this.node.on(cc.Node.EventType.TOUCH_END, this.endTouch, this)
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.endTouch, this)
        this.label.string = this.text;
        setTimeout(() => {
            this.label.string = this.init;
        }, 1000);
    }

    public startTouch() {

        console.log('开始移动');
        this.nowTime = 5;
        this.isMove = true;
    }


    public endTouch() {
        console.log('结束移动')
        this.move.node.opacity = 0;
        this.isMove = false;
    }


    public moveTouch() {
        this.move.node.opacity = 255;
    }
}
