import { _decorator, Component, Node, ColliderComponent, ICollisionEvent, SphereColliderComponent, systemEvent, SystemEvent, macro, AnimationComponent, ITriggerEvent, director, Vec3 } from "cc";
const { ccclass, property } = _decorator;

@ccclass("player")
export class player extends Component {

     //动画组件
     @property(AnimationComponent)
     playerAnim:AnimationComponent=null;

    onLoad()
    {
        //键盘监听事件
        systemEvent.on(SystemEvent.EventType.KEY_DOWN,this.onkeyDown,this)
    }

    start () {
        // Your initialization goes here.
        //this.startTrgger();


    }

    //键盘按下
    public onkeyDown(event)
    {
        switch(event.keyCode)
        {
            case macro.KEY.a:
            this.moveToLeft();
            break;
            case macro.KEY.d:
            this.moveToRight();
            break;

        }
    }

    //左边移动
    public moveToLeft()
    {
        this.playerAnim.play('rotateAnim');
        var playerX=this.node.getPosition().x-1
        this.node.setPosition(new Vec3(playerX,this.node.position.y,this.node.position.z));
        if(playerX<=0)
        {
            playerX=1;
            this.node.setPosition(new Vec3(playerX,this.node.position.y,this.node.position.z));
        }
    }

    //右边移动
    public moveToRight()
    {
        var playerX=this.node.getPosition().x+1;
        this.node.setPosition(new Vec3(playerX,this.node.position.y,this.node.position.z));
        if(playerX>=29)
        {
            playerX=29;
            //this.node.setPosition(playerX,this.node.position.y,this.node.position.z);
            this.node.setPosition(new Vec3(playerX,this.node.position.y,this.node.position.z));
        }
    }

    //触发
    private startTrgger()
    {
        let triggerCollider=this.getComponent(ColliderComponent);
         triggerCollider.on('onTriggerEnter',this.onTrigger,this)
    }
    private onTrigger(event:ITriggerEvent)
    {
        console.log("**********/触发/********");
    }


    //碰撞
    private startCollision()
    {
        let Collider=this.getComponent(ColliderComponent);
        Collider.on('onCollisionEnter',this.onCllision,this)
    }

    private onCllision(event:ITriggerEvent)
    {
        console.log("*************/碰撞/**********");
        cc.director.loadScene("end");
    }

    update()
    {
        this.startTrgger();
        this.startCollision();
    }
    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }
}
