/**
 * Created by JianFei on 16-3-5.
 *
 * 时间测试模块,start为开始,stop为结束, 中间可插入多次timing计时。最后会输出从start到stop的总时间。
 * 每次调用必须传入tag，多个计时可同时嵌套使用。
 *
 * //开始计时
 * TimeTest.start('test')
 *
 * //创建精灵并计时
 * var _sp = new cc.Sprite('aaaa.png');
 * TimeTest.timing('test',1)
 *
 * //设置大小并及计时
 * _sp.setScale(3);
 * TimeTest.timing('test',2)
 *
 * //添加到节点并统计总时间.
 * this.addChild(_sp);
 * TimeTest.stop('test')
 */


var TimeTest = {

    dict_times : {},

    start:function(strTag){

        if(!this._checkTag(strTag)){
            return;
        }

        var _time_info = {};

        _time_info.startTime = new Date().getTime();
        _time_info.lastTimingTime = _time_info.startTime;
        cc.log('开始统计! ' + strTag);

        this.dict_times[strTag] = _time_info;
    },

    timing:function(strTag,stepTag){

        if(!this._checkTag(strTag)){
            return;
        }

        var _time_info = this.dict_times[strTag];

        if(!_time_info){
            cc.log('timing error! tag = ' + strTag + ',stepTag = ' + stepTag);
            return;
        }

        var timeNow = new Date().getTime();
        var t = timeNow - _time_info.lastTimingTime;
        _time_info.lastTimingTime = timeNow;

        if(t <= 16){
            cc.log('记录! ' + strTag + ',step = ' + stepTag + ',距离上次 ' + t + ' 毫秒');
        }
        else if(t <= 50){
            cc.log('记录! ' + strTag + ',step = ' + stepTag + ',距离上次 ' + t + ' 毫秒, 轻度卡顿!!!');
        }
        else if(t <= 100){
            cc.log('记录! ' + strTag + ',step = ' + stepTag + ',距离上次 ' + t + ' 毫秒, 中度卡顿!!!!!!!!');
        }
        else{
            cc.log('记录! ' + strTag + ',step = ' + stepTag + ',距离上次 ' + t + ' 毫秒, 严重卡顿!!!!!!!!!!!!!!');
        }


    },

    stop:function(strTag){

        if(!this._checkTag(strTag)){
            return;
        }

        var _time_info = this.dict_times[strTag];

        if(!_time_info){
            cc.log('timing error! tag = ' + strTag);
            return;
        }

        _time_info.lastTimingTime = new Date().getTime();
        var sumTime = _time_info.lastTimingTime - _time_info.startTime;
        cc.log('结束统计! ' + strTag +',总时间 ' + sumTime + ' 毫秒');
    },

    _checkTag: function(strTag){
        if(!strTag){
            cc.log('未设置计时tag!');
            return false;
        }

        return true;
    }

};