
var HelloWorldLayer = cc.Layer.extend({

    ctor:function () {
        this._super();

        this.btnAdd = new ccui.Button();
        this.btnAdd.setTitleText('btnAdd');
        this.btnAdd.setTitleFontSize(30);
        this.btnAdd.setPosition(400,400);
        this.addChild(this.btnAdd);
        this.btnAdd.addClickEventListener(this.addSpine.bind(this));

        this.btnRemove = new ccui.Button();
        this.btnRemove.setTitleText('btnRemove');
        this.btnRemove.setTitleFontSize(30);
        this.btnRemove.setPosition(400,300);
        this.addChild(this.btnRemove);
        this.btnRemove.addClickEventListener(this.removeSpine.bind(this));

        this.btnGC = new ccui.Button();
        this.btnGC.setTitleText('btnGC');
        this.btnGC.setTitleFontSize(30);
        this.btnGC.setPosition(400,200);
        this.addChild(this.btnGC);
        this.btnGC.addClickEventListener(this.gc.bind(this));

        this.btnFreeTexture = new ccui.Button();
        this.btnFreeTexture.setTitleText('btnFreeTexture');
        this.btnFreeTexture.setTitleFontSize(30);
        this.btnFreeTexture.setPosition(400,100);
        this.addChild(this.btnFreeTexture);
        this.btnFreeTexture.addClickEventListener(this.freeTexture.bind(this));

        //启动先把贴图载入,方便计算spine文件内存
        cc.textureCache.addImage("res/dongfangbubai.png");
        cc.textureCache.addImage("res/dongfangbubai2.png");

        return true;
    },

    addSpine: function(){

        for(var i = 0; i < 1; i++){
            //使用json创建,首次创建并删除后,内存多了3~4mb, 同时创建10个再删除,内存多了11mb左右, 已排除贴图内存
            var node = sp.SkeletonAnimation.createWithJsonFile("res/dongfangbubai.json","res/dongfangbubai.atlas",1);

            //使用二进制创建,首次创建并删除后,内存多了0.6mb, 同时创建10个再删除,内存多了5mb左右, 已排除贴图内存
            //var node = sp.SkeletonAnimation.createWithBinaryFile("res/dongfangbubai.skel","res/dongfangbubai.atlas",1);

            node.setAnimation(0,'aoyi',true);
            node.setPosition(400,400);
            node.setTag(100);
            this.addChild(node,-1);
        }
    },

    removeSpine: function(){
        var node = this.getChildByTag(100);
        while(node){
            node.clearTracks();
            node.removeFromParent(true);
            node = null;
            node = this.getChildByTag(100);
        }
    },

    gc: function(){
        cc.log('gc');
        cc.sys.garbageCollect();
    },

    freeTexture: function(){
        cc.textureCache.removeUnusedTextures();
    }
});

var HelloWorldScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new HelloWorldLayer();
        this.addChild(layer);
    }
});

