// import GradeNode from "../MainScene/UserInfo/GradeNode";

/**
 * copyright (c) 厦门风领科技有限公司
 * http://www.fenglinghudong.com/
 * 
 * 组件功能
 * 徐斌杰
 * 2018-00-00
 */
const {ccclass, property} = cc._decorator;

@ccclass
export default class RankingItem extends cc.Component {

    /**
     * 玩家昵称
     */
    @property({
        type:cc.Label,
        tooltip:'玩家昵称'
    })
    nick: cc.Label = null;

        /**
     * 玩家头像
     */
    @property({
        type:cc.Sprite,
        tooltip:'玩家头像'
    })
    avatar: cc.Sprite = null;

        /**
     * 性别男
     */
    @property({
        type:cc.Node,
        tooltip:'性别男'
    })
    man: cc.Node = null;

        /**
     * 性别女
     */
    @property({
        type:cc.Node,
        tooltip:'性别女'
    })
    woman: cc.Node = null;
    
    // /**
    //  * 段位组件
    //  */
    // gradeNodeCom:GradeNode = null;

    /**
     * 最大分数
     */
    @property({
        type:cc.Label,
        tooltip:'最大分数'
    })
    lbMaxScore: cc.Label = null;

    /**
     * 数据
     */
    data:{avatarUrl, city, gender, nickName,rank,score, uid} = null;



    onLoad(){
        
        // this.gradeNodeCom = this.node.getChildByName('gradeNode').getComponent(GradeNode);
        this.man.active = false;
        this.woman.active = false;
    }



    /**
     * 设置背景
     */
    setBG(spriteFrame){
        this.node.getComponent(cc.Sprite).spriteFrame = spriteFrame;
    }

    /**
     * 
     * @param data
     */
    setItemData(data){
        this.data = data;
         this.nick.string = data.nickName;   
        this.showSex(data.gender);
        this.setAvatar(data.avatarUrl);
        this.lbMaxScore.string = data.score;
        //设置段位数据
        // this.gradeNodeCom.setData(data.xxx);
    }

    setAvatar(url){
        if (!url){
            return;
        };
        let self = this;
        cc.loader.load({url:url, type:'png'}, (err, texture)=>{
            if (err){
                return;
            }
            let spriteFrame = new cc.SpriteFrame();
            spriteFrame.setTexture(texture);
            this.avatar.spriteFrame = spriteFrame;

        })
    }

    /**
     * 
     * @param gender 
     */
    showSex(gender){
        if(gender ===1 ){
            this.man.active= true;
        }else{
            this.woman.active= true;
        }
    }

    // update (dt) {},
}
