import RankingItem from "./RankingItem";

/**
 * copyright (c) 厦门风领科技有限公司
 * http://www.fenglinghudong.com/
 * 
 * 组件功能
 * 徐斌杰
 * 2018-00-00
 */
const {ccclass, property} = cc._decorator;

@ccclass
export default class RankingLayer extends cc.Component {

    // /**
    //  * 
    //  */
    // @property({
    //     type:cc.Node,
    //     tooltip:''
    // })
    // propertyName: cc.Node = null;

    @property({
        type:cc.Node,
        tooltip:'前9的数字'
    })
    lbNumber1 :cc.Node = null;

    @property({
        type:cc.Node,
        tooltip:'10以后的数字'
    })
    lbNumber2 :cc.Node = null;

    /**
     * 前三项的背景
     */
    @property({
        type:cc.SpriteFrame,
        tooltip:'前三项的背景'
    })
    itemBg :cc.SpriteFrame = null;

    @property({
        type:cc.Node,
        tooltip:'内容'
    })
    content:cc.Node = null;

    @property({
        type:cc.Prefab,
        tooltip:'item预设'
    })
    preItem:cc.Prefab = null;   

    /**
     * 我的排名项
     */
    @property({
        type:RankingItem,
        tooltip:'我的排名项'
    })
    myRanking:RankingItem = null;

    /**
     * 是否可以点击
     */
    isTouch:boolean = false;

    /**
     * 遮罩
     */
    mask :cc.Node = null;

    /**
     * 排行榜数据
     */
    rankDatas:{avatarUrl, city, gender, nickName,rank,score, uid}[] = [];

    /**
     * 自己的排行榜数据
     */
    selfRankDatas:{rank,
        score,
        uid} = null;

    onLoad(){
        // this.mask = this.node.parent.getChildByName('mask');
        // cc.systemEvent.on(FeigoGameRecord.EEventNames.GET_RANK_RECORD_SUCCESS, this.getRankRecordSuccess, this);
        // cc.systemEvent.on(FeigoGameRecord.EEventNames.GET_RANK_RECORD_ERROR, this.getRankRecordErr, this);

        
        this.isTouch = true;

        // FeigoGameRecord.getRankRecordList(0, 10);
    }

        /**
     * 显示遮罩
     */
    showMask(){
        // this.mask.active = true;
    }

    /**
     * 
     */
    hideMask(){
        // this.mask.active = false;
    }

    /**
     * 初始化排行榜数据
     * 我的排行数据
     */
    initDatas(){
        let datas = this.rankDatas;
        for (let i = 0; i < datas.length; i++) {
            let data = datas[i];
            this.createItem(data, i);
        } 
        this.setMyRanking();
    }

    /**
     * 克隆1-9的数字
     */
    cloneNumber1(){
        let node = cc.instantiate(this.lbNumber1);
        return node;
    }

        /**
     * 克隆1-9的数字
     */
    cloneNumber2(){
        let node = cc.instantiate(this.lbNumber2);
        return node
    }

    /**
     * 创建排名项
     * @param data 
     */
    createItem(data, i){

        let fnt:cc.Node = null;
        /**
         * 设置排名数字
         */
        if (i<9){
            fnt = this.cloneNumber1();
        }else{
            fnt = this.cloneNumber2();
        }


        let node = cc.instantiate(this.preItem);
        node.x = 0;
        /**
         * 设置背景底图
         */
        if (i < 3){
            node.getComponent(RankingItem).setBG(this.itemBg);
        }
        node.getComponent(RankingItem).setItemData(data);
        node.parent = this.content;
        fnt.parent = node;
        fnt.x = -226;
        fnt.y = 61;
        fnt.getComponent(cc.Label).string = i+1;
    }

    /**
     * 设置我的排名
     */
    setMyRanking(){

        let data = {
            // nickName:UserData.userInfoData.nickName,
            // gender:UserData.userInfoData.gender,
            // avatarUrl:UserData.userInfoData.avatarUrl,
            rank:this.selfRankDatas.rank,
            score:this.selfRankDatas.score
        }
        //排名
        let number = 1;
        //段位数据
        let gradeData = {}

        this.myRanking.setItemData(data);
        let fnt = null;
        if (number<9){
            fnt = this.cloneNumber1();
        }else{
            fnt = this.cloneNumber2();
        }

        fnt.x = -301;
        fnt.y = 48;
        fnt.parent = this.myRanking.node;
    }

    onExit(){
        // Sound.playBtn();
        if (!this.isTouch){
            return;
        }
        this.isTouch = false;
        cc.director.loadScene('MainScene');
    }
    


        /**
     * 获取排行榜数据成
     * @param event 
     */
    getRankRecordSuccess(event){
            let datas = event.getUserData();
            let self = datas.self;

            this.rankDatas = datas.all;
            // UserData.mMyMaxScore = datas.self.score;
            this.selfRankDatas = datas.self;
            this.hideMask();
            this.initDatas();
        
    }

    /**
     * 获取排行榜数据失败
     * @param event 
     */
    getRankRecordErr(event){
        let datas = event.getUserData();
        cc.log('失败');
        this.hideMask();
    }

    onDestroy(){
        // cc.systemEvent.off(FeigoGameRecord.EEventNames.GET_RANK_RECORD_SUCCESS, this.getRankRecordSuccess, this);
        // cc.systemEvent.off(FeigoGameRecord.EEventNames.GET_RANK_RECORD_ERROR, this.getRankRecordErr, this);
    }
    // update (dt) {},
}
