"use strict";
cc._RF.push(module, '376852J9iVCZLxzJX/zWUUf', 'RankingItem');
// Script/Ranking/RankingItem.ts

// import GradeNode from "../MainScene/UserInfo/GradeNode";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * copyright (c) 厦门风领科技有限公司
 * http://www.fenglinghudong.com/
 *
 * 组件功能
 * 徐斌杰
 * 2018-00-00
 */
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var RankingItem = /** @class */ (function (_super) {
    __extends(RankingItem, _super);
    function RankingItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * 玩家昵称
         */
        _this.nick = null;
        /**
     * 玩家头像
     */
        _this.avatar = null;
        /**
     * 性别男
     */
        _this.man = null;
        /**
     * 性别女
     */
        _this.woman = null;
        // /**
        //  * 段位组件
        //  */
        // gradeNodeCom:GradeNode = null;
        /**
         * 最大分数
         */
        _this.lbMaxScore = null;
        /**
         * 数据
         */
        _this.data = null;
        return _this;
        // update (dt) {},
    }
    RankingItem.prototype.onLoad = function () {
        // this.gradeNodeCom = this.node.getChildByName('gradeNode').getComponent(GradeNode);
        this.man.active = false;
        this.woman.active = false;
    };
    /**
     * 设置背景
     */
    RankingItem.prototype.setBG = function (spriteFrame) {
        this.node.getComponent(cc.Sprite).spriteFrame = spriteFrame;
    };
    /**
     *
     * @param data
     */
    RankingItem.prototype.setItemData = function (data) {
        this.data = data;
        this.nick.string = data.nickName;
        this.showSex(data.gender);
        this.setAvatar(data.avatarUrl);
        this.lbMaxScore.string = data.score;
        //设置段位数据
        // this.gradeNodeCom.setData(data.xxx);
    };
    RankingItem.prototype.setAvatar = function (url) {
        var _this = this;
        if (!url) {
            return;
        }
        ;
        var self = this;
        cc.loader.load({ url: url, type: 'png' }, function (err, texture) {
            if (err) {
                return;
            }
            var spriteFrame = new cc.SpriteFrame();
            spriteFrame.setTexture(texture);
            _this.avatar.spriteFrame = spriteFrame;
        });
    };
    /**
     *
     * @param gender
     */
    RankingItem.prototype.showSex = function (gender) {
        if (gender === 1) {
            this.man.active = true;
        }
        else {
            this.woman.active = true;
        }
    };
    __decorate([
        property({
            type: cc.Label,
            tooltip: '玩家昵称'
        })
    ], RankingItem.prototype, "nick", void 0);
    __decorate([
        property({
            type: cc.Sprite,
            tooltip: '玩家头像'
        })
    ], RankingItem.prototype, "avatar", void 0);
    __decorate([
        property({
            type: cc.Node,
            tooltip: '性别男'
        })
    ], RankingItem.prototype, "man", void 0);
    __decorate([
        property({
            type: cc.Node,
            tooltip: '性别女'
        })
    ], RankingItem.prototype, "woman", void 0);
    __decorate([
        property({
            type: cc.Label,
            tooltip: '最大分数'
        })
    ], RankingItem.prototype, "lbMaxScore", void 0);
    RankingItem = __decorate([
        ccclass
    ], RankingItem);
    return RankingItem;
}(cc.Component));
exports.default = RankingItem;

cc._RF.pop();