(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/Ranking/RankingLayer.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '6be55Pko5RElIqm34E6FNp4', 'RankingLayer', __filename);
// Script/Ranking/RankingLayer.ts

Object.defineProperty(exports, "__esModule", { value: true });
var RankingItem_1 = require("./RankingItem");
/**
 * copyright (c) 厦门风领科技有限公司
 * http://www.fenglinghudong.com/
 *
 * 组件功能
 * 徐斌杰
 * 2018-00-00
 */
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var RankingLayer = /** @class */ (function (_super) {
    __extends(RankingLayer, _super);
    function RankingLayer() {
        // /**
        //  * 
        //  */
        // @property({
        //     type:cc.Node,
        //     tooltip:''
        // })
        // propertyName: cc.Node = null;
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lbNumber1 = null;
        _this.lbNumber2 = null;
        /**
         * 前三项的背景
         */
        _this.itemBg = null;
        _this.content = null;
        _this.preItem = null;
        /**
         * 我的排名项
         */
        _this.myRanking = null;
        /**
         * 是否可以点击
         */
        _this.isTouch = false;
        /**
         * 遮罩
         */
        _this.mask = null;
        /**
         * 排行榜数据
         */
        _this.rankDatas = [];
        /**
         * 自己的排行榜数据
         */
        _this.selfRankDatas = null;
        return _this;
        // update (dt) {},
    }
    RankingLayer.prototype.onLoad = function () {
        // this.mask = this.node.parent.getChildByName('mask');
        // cc.systemEvent.on(FeigoGameRecord.EEventNames.GET_RANK_RECORD_SUCCESS, this.getRankRecordSuccess, this);
        // cc.systemEvent.on(FeigoGameRecord.EEventNames.GET_RANK_RECORD_ERROR, this.getRankRecordErr, this);
        this.isTouch = true;
        // FeigoGameRecord.getRankRecordList(0, 10);
    };
    /**
 * 显示遮罩
 */
    RankingLayer.prototype.showMask = function () {
        // this.mask.active = true;
    };
    /**
     *
     */
    RankingLayer.prototype.hideMask = function () {
        // this.mask.active = false;
    };
    /**
     * 初始化排行榜数据
     * 我的排行数据
     */
    RankingLayer.prototype.initDatas = function () {
        var datas = this.rankDatas;
        for (var i = 0; i < datas.length; i++) {
            var data = datas[i];
            this.createItem(data, i);
        }
        this.setMyRanking();
    };
    /**
     * 克隆1-9的数字
     */
    RankingLayer.prototype.cloneNumber1 = function () {
        var node = cc.instantiate(this.lbNumber1);
        return node;
    };
    /**
 * 克隆1-9的数字
 */
    RankingLayer.prototype.cloneNumber2 = function () {
        var node = cc.instantiate(this.lbNumber2);
        return node;
    };
    /**
     * 创建排名项
     * @param data
     */
    RankingLayer.prototype.createItem = function (data, i) {
        var fnt = null;
        /**
         * 设置排名数字
         */
        if (i < 9) {
            fnt = this.cloneNumber1();
        }
        else {
            fnt = this.cloneNumber2();
        }
        var node = cc.instantiate(this.preItem);
        node.x = 0;
        /**
         * 设置背景底图
         */
        if (i < 3) {
            node.getComponent(RankingItem_1.default).setBG(this.itemBg);
        }
        node.getComponent(RankingItem_1.default).setItemData(data);
        node.parent = this.content;
        fnt.parent = node;
        fnt.x = -226;
        fnt.y = 61;
        fnt.getComponent(cc.Label).string = i + 1;
    };
    /**
     * 设置我的排名
     */
    RankingLayer.prototype.setMyRanking = function () {
        var data = {
            // nickName:UserData.userInfoData.nickName,
            // gender:UserData.userInfoData.gender,
            // avatarUrl:UserData.userInfoData.avatarUrl,
            rank: this.selfRankDatas.rank,
            score: this.selfRankDatas.score
        };
        //排名
        var number = 1;
        //段位数据
        var gradeData = {};
        this.myRanking.setItemData(data);
        var fnt = null;
        if (number < 9) {
            fnt = this.cloneNumber1();
        }
        else {
            fnt = this.cloneNumber2();
        }
        fnt.x = -301;
        fnt.y = 48;
        fnt.parent = this.myRanking.node;
    };
    RankingLayer.prototype.onExit = function () {
        // Sound.playBtn();
        if (!this.isTouch) {
            return;
        }
        this.isTouch = false;
        cc.director.loadScene('MainScene');
    };
    /**
 * 获取排行榜数据成
 * @param event
 */
    RankingLayer.prototype.getRankRecordSuccess = function (event) {
        var datas = event.getUserData();
        var self = datas.self;
        this.rankDatas = datas.all;
        // UserData.mMyMaxScore = datas.self.score;
        this.selfRankDatas = datas.self;
        this.hideMask();
        this.initDatas();
    };
    /**
     * 获取排行榜数据失败
     * @param event
     */
    RankingLayer.prototype.getRankRecordErr = function (event) {
        var datas = event.getUserData();
        cc.log('失败');
        this.hideMask();
    };
    RankingLayer.prototype.onDestroy = function () {
        // cc.systemEvent.off(FeigoGameRecord.EEventNames.GET_RANK_RECORD_SUCCESS, this.getRankRecordSuccess, this);
        // cc.systemEvent.off(FeigoGameRecord.EEventNames.GET_RANK_RECORD_ERROR, this.getRankRecordErr, this);
    };
    __decorate([
        property({
            type: cc.Node,
            tooltip: '前9的数字'
        })
    ], RankingLayer.prototype, "lbNumber1", void 0);
    __decorate([
        property({
            type: cc.Node,
            tooltip: '10以后的数字'
        })
    ], RankingLayer.prototype, "lbNumber2", void 0);
    __decorate([
        property({
            type: cc.SpriteFrame,
            tooltip: '前三项的背景'
        })
    ], RankingLayer.prototype, "itemBg", void 0);
    __decorate([
        property({
            type: cc.Node,
            tooltip: '内容'
        })
    ], RankingLayer.prototype, "content", void 0);
    __decorate([
        property({
            type: cc.Prefab,
            tooltip: 'item预设'
        })
    ], RankingLayer.prototype, "preItem", void 0);
    __decorate([
        property({
            type: RankingItem_1.default,
            tooltip: '我的排名项'
        })
    ], RankingLayer.prototype, "myRanking", void 0);
    RankingLayer = __decorate([
        ccclass
    ], RankingLayer);
    return RankingLayer;
}(cc.Component));
exports.default = RankingLayer;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=RankingLayer.js.map
        