const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property(cc.Label)
    time: cc.Label = null;

    @property(cc.Node)
    nodeA: cc.Node = null;

    @property(cc.Node)
    nodeB: cc.Node = null;

    _time: number = 5;
    _isEnd: boolean = false;
    onLoad() {
        this.nodeA.on(cc.Node.EventType.TOUCH_END, () => {
            this.label.string = '点击节点A结束,点击cocos图标无响应';
        });
        this.nodeA.on(cc.Node.EventType.TOUCH_MOVE, () => {
            if (!this._isEnd) {
                this.label.string = '正在点击节点B移动';
            }
        });
        this.nodeB.on(cc.Node.EventType.TOUCH_END, (event: cc.Event.EventTouch) => {
            this.label.string = '点击节点B';
            event.stopPropagation();
        });
    }

    click_btn_cocos() {
        this.label.string = '请点击nodeA进行不断的移动';

        this._isEnd = false;
        this._time = 5;
        this.nodeB.active = false;
        let td = setInterval(() => {
            this._time--;
            if (this._time <= 0) {
                this.nodeB.active = true;
                this._isEnd = true;
                this.label.string = '请松开nodeA的点击';
                clearInterval(td);
            }
            this.time.string = this._time.toString();
        }, 1000);
    }
}
