// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class FixedWidthLayout extends cc.Component {

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    onLoad() {
        let totalWidth = 0;
        this.node.children.forEach(v => {
            totalWidth += v.width;
        })
        // 总宽度超出容器宽度，进行缩放
        if (totalWidth > this.node.width){
            let ratio = this.node.width / totalWidth
            this.node.children.forEach(v => {
                v.width *= ratio
                v.height *= ratio
            });
        }
        let maxHeight = 0;
        let space = this.node.width <= totalWidth ? 0 : (this.node.width - totalWidth) / (this.node.children.length - 1)
        let left = -this.node.width / 2;
        // 排列
        this.node.children.forEach((v,i) => {
            v.x = (i * space) + left + v.width / 2
            left += v.width;
            if (maxHeight < v.height) {
                maxHeight = v.height
            }
        });
        this.node.height = maxHeight
    }

    // update (dt) {}
}
