const { ccclass, property } = cc._decorator;
import Proxy from "./Lib/Proxy";

@ccclass
export default class Flow extends cc.Component {

    @property(cc.Label)
    speedLabel: cc.Label = null;

    @property
    speed: number = 100;

    /**
     * 滚动内容
     */
    contents: cc.Node[] = []

    /**
     * 滚动状态
     */
    flowStatus: boolean = false;

    overflowed: { [key: string]: cc.Node } = {};

    start() {
        // init logic
        this.speedLabel.string = this.speed.toString();
        // this.node.anchorY = 1;
    }

    update(dt: number) {
        if (this.flowStatus === false) {
            return;
        }
        let r = 0
        for (let i = 0; i < this.contents.length; i++) {
            const element = this.contents[i];
            // let proxy = element.getComponent(Proxy)
            element.y -= dt * this.speed
            // proxy.setY(element.y - dt * this.speed)
            if (element.y <= -this.node.height) {
                if (!this.overflowed[element.uuid]) {
                    this.overflowed[element.uuid] = element
                    cc.log("reach border", element.uuid)
                }
                if (element.y < -this.node.height - element.height / 2) {
                    cc.log("destory")
                    this.contents.splice(i, 1)
                    delete this.overflowed[element.uuid]
                    element.destroy()
                }
            }
        }
    }

    /**
     * 开启滚动
     */
    startFlow() {
        this.flowStatus = true
    }

    /**
     * 停止滚动
     */
    stopFlow() {
        this.flowStatus = false
    }

    feed(generator) {
        let node = generator.next().value
        this.addLine(<cc.Node>node)
    }

    /**
     * 添加一行待滚动内容
     * @param lineNode 待滚动行节点
     */
    addLine(lineNode: cc.Node) {
        let lastPosition = cc.v2(0, 0)
        if (this.contents.length > 0) {
            let lastNode = this.contents[this.contents.length - 1]
            lastPosition.y = lastNode.y + lastNode.height / 2
        }
        this.node.addChild(lineNode)
        lineNode.setPosition(0, lastPosition.y + lineNode.height / 2)
        this.contents.push(lineNode)
    }

    isOverFlow(): boolean {
        return this.contents.length > 30
        // let totalHeight = 0
        // cc.log('this.contents', this.contents)
        // let overFlow = false
        // this.contents.forEach(v => {
        //     totalHeight += v.height
        //     if (totalHeight > this.node.height * 1.5) {
        //         overFlow = true
        //     }
        // });
        // cc.log('total height', totalHeight, this.node.height)
        // cc.log('overFlow', overFlow)
        // return overFlow
    }
}
