const { ccclass, property } = cc._decorator;

@ccclass
export default class FixCameraPosition extends cc.Component {

    position: cc.Vec2;

    start() {
        this.node.on(cc.Node.EventType.TOUCH_START, this.clickEvent, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.clickEvent, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.clickEvent, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.clickEvent, this);
    }

    clickEvent(event: cc.Event) {
        switch (event.type) {
            case 'touchstart':
                this.position = this.node.position;
                break;
            case 'touchmove':
                this.node.setPosition(this.node.position.sub((<cc.Touch><unknown>event).getDelta()));
                break;
            case 'touchend':
            case 'touchcancel':
                this.node.setPosition(this.position);
                break;
        }
    }
}
