import LabelProxy from "./LabelProxy";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Proxy extends cc.Component {

    /**
     * 附属目标节点，所有label附属到此节点上，达到同一层的目的
     */
    @property(cc.Node)
    target: cc.Node = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    exchange(nodeHasLabel: cc.Node, labelNodeName: string) {
        let labelNode = nodeHasLabel.getChildByName(labelNodeName)
        if(!labelNode){
            cc.log("exchange failed: given node does not has a child name is " + labelNodeName)
            return false;
        }
        let dummyLabel = new LabelProxy()
        dummyLabel.setTarget(labelNode)
        dummyLabel.parent = labelNode.parent;
        cc.log("exchange", dummyLabel, labelNode)
        labelNode.parent = this.target
    }
}
