import Flow from "./Flow";
import Word from "../Prefab/word";
import Util from "./Lib/Util";
import Poetry from "./Lib/Poetry";
import Proxy from "./Lib/Proxy";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Main extends cc.Component {

    @property(cc.Prefab)
    linePrefab: cc.Prefab = null;

    @property(cc.Prefab)
    wordPrefab: cc.Prefab = null;

    @property(cc.Node)
    flowNode: cc.Node = null;

    @property(cc.Label)
    scoreNode: cc.Label = null;
    score: number = 0;

    proxy: Proxy = null;

    wordNodePool: cc.NodePool = null;
    lineNodePool: cc.NodePool = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.proxy = this.getComponent(Proxy)
        cc.log("this.proxy as main", this.proxy)
        this.lineNodePool = new cc.NodePool("FlowLine")
        for (let i = 0; i < 20; ++i){
            this.lineNodePool.put(cc.instantiate(this.linePrefab))
        }
        this.wordNodePool = new cc.NodePool("Word")
        for (let i = 0; i < 50; i++) {
            this.wordNodePool.put(cc.instantiate(this.wordPrefab))
        }
    }

    * wordGenerator(): any {
        while (true) {
            let poetry = this.getPoetry()
            for (let i = 0; i < poetry.sentences.length; ++i) {
                const sentence = poetry.sentences[i]
                cc.log("generate sentence", sentence)
                for (let j = 0; j < sentence.length; ++j) {
                    cc.log("yield", sentence[j])
                    yield sentence[j]
                }
            }
        }
    }

    feed(flow: Flow, wordGenerator, misleads: string) {
        while (!flow.isOverFlow()) {
            let word = wordGenerator.next()
            if (word.done) {
                cc.log('level up!')
                return false;
            }
            let lineText = this.getLineWords(word.value, misleads, 5)
            let lineNode = this.getLineNode(lineText, word.value)
            flow.addLine(lineNode)
            cc.log('added', lineNode)
        }
    }

    start() {
        let misleads = '阿隆多足彩晒空邓娜三'
        let wordGenerator = this.wordGenerator()
        let flow = this.flowNode.getComponent(Flow)
        this.feed(flow, wordGenerator, misleads)
        let s = () => {
            cc.log("schedule")
            if (this.feed(flow, wordGenerator, misleads) === false) {
                cc.log("unschedule")
                this.getComponent(Main).unschedule(s)
            }
        }
        this.getComponent(Main).schedule(s, 2)
        // flow.startFlow()
        // flow.feed(this.feed())
        // ALL:
        // for (let i = 0; i < lines.length; i++) {
        //     const sentence = lines[i];
        //     for (let j = 0; j < sentence.length; ++j) {
        //         const word = sentence[j]
        //         let lineWords = this.getLineWords(word, mislead, 5)

        //         flow.addLine(lineNode)
        //         if (flow.isOverFlow()) {
        //             break ALL;
        //         }
        //     }
        // }
        // flow.startFlow()
        // setTimeout(() => {
        //     flow.stopFlow()
        // }, 5000);
    }

    getPoetry(): Poetry {
        let title = '静夜思';
        let author = '李白'
        let sentences = ['床前明月光', '疑是地上霜', '举头望明月', '低头思故乡'];
        return new Poetry(title, author, sentences);
    }

    getLineWords(word: string, misleadWords: string, wordCount: number) {
        let pos = Util.random(0, wordCount - 1)
        let lineWords = []
        for (let i = 0; i < wordCount; ++i) {
            if (i == pos) {
                lineWords.push(word)
            } else {
                lineWords.push(misleadWords.charAt(Util.random(0, misleadWords.length - 1)))
            }
        }
        return lineWords.join('')
    }

    getLineNode(lineWords: string, correctWord: string): cc.Node {
        let lineNode = null;
        if (this.lineNodePool.size() > 0){
            lineNode = this.lineNodePool.get()
        }else{
            lineNode = cc.instantiate(this.linePrefab)
        }
        for (let k = 0; k < lineWords.length; ++k) {
            let wordNode = null;
            if (this.wordNodePool.size() > 0){
                wordNode = this.wordNodePool.get()
            }else{
                wordNode = cc.instantiate(this.wordPrefab)
            }
            // exchange label to dummy label
            // this.proxy.exchange(wordNode, 'word label')

            wordNode.getComponent(Word).setWord(lineWords[k])
            wordNode.on(cc.Node.EventType.TOUCH_START, (event: cc.Event) => {
                let correct = lineWords[k] == correctWord
                if (correct) {
                    ++this.score;
                } else {
                    --this.score;
                }
                this.scoreNode.string = this.score.toString()
                cc.log("tap word", event, wordNode, lineWords[k], correct)
                this.wordNodePool.put(wordNode)
                // wordNode.destroy()
            })
            lineNode.addChild(wordNode)
        }
        // lineNode.getComponent(Proxy).setListener(this.proxy)
        return lineNode
    }
}
