#include "HelloWorldScene.h"
#include "AppMacros.h"
#include "base/ccUtils.h"
//#Include "ccImage.h"

USING_NS_CC;


Scene* HelloWorld::scene()
{
     return HelloWorld::create();
}

// on "init" you need to initialize your instance
bool HelloWorld::init()
{
    //////////////////////////////
    // 1. super init first
    if ( !Scene::init() )
    {
        return false;
    }
    
    auto visibleSize = Director::getInstance()->getVisibleSize();
    auto origin = Director::getInstance()->getVisibleOrigin();

    /////////////////////////////
    // 2. add a menu item with "X" image, which is clicked to quit the program
    //    you may modify it.

    // add a "close" icon to exit the progress. it's an autorelease object
    auto closeItem = MenuItemImage::create(
                                        "CloseNormal.png",
                                        "CloseSelected.png",
                                        CC_CALLBACK_1(HelloWorld::menuCloseCallback,this));
    
    closeItem->setPosition(origin + Vec2(visibleSize) - Vec2(closeItem->getContentSize() / 2));

    // create menu, it's an autorelease object
    auto menu = Menu::create(closeItem, nullptr);
    menu->setPosition(Vec2::ZERO);
    this->addChild(menu, 1);
    
    /////////////////////////////
    // 3. add your codes below...

    // add a label shows "Hello World"
    // create and initialize a label
    
    auto label = Label::createWithTTF("Hello World", "fonts/arial.ttf", TITLE_FONT_SIZE);
    
    // position the label on the center of the screen
    label->setPosition(origin.x + visibleSize.width/2,
                            origin.y + visibleSize.height - label->getContentSize().height);

    // add the label as a child to this layer
    this->addChild(label, 1);

    // add "HelloWorld" splash screen"
//    auto sprite = Sprite::create("HelloWorld.png");

    // position the sprite on the center of the screen
//    sprite->setPosition(Vec2(visibleSize / 2) + origin);

    // add the sprite as a child to this layer
//    this->addChild(sprite);
    
    
    //test
    auto bg = LayerColor::create(Color4B(128,128,128,255),320,220);
    bg->setAnchorPoint(Vec2(0.5,0.5));
    bg->setIgnoreAnchorPointForPosition(false);
    bg->setPosition(Vec2(visibleSize / 2));
    this->addChild(bg);
    auto scroll = cocos2d::extension::ScrollView::create(Size(300,200));
    scroll->setAnchorPoint(Vec2(0.5,0.5));
    scroll->setIgnoreAnchorPointForPosition(false);
    scroll->setPosition(Vec2(bg->getContentSize() / 2) + origin);
    bg->addChild(scroll);
    auto spriteItem = Sprite::create("HelloWorld.png");
    spriteItem->setAnchorPoint(Vec2(0,0));
    scroll->addChild(spriteItem);
    this->scroll = scroll;
    
    return true;
}

void HelloWorld::menuCloseCallback(Ref* sender)
{
//    Director::getInstance()->end();
//
//#if (CC_TARGET_PLATFORM == CC_PLATFORM_IOS)
//    exit(0);
//#endif
   Image* image = utils::captureNode(this,1);
    //测试看截图
    std::string outputFile = FileUtils::getInstance()->getWritablePath() + "test.png";
    cocos2d::log("outputFile = %s",outputFile.c_str());
    image->saveToFile(outputFile);
    CC_SAFE_RELEASE(image);
}
