"use strict";
cc._RF.push(module, 'c906a7NJeRLO5Va7iv/2Z6V', 'Test');
// Script/Test.ts

// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Test = /** @class */ (function (_super) {
    __extends(Test, _super);
    function Test() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.monsterPrefab = null;
        _this.img = null;
        _this.nodePool = null;
        _this._time = 0;
        return _this;
    }
    Test.prototype.start = function () {
        this.nodePool = new cc.NodePool();
    };
    Test.prototype.putToNodePool = function (monster) {
        this.nodePool.put(monster);
    };
    Test.prototype.getFromNodePool = function () {
        return this.nodePool.get();
    };
    Test.prototype.createMonster = function () {
        var monster = this.getFromNodePool();
        if (!monster) {
            monster = cc.instantiate(this.monsterPrefab);
            //monster = cc.instantiate(this.img);
        }
        monster.x = 400;
        monster.y = 10;
        this.node.addChild(monster);
        monster.runAction(cc.sequence(cc.moveBy(8, 0, 400), cc.callFunc(this.die.bind(this))));
    };
    Test.prototype.die = function (target) {
        this.putToNodePool(target);
    };
    Test.prototype.update = function (dt) {
        //5秒钟出一个怪
        this._time += dt;
        if (this._time > 5) {
            this._time = 0;
            this.createMonster();
        }
    };
    __decorate([
        property(cc.Prefab)
    ], Test.prototype, "monsterPrefab", void 0);
    __decorate([
        property(cc.Node)
    ], Test.prototype, "img", void 0);
    Test = __decorate([
        ccclass
    ], Test);
    return Test;
}(cc.Component));
exports.default = Test;

cc._RF.pop();