const { ccclass, property } = cc._decorator;

@ccclass
export default class TestScene extends cc.Component {
    private static ANIMATION_PERMANENT_RES: string = 'walk';
    private static ANIMATION_TEMPORARY_RES: string = 'shoot';
    private static RES_URL_PERMANENT: string = 'permanent/spineboy';
    private static RES_URL_TEMPORARY: string = 'temporary/spineboy';
    private _permanentResource: sp.SkeletonData = null;
    private _temporaryResource: sp.SkeletonData = null;

    @property(cc.Node)
    root: cc.Node = null;

    @property(cc.Mask)
    mask: cc.Mask = null;

    @property(sp.Skeleton)
    skeleton: sp.Skeleton = null;

    @property(cc.Label)
    label: cc.Label = null;

    start() {
        // load permanent resource(not relelease skeleton data)
        const completeCallback = (error: Error, resource: any) => {
            this._permanentResource = resource;
        };
        cc.loader.loadRes(TestScene.RES_URL_PERMANENT, sp.SkeletonData, completeCallback);
    }

    onDestroy() {
        this.releaseResource(this._temporaryResource);
        this._temporaryResource = null;
        this.releaseResource(this._permanentResource);
        this._permanentResource = null;
    }

    releaseResource(resource: sp.SkeletonData) {
        if (!resource) {
            return;
        }
        //cc.loader.releaseRes(TestScene.RES_URL_TEMPORARY);
        const deps = cc.loader.getDependsRecursively(resource);
        cc.loader.release(deps);
    }

    onClickTempResLoad() {
        if (this._temporaryResource) {
            return;
        }
        // load temporary resource & set
        const completeCallback = (error: Error, resource: any) => {
            this._temporaryResource = resource;
            this.skeleton.skeletonData = this._temporaryResource;
            this.skeleton.animation = TestScene.ANIMATION_TEMPORARY_RES;
            this.label.string = 'show temporary resource';
        };
        cc.loader.loadRes(TestScene.RES_URL_TEMPORARY, sp.SkeletonData, completeCallback);
    }

    onClickTempResRelease() {
        // release temporary resource
        this.releaseResource(this._temporaryResource);
        this._temporaryResource = null;
        this.skeleton.skeletonData = null;

        // overwrite permanent resource
        this.skeleton.skeletonData = this._permanentResource;
        this.skeleton.animation = TestScene.ANIMATION_PERMANENT_RES;
        this.label.string = 'show permanent resource';
    }

    onToggleMaskEnabled() {
        // toggle mask enabled
        this.mask.enabled = !this.mask.enabled;
    }
}
