"use strict";
cc._RF.push(module, 'e1b90/rohdEk4SdmmEZANaD', 'TestScene');
// Script/TestScene.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TestScene = /** @class */ (function (_super) {
    __extends(TestScene, _super);
    function TestScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._permanentResource = null;
        _this._temporaryResource = null;
        _this.root = null;
        _this.mask = null;
        _this.skeleton = null;
        _this.label = null;
        return _this;
    }
    TestScene_1 = TestScene;
    TestScene.prototype.start = function () {
        var _this = this;
        // load permanent resource(not relelease skeleton data)
        var completeCallback = function (error, resource) {
            _this._permanentResource = resource;
        };
        cc.loader.loadRes(TestScene_1.RES_URL_PERMANENT, sp.SkeletonData, completeCallback);
    };
    TestScene.prototype.onDestroy = function () {
        this.releaseResource(this._temporaryResource);
        this._temporaryResource = null;
        this.releaseResource(this._permanentResource);
        this._permanentResource = null;
    };
    TestScene.prototype.releaseResource = function (resource) {
        if (!resource) {
            return;
        }
        //cc.loader.releaseRes(TestScene.RES_URL_TEMPORARY);
        var deps = cc.loader.getDependsRecursively(resource);
        cc.loader.release(deps);
    };
    TestScene.prototype.onClickTempResLoad = function () {
        var _this = this;
        if (this._temporaryResource) {
            return;
        }
        // load temporary resource & set
        var completeCallback = function (error, resource) {
            _this._temporaryResource = resource;
            _this.skeleton.skeletonData = _this._temporaryResource;
            _this.skeleton.animation = TestScene_1.ANIMATION_TEMPORARY_RES;
            _this.label.string = 'show temporary resource';
        };
        cc.loader.loadRes(TestScene_1.RES_URL_TEMPORARY, sp.SkeletonData, completeCallback);
    };
    TestScene.prototype.onClickTempResRelease = function () {
        // release temporary resource
        this.releaseResource(this._temporaryResource);
        this._temporaryResource = null;
        this.skeleton.skeletonData = null;
        // overwrite permanent resource
        this.skeleton.skeletonData = this._permanentResource;
        this.skeleton.animation = TestScene_1.ANIMATION_PERMANENT_RES;
        this.label.string = 'show permanent resource';
    };
    TestScene.prototype.onToggleMaskEnabled = function () {
        // toggle mask enabled
        this.mask.enabled = !this.mask.enabled;
    };
    var TestScene_1;
    TestScene.ANIMATION_PERMANENT_RES = 'walk';
    TestScene.ANIMATION_TEMPORARY_RES = 'shoot';
    TestScene.RES_URL_PERMANENT = 'permanent/spineboy';
    TestScene.RES_URL_TEMPORARY = 'temporary/spineboy';
    __decorate([
        property(cc.Node)
    ], TestScene.prototype, "root", void 0);
    __decorate([
        property(cc.Mask)
    ], TestScene.prototype, "mask", void 0);
    __decorate([
        property(sp.Skeleton)
    ], TestScene.prototype, "skeleton", void 0);
    __decorate([
        property(cc.Label)
    ], TestScene.prototype, "label", void 0);
    TestScene = TestScene_1 = __decorate([
        ccclass
    ], TestScene);
    return TestScene;
}(cc.Component));
exports.default = TestScene;

cc._RF.pop();