//1.4.11.3.mini
namespace TJ
{
    export class Num
    {
        protected _value: number;

        public constructor(value: number)
        {
            this._value = value;
        }

        public get value(): number
        {
            return this._value;
        }

        public toString(): string
        {
            return "" + this.value;
        }
    }
    export class Int extends Num
    {
        public get value(): number
        {
            return Math.floor(this._value);
        }

        public get javaSignature(): string
        {
            return "I";
        }
    }
    export class Float extends Num
    {
        public get javaSignature(): string
        {
            return "F";
        }
    }
    export class Bool
    {
        protected _value: boolean;

        public constructor(value: boolean)
        {
            this._value = value;
        }

        public get value(): boolean
        {
            return this._value;
        }

        public toString(): string
        {
            return "" + this.value;
        }

        public get javaSignature(): string
        {
            return "Z";
        }
    }
    export class Str
    {
        protected _value: string;

        public constructor(value: string)
        {
            this._value = value;
        }

        public get value(): string
        {
            return this._value;
        }

        public toString(): string
        {
            return "" + this.value;
        }

        public get javaSignature(): string
        {
            return "Ljava/lang/String;";
        }
    }
    export class MD5
    {

        private hexcase = 0;   /* hex output format. 0 - lowercase; 1 - uppercase        */
        private b64pad = "";  /* base-64 pad character. "=" for strict RFC compliance   */

        /*
        * These are the privates you'll usually want to call
        * They take string arguments and return either hex or base-64 encoded strings
        */
        public hex_md5(s: string) { return this.rstr2hex(this.rstr_md5(this.str2rstr_utf8(s))); }//这个函数就行了，
        public b64_md5(s: string) { return this.rstr2b64(this.rstr_md5(this.str2rstr_utf8(s))); }
        public any_md5(s: string, e: string) { return this.rstr2any(this.rstr_md5(this.str2rstr_utf8(s)), e); }
        public hex_hmac_md5(k: string, d: string) { return this.rstr2hex(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d))); }
        public b64_hmac_md5(k: string, d: string) { return this.rstr2b64(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d))); }
        public any_hmac_md5(k: string, d: string, e: string) { return this.rstr2any(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d)), e); }

        /*
        * Calculate the MD5 of a raw string
        */
        public rstr_md5(s: string)
        {
            return this.binl2rstr(this.binl_md5(this.rstr2binl(s), s.length * 8));
        }

        /*
        * Calculate the HMAC-MD5, of a key and some data (raw strings)
        */
        public rstr_hmac_md5(key: string, data: string)
        {
            let bkey = this.rstr2binl(key);
            if (bkey.length > 16) bkey = this.binl_md5(bkey, key.length * 8);

            let ipad = Array(16), opad = Array(16);
            for (let i = 0; i < 16; i++)
            {
                ipad[i] = bkey[i] ^ 0x36363636;
                opad[i] = bkey[i] ^ 0x5C5C5C5C;
            }

            let hash = this.binl_md5(ipad.concat(this.rstr2binl(data)), 512 + data.length * 8);
            return this.binl2rstr(this.binl_md5(opad.concat(hash), 512 + 128));
        }

        /*
        * Convert a raw string to a hex string
        */
        public rstr2hex(input: string)
        {
            try { this.hexcase } catch (e) { this.hexcase = 0; }
            let hex_tab = this.hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
            let output = "";
            let x;
            for (let i = 0; i < input.length; i++)
            {
                x = input.charCodeAt(i);
                output += hex_tab.charAt((x >>> 4) & 0x0F)
                    + hex_tab.charAt(x & 0x0F);
            }
            return output;
        }

        /*
        * Convert a raw string to a base-64 string
        */
        public rstr2b64(input: string)
        {
            try { this.b64pad } catch (e) { this.b64pad = ''; }
            let tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            let output = "";
            let len = input.length;
            for (let i = 0; i < len; i += 3)
            {
                let triplet = (input.charCodeAt(i) << 16)
                    | (i + 1 < len ? input.charCodeAt(i + 1) << 8 : 0)
                    | (i + 2 < len ? input.charCodeAt(i + 2) : 0);
                for (let j = 0; j < 4; j++)
                {
                    if (i * 8 + j * 6 > input.length * 8) output += this.b64pad;
                    else output += tab.charAt((triplet >>> 6 * (3 - j)) & 0x3F);
                }
            }
            return output;
        }

        /*
        * Convert a raw string to an arbitrary string encoding
        */
        public rstr2any(input: string, encoding: string)
        {
            let divisor = encoding.length;
            let i, j, q, x, quotient;

            /* Convert to an array of 16-bit big-endian values, forming the dividend */
            let dividend = Array(Math.ceil(input.length / 2));
            for (i = 0; i < dividend.length; i++)
            {
                dividend[i] = (input.charCodeAt(i * 2) << 8) | input.charCodeAt(i * 2 + 1);
            }

            /*
            * Repeatedly perform a long division. The binary array forms the dividend,
            * the length of the encoding is the divisor. Once computed, the quotient
            * forms the dividend for the next step. All remainders are stored for later
            * use.
            */
            let full_length = Math.ceil(input.length * 8 /
                (Math.log(encoding.length) / Math.log(2)));
            let remainders = Array(full_length);
            for (j = 0; j < full_length; j++)
            {
                quotient = Array();
                x = 0;
                for (i = 0; i < dividend.length; i++)
                {
                    x = (x << 16) + dividend[i];
                    q = Math.floor(x / divisor);
                    x -= q * divisor;
                    if (quotient.length > 0 || q > 0)
                        quotient[quotient.length] = q;
                }
                remainders[j] = x;
                dividend = quotient;
            }

            /* Convert the remainders to the output string */
            let output = "";
            for (i = remainders.length - 1; i >= 0; i--)
                output += encoding.charAt(remainders[i]);

            return output;
        }

        /*
        * Encode a string as utf-8.
        * For efficiency, this assumes the input is valid utf-16.
        */
        public str2rstr_utf8(input: string)
        {
            let output = "";
            let i = -1;
            let x, y;

            while (++i < input.length)
            {
                /* Decode utf-16 surrogate pairs */
                x = input.charCodeAt(i);
                y = i + 1 < input.length ? input.charCodeAt(i + 1) : 0;
                if (0xD800 <= x && x <= 0xDBFF && 0xDC00 <= y && y <= 0xDFFF)
                {
                    x = 0x10000 + ((x & 0x03FF) << 10) + (y & 0x03FF);
                    i++;
                }

                /* Encode output as utf-8 */
                if (x <= 0x7F)
                    output += String.fromCharCode(x);
                else if (x <= 0x7FF)
                    output += String.fromCharCode(0xC0 | ((x >>> 6) & 0x1F),
                        0x80 | (x & 0x3F));
                else if (x <= 0xFFFF)
                    output += String.fromCharCode(0xE0 | ((x >>> 12) & 0x0F),
                        0x80 | ((x >>> 6) & 0x3F),
                        0x80 | (x & 0x3F));
                else if (x <= 0x1FFFFF)
                    output += String.fromCharCode(0xF0 | ((x >>> 18) & 0x07),
                        0x80 | ((x >>> 12) & 0x3F),
                        0x80 | ((x >>> 6) & 0x3F),
                        0x80 | (x & 0x3F));
            }
            return output;
        }

        /*
        * Encode a string as utf-16
        */
        public str2rstr_utf16le(input: string)
        {
            let output = "";
            for (let i = 0; i < input.length; i++)
                output += String.fromCharCode(input.charCodeAt(i) & 0xFF,
                    (input.charCodeAt(i) >>> 8) & 0xFF);
            return output;
        }

        public str2rstr_utf16be(input: string)
        {
            let output = "";
            for (let i = 0; i < input.length; i++)
                output += String.fromCharCode((input.charCodeAt(i) >>> 8) & 0xFF,
                    input.charCodeAt(i) & 0xFF);
            return output;
        }

        /*
        * Convert a raw string to an array of little-endian words
        * Characters >255 have their high-byte silently ignored.
        */
        public rstr2binl(input: string)
        {
            let output = Array(input.length >> 2);
            for (let i = 0; i < output.length; i++)
                output[i] = 0;
            for (let i = 0; i < input.length * 8; i += 8)
                output[i >> 5] |= (input.charCodeAt(i / 8) & 0xFF) << (i % 32);
            return output;
        }

        /*
        * Convert an array of little-endian words to a string
        */
        public binl2rstr(input: number[])
        {
            let output = "";
            for (let i = 0; i < input.length * 32; i += 8)
                output += String.fromCharCode((input[i >> 5] >>> (i % 32)) & 0xFF);
            return output;
        }

        /*
        * Calculate the MD5 of an array of little-endian words, and a bit length.
        */
        public binl_md5(x: number[], len: number)
        {
            /* append padding */
            x[len >> 5] |= 0x80 << ((len) % 32);
            x[(((len + 64) >>> 9) << 4) + 14] = len;

            let a = 1732584193;
            let b = -271733879;
            let c = -1732584194;
            let d = 271733878;

            for (let i = 0; i < x.length; i += 16)
            {
                let olda = a;
                let oldb = b;
                let oldc = c;
                let oldd = d;

                a = this.md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
                d = this.md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
                c = this.md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
                b = this.md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
                a = this.md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
                d = this.md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
                c = this.md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
                b = this.md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
                a = this.md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
                d = this.md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
                c = this.md5_ff(c, d, a, b, x[i + 10], 17, -42063);
                b = this.md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
                a = this.md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
                d = this.md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
                c = this.md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
                b = this.md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);

                a = this.md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
                d = this.md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
                c = this.md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
                b = this.md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
                a = this.md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
                d = this.md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
                c = this.md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
                b = this.md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
                a = this.md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
                d = this.md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
                c = this.md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
                b = this.md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
                a = this.md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
                d = this.md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
                c = this.md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
                b = this.md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);

                a = this.md5_hh(a, b, c, d, x[i + 5], 4, -378558);
                d = this.md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
                c = this.md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
                b = this.md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
                a = this.md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
                d = this.md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
                c = this.md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
                b = this.md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
                a = this.md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
                d = this.md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
                c = this.md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
                b = this.md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
                a = this.md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
                d = this.md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
                c = this.md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
                b = this.md5_hh(b, c, d, a, x[i + 2], 23, -995338651);

                a = this.md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
                d = this.md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
                c = this.md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
                b = this.md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
                a = this.md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
                d = this.md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
                c = this.md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
                b = this.md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
                a = this.md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
                d = this.md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
                c = this.md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
                b = this.md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
                a = this.md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
                d = this.md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
                c = this.md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
                b = this.md5_ii(b, c, d, a, x[i + 9], 21, -343485551);

                a = this.safe_add(a, olda);
                b = this.safe_add(b, oldb);
                c = this.safe_add(c, oldc);
                d = this.safe_add(d, oldd);
            }
            return [a, b, c, d];
        }

        /*
        * These privates implement the four basic operations the algorithm uses.
        */
        public md5_cmn(q: any, a: any, b: any, x: any, s: any, t: any)
        {
            return this.safe_add(this.bit_rol(this.safe_add(this.safe_add(a, q), this.safe_add(x, t)), s), b);
        }
        public md5_ff(a: any, b: any, c: any, d: any, x: any, s: any, t: any)
        {
            return this.md5_cmn((b & c) | ((~b) & d), a, b, x, s, t);
        }
        public md5_gg(a: any, b: any, c: any, d: any, x: any, s: any, t: any)
        {
            return this.md5_cmn((b & d) | (c & (~d)), a, b, x, s, t);
        }
        public md5_hh(a: any, b: any, c: any, d: any, x: any, s: any, t: any)
        {
            return this.md5_cmn(b ^ c ^ d, a, b, x, s, t);
        }
        public md5_ii(a: any, b: any, c: any, d: any, x: any, s: any, t: any)
        {
            return this.md5_cmn(c ^ (b | (~d)), a, b, x, s, t);
        }

        /*
        * Add integers, wrapping at 2^32. This uses 16-bit operations internally
        * to work around bugs in some JS interpreters.
        */
        public safe_add(x: any, y: any)
        {
            let lsw = (x & 0xFFFF) + (y & 0xFFFF);
            let msw = (x >> 16) + (y >> 16) + (lsw >> 16);
            return (msw << 16) | (lsw & 0xFFFF);
        }

        /*
        * Bitwise rotate a 32-bit number to the left.
        */
        public bit_rol(num: any, cnt: any)
        {
            return (num << cnt) | (num >>> (32 - cnt));
        }
    }
    export class Guid
    {
        public static New()
        {
            let date = new Date();
            let str = date.getTime().toString(16);
            while (str.length < 32)
            {
                str += Math.floor(Math.random() * 16).toString(16);
            }
            let md5 = new MD5();
            return md5.hex_md5(str);
        }
    }
    export class Action
    {
        public constructor(...func)
        {
            for (let item of func)
            {
                if (typeof item == 'function')
                {
                    this.Add(item);
                }
            }
        }

        private invocationList: Function[] = [];

        public GetInvocationList(): Function[]
        {
            return this.invocationList;
        }

        public Add(func: Function | Action)
        {
            if (func != null)
            {
                if (func instanceof Action)
                {
                    for (let item of func.invocationList)
                    {
                        this.Add(item);
                    }
                }
                else
                {
                    this.invocationList.push(func);
                }
            }
            return this;
        }

        public Remove(func: Function | Action)
        {
            if (func != null)
            {
                let id: number;
                if (func instanceof Action)
                {
                    for (let item of func.invocationList)
                    {
                        this.Remove(item);
                    }
                }
                else
                {
                    id = this.invocationList.indexOf(func);
                    if (id >= 0)
                    {
                        this.invocationList.splice(id, 1);
                    }
                }
            }
        }

        public Clear()
        {
            this.invocationList = [];
        }

        public Invoke(...param: any[])
        {
            for (let item of this.invocationList)
            {
                if (item != null)
                {
                    try
                    {
                        item(...param);
                    }
                    catch (error)
                    {
                        console.log(error);
                    }
                }
            }
        }

    }

    window["ExternCallback"] = (guid: string, key: string, json: string) =>
    {
        console.log("ExternCallback = " + guid + " - " + key + " - " + json);
        CallbackManager.Get(guid).Run(EventType[key], json);
    }
    class CallbackManager
    {
        private static callbacks = {};
        public static Set(cbi: CallbackInfo)
        {
            let guid: string = Guid.New();
            this.callbacks[guid] = cbi;
            return guid;
        }
        public static Get(guid: string)
        {
            let cbi: CallbackInfo = this.callbacks[guid];
            if (cbi == null)
            {
                cbi = new CallbackInfo();
            }
            return cbi;
        }
    }

    export class CallbackInfo
    {
        public Clone()
        {
            let cbi = new CallbackInfo();
            for (let key of Object.keys(this.callbacks))
            {
                cbi.callbacks[key] = this.callbacks[key];
            }
            return cbi;
        }
        private callbacks = {};
        public Get(key: any)
        {
            if (key == null) key = '';
            let act = this.callbacks[key] as Action;
            if (act == null) act = new Action();
            return act;
        }
        public Set(key: any, value: Action | Function)
        {
            if (typeof value == 'function')
            {
                value = new Action(value);
            }
            this.callbacks[key] = value;
        }
        public Add(key: any, value: Action | Function)
        {
            this.Set(key, this.Get(key).Add(value));
        }
        public Run(key: any, ...args: any[])
        {
            let cb = this.Get(key);
            if (cb != null)
            {
                for (let item of cb.GetInvocationList())
                {
                    try
                    {
                        item(...args);
                    }
                    catch (error)
                    {
                        console.error(error);
                    }
                }
            }
        }
    }

    export enum EventType
    {
        Click, Close, Expose, NoAds, Reward, NoReward,
        Success, Failure, Error, Cancel, Complete, Statistic,
    }

    export enum Platform
    {
        Unknown, Android, iOS, AppRt, Browser
    }

    export enum Channel
    {
        Unknown, editor, android, iphone, oppoQG, vivoQG, huaweiGame, wxGame, ttGame, qqGame, ucGame, qttGame, _4399
    }

    export namespace Android
    {
        export class Object0
        {
            private objectIndex: string;

            public toString(): string
            {
                return this.objectIndex;
            }

            private constructor(obj: string)
            {
                this.objectIndex = obj;
            }
            public static Get(obj: Int | Float | Bool | Str | string): Object0
            {
                if (typeof obj == 'string')
                {
                    return new Object0(obj);
                }
                else
                {
                    return Java.SetValue(obj);
                }
            }

            public GetValue<T extends Int | Float | Bool | Str>(type: { prototype: T }): T
            {
                if (type == null)
                {
                    return null;
                }
                let obj: any;
                if (type.prototype == Int.prototype)
                {
                    obj = new Int(Java.GetInt(this));
                }
                if (type.prototype == Float.prototype)
                {
                    obj = new Float(Java.GetFloat(this));
                }
                if (type.prototype == Bool.prototype)
                {
                    obj = new Bool(Java.GetBoolean(this));
                }
                if (type.prototype == Str.prototype)
                {
                    obj = new Str(Java.GetString(this));
                }
                return obj;
            }
        }
        export class JavaClass 
        {
            public className: string;

            public constructor(className: string)
            {
                this.className = className;
            }

            public SetStatic(fieldName: string, value: Int | Float | Bool | Str | JavaObject)
            {
                Java.Set(this.className, fieldName, JavaObject.SetValue(value), null);
            }

            public GetStatic<T extends Int | Float | Bool | Str | JavaObject>(type: { prototype: T }, fieldName: string): T
            {
                let jo = Java.Get(this.className, fieldName, null);
                return JavaObject.GetValue(type, jo);
            }

            public CallStatic(methodName: string, ...values: (Int | Float | Bool | Str | JavaObject)[]): void;
            public CallStatic<T extends Int | Float | Bool | Str | JavaObject>(type: { prototype: T }, methodName: string, ...values: (Int | Float | Bool | Str | JavaObject)[]): T;
            public CallStatic(...s)
            {
                let a = s.shift();
                if (typeof a == 'string')
                {
                    Java.Call(this.className, a, JavaObject.SetValues(...s), null);
                }
                else
                {
                    let b = s.shift();
                    let jo = Java.Call(this.className, b, JavaObject.SetValues(...s), null);
                    return JavaObject.GetValue(a, jo);
                }
            }

            public New(...values: (Int | Float | Bool | Str | JavaObject)[])
            {
                return Java.New(this.className, JavaObject.SetValues(...values));
            }

        }
        export class JavaObject 
        {
            private javaClass: JavaClass;
            private object: Object0;

            public toString(): string
            {
                return "" + this.object;
            }

            private constructor(obj: Object0, clazz: JavaClass)
            {
                this.javaClass = clazz;
                this.object = obj;
            }
            public static New(className: string, ...values: (Int | Float | Bool | Str | JavaObject)[])
            {
                let ajc = new JavaClass(className);
                let jo = ajc.New(...values)
                return new JavaObject(jo, ajc);
            }
            public static Get(obj: Object0)
            {
                let ajc = new JavaClass(Java.Class(obj));
                return new JavaObject(obj, ajc);
            }

            public Set(fieldName: string, value: Int | Float | Bool | Str | JavaObject)
            {
                let v: any;
                if (value instanceof JavaObject)
                {
                    v = value.object;
                }
                else
                {
                    v = Object0.Get(value);
                }
                Java.Set(this.javaClass.className, fieldName, v, this.object);
            }

            public Get<T extends Int | Float | Bool | Str | JavaObject>(type: { prototype: T }, fieldName: string): T
            {
                let jo = Java.Get(this.javaClass.className, fieldName, this.object);
                return JavaObject.GetValue(type, jo);
            }

            public Call(methodName: string, ...values: (Int | Float | Bool | Str | JavaObject)[]): void;
            public Call<T extends Int | Float | Bool | Str | JavaObject>(type: { prototype: T }, methodName: string, ...values: (Int | Float | Bool | Str | JavaObject)[]): T;
            public Call(...s)
            {
                let a = s.shift();
                if (typeof a == 'string')
                {
                    Java.Call(this.javaClass.className, a, JavaObject.SetValues(...s), this.object);
                }
                else
                {
                    let b = s.shift();
                    let jo = Java.Call(this.javaClass.className, b, JavaObject.SetValues(...s), this.object);
                    return JavaObject.GetValue(a, jo);
                }
            }


            public static GetValue<T extends Int | Float | Bool | Str | JavaObject>(type: { prototype: T }, obj: Object0): T
            {
                let res: any;
                if (type.prototype == JavaObject.prototype)
                {
                    res = JavaObject.Get(obj);
                }
                else
                {
                    res = obj.GetValue(type as { prototype: Int | Float | Bool | Str });
                }
                return res;
            }
            public static SetValue(value: Int | Float | Bool | Str | JavaObject): Object0
            {
                if (value instanceof JavaObject)
                {
                    return value.object;
                }
                else
                {
                    return Object0.Get(value);
                }
            }
            public static SetValues(...value: (Int | Float | Bool | Str | JavaObject)[]): Object0[]
            {
                let values: Object0[] = [];
                for (let item of value)
                {
                    values.push(JavaObject.SetValue(item));
                }
                return values;
            }
        }
    }

    export namespace iOS
    {
        export class Object0
        {
            private objectIndex: string;

            public toString(): string
            {
                return this.objectIndex;
            }

            private constructor(obj: string)
            {
                this.objectIndex = obj;
            }
            public static Get(obj: Int | Float | Bool | Str | string): Object0
            {
                if (typeof obj == 'string')
                {
                    return new Object0(obj);
                }
                else
                {
                    return Objc.SetValue(obj);
                }
            }

            public GetValue<T extends Int | Float | Bool | Str>(type: { prototype: T }): T
            {
                if (type == null)
                {
                    return null;
                }
                let obj: any;
                if (type.prototype == Int.prototype)
                {
                    obj = new Int(Objc.GetInt(this));
                }
                if (type.prototype == Float.prototype)
                {
                    obj = new Float(Objc.GetFloat(this));
                }
                if (type.prototype == Bool.prototype)
                {
                    obj = new Bool(Objc.GetBoolean(this));
                }
                if (type.prototype == Str.prototype)
                {
                    obj = new Str(Objc.GetString(this));
                }
                return obj;
            }
        }
        export class ObjcClass
        {
            public className: string;

            public constructor(className: string)
            {
                this.className = className;
            }

            public SetStatic(fieldName: string, value: Int | Float | Bool | Str | ObjcObject)
            {
                Objc.Set(this.className, fieldName, ObjcObject.SetValue(value), null);
            }

            public GetStatic<T extends Int | Float | Bool | Str | ObjcObject>(type: { prototype: T }, fieldName: string): T
            {
                let jo = Objc.Get(this.className, fieldName, null);
                return ObjcObject.GetValue(type, jo);
            }

            public CallStatic(methodName: string, ...values: (Int | Float | Bool | Str | ObjcObject)[]): void;
            public CallStatic<T extends Int | Float | Bool | Str | ObjcObject>(type: { prototype: T }, methodName: string, ...values: (Int | Float | Bool | Str | ObjcObject)[]): T;
            public CallStatic(...s)
            {
                let a = s.shift();
                if (typeof a == 'string')
                {
                    Objc.Call(this.className, a, ObjcObject.SetValues(...s), null);
                }
                else
                {
                    let b = s.shift();
                    let jo = Objc.Call(this.className, b, ObjcObject.SetValues(...s), null);
                    return ObjcObject.GetValue(a, jo);
                }
            }

            public New(...values: (Int | Float | Bool | Str | ObjcObject)[])
            {
                return Objc.New(this.className);
            }

        }
        export class ObjcObject
        {
            private javaClass: ObjcClass;
            private object: Object0;

            public toString(): string
            {
                return "" + this.object;
            }

            private constructor(obj: Object0, clazz: ObjcClass)
            {
                this.javaClass = clazz;
                this.object = obj;
            }
            public static New(className: string, ...values: (Int | Float | Bool | Str | ObjcObject)[])
            {
                let ioc = new ObjcClass(className);
                let jo = ioc.New(...values)
                return new ObjcObject(jo, ioc);
            }
            public static Get(obj: Object0)
            {
                let ioc = new ObjcClass(Objc.Class(obj));
                return new ObjcObject(obj, ioc);
            }

            public Set(fieldName: string, value: Int | Float | Bool | Str | ObjcObject)
            {
                let v: any;
                if (value instanceof ObjcObject)
                {
                    v = value.object;
                }
                else
                {
                    v = Object0.Get(value);
                }
                Objc.Set(this.javaClass.className, fieldName, v, this.object);
            }

            public Get<T extends Int | Float | Bool | Str | ObjcObject>(type: { prototype: T }, fieldName: string): T
            {
                let jo = Objc.Get(this.javaClass.className, fieldName, this.object);
                return ObjcObject.GetValue(type, jo);
            }

            public Call(methodName: string, ...values: (Int | Float | Bool | Str | ObjcObject)[]): void;
            public Call<T extends Int | Float | Bool | Str | ObjcObject>(type: { prototype: T }, methodName: string, ...values: (Int | Float | Bool | Str | ObjcObject)[]): T;
            public Call(...s)
            {
                let a = s.shift();
                if (typeof a == 'string')
                {
                    Objc.Call(this.javaClass.className, a, ObjcObject.SetValues(...s), this.object);
                }
                else
                {
                    let b = s.shift();
                    let jo = Objc.Call(this.javaClass.className, b, ObjcObject.SetValues(...s), this.object);
                    return ObjcObject.GetValue(a, jo);
                }
            }


            public static GetValue<T extends Int | Float | Bool | Str | ObjcObject>(type: { prototype: T }, obj: Object0): T
            {
                let res: any;
                if (type.prototype == ObjcObject.prototype)
                {
                    res = ObjcObject.Get(obj);
                }
                else
                {
                    res = obj.GetValue(type as { prototype: Int | Float | Bool | Str });
                }
                return res;
            }
            public static SetValue(value: Int | Float | Bool | Str | ObjcObject): Object0
            {
                if (value instanceof ObjcObject)
                {
                    return value.object;
                }
                else
                {
                    return Object0.Get(value);
                }
            }
            public static SetValues(...value: (Int | Float | Bool | Str | ObjcObject)[]): Object0[]
            {
                let values: Object0[] = [];
                for (let item of value)
                {
                    values.push(ObjcObject.SetValue(item));
                }
                return values;
            }
        }
    }

    export namespace APP
    {
        export class Api
        {
            public static Quit()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        jc.CallStatic("Quit");
                        break;
                }
            }
            public static get companyName()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Str, "CompanyName").value;
                }
                return "";
            }
            public static get productName()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Str, "ProductName").value;
                }
                return "";
            }
            public static get packageName()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Str, "PackageName").value;
                }
                return "";
            }
            public static get versionName()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Str, "VersionName").value;
                }
                return "";
            }
            public static get versionCode()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Int, "VersionCode").value;
                }
                return 0;
            }
            public static get channel()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        return jc.CallStatic(Str, "Channel").value;
                }
                return "test";
            }

            public static UserAgreement()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        jc.CallStatic("UserAgreement");
                        break;
                }
            }
            public static PrivacyPolicy()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.APP.ExApi");
                        jc.CallStatic("PrivacyPolicy");
                        break;
                }
            }
        }
    }

    export namespace IAP
    {
        export class Param
        {
            public cbi = new CallbackInfo();
            public product = new Product();
            public order = new Order();
        }
        export class Product
        {
            public id: string;
            public name: string;
            public description: string;
            public price: number;
            public restore: boolean;
            public subs: boolean;
        }
        export class Order
        {
            public id: string;
            public date = new Date();
        }
        export class Api
        {
            private static Param2Json(param: Param)
            {
                let args: any = {};
                args.cbi = CallbackManager.Set(param.cbi);
                args.product = param.product;
                args.order = {};
                args.order.id = param.order.id;
                args.order.date = "" + param.order.date.getTime();
                return new Str(JSON.stringify(args));
            }
            public static Purchase(param: Param)
            {
                console.log("IAP.Purchase");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.IAP.ExApi");
                        jc.CallStatic("Purchase", this.Param2Json(param));
                        break;
                }
            }
            public static QueryAll(param: Param)
            {
                console.log("IAP.QueryAll");

                switch (SystemInfo.platform)
                {
                    case Platform.Android:

                        let jc = new Android.JavaClass("tj.IAP.ExApi");
                        let cbi = param.cbi.Clone();
                        param.cbi.Set(EventType.Complete, (json: string) =>
                        {
                            let list: Param[] = [];
                            for (let item of JSON.parse(json))
                            {
                                let p = new Param();
                                p.product = item.product;
                                p.order.id = item.order.id;
                                p.order.date = new Date(Number.parseInt(item.order.date));
                                list.push(p);
                            }
                            cbi.Run(EventType.Complete, list);
                        });
                        jc.CallStatic("QueryAll", this.Param2Json(param));

                        break;
                }
            }
            public static Consume(param: Param)
            {
                console.log("IAP.Consume");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.IAP.ExApi");
                        jc.CallStatic("Consume", this.Param2Json(param));
                        break;
                    default:
                        break;
                }
            }
            public static get exist()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.IAP.ExApi");
                        return jc.CallStatic(Bool, "Exist").value;
                }
                return false;
            }
        }
    }

    export namespace ADS
    {
        export class Param
        {
            public cbi = new CallbackInfo();
            public id: string = null;
            public place: Place = 0;
            public extraAd = true;
            public template = true;
            public video = true;
            public refresh = false;
        }
        export enum Place
        {
            LEFT = 0b11,
            RIGHT = 0b101,
            CENTER = 0b10001,
            TOP = 0b110000,
            BOTTOM = 0b1010000,
        }

        export class Api
        {

            private static Param2Json(param: Param)
            {
                let args: any = {};
                args.cbi = CallbackManager.Set(param.cbi);
                args.id = param.id;
                args.place = param.place;
                args.extraAd = param.extraAd;
                args.template = param.template;
                args.video = param.video;
                return new Str(JSON.stringify(args));
            }

            public static ShowBanner(param: Param)
            {
                console.log("ADS.ShowBanner");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        jc.CallStatic("ShowBanner", this.Param2Json(param));
                        break;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        oc.CallStatic("ShowBanner:", this.Param2Json(param));
                        break;
                }
            }
            public static RemoveBanner(param: Param)
            {
                console.log("ADS.RemoveBanner");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        jc.CallStatic("RemoveBanner", this.Param2Json(param));
                        break;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        oc.CallStatic("RemoveBanner:", this.Param2Json(param));
                        break;
                }
            }
            public static NormalReady(param: Param)
            {
                console.log("ADS.NormalReady");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        return jc.CallStatic(Bool, "NormalReady", this.Param2Json(param)).value;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        return oc.CallStatic(Bool, "NormalReady:", this.Param2Json(param)).value;
                }
                return false;
            }
            public static ShowNormal(param: Param)
            {
                console.log("ADS.ShowNormal");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        jc.CallStatic("ShowNormal", this.Param2Json(param));
                        break;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        oc.CallStatic("ShowNormal:", this.Param2Json(param));
                        break;
                }
            }
            public static RewardReady(param: Param)
            {
                console.log("ADS.RewardReady");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        return jc.CallStatic(Bool, "RewardReady", this.Param2Json(param)).value;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        return oc.CallStatic(Bool, "RewardReady:", this.Param2Json(param)).value;
                }
                return false;
            }
            public static ShowReward(param: Param)
            {
                console.log("ADS.ShowReward");
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        jc.CallStatic("ShowReward", this.Param2Json(param));
                        break;
                    case Platform.iOS:
                        let oc = new iOS.ObjcClass("TJ_ADS_ExApi");
                        oc.CallStatic("ShowReward:", this.Param2Json(param));
                        break;
                }
            }
            public static get exist()
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.ADS.ExApi");
                        return jc.CallStatic(Bool, "Exist").value;
                }
                return false;
            }
        }
    }

    export namespace GSA
    {
        export class Param
        {
            public id: string;
            public dic = {};
            public cash: number;
            public coin: number;
            public amount: number;
            public price: number;
            public source: number;
        }
        export class Api
        {
            private static Param2Json(param: Param)
            {
                return new Str(JSON.stringify(param));
            }

            public static Event(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("Event", this.Param2Json(param));
                        break;
                }
            }
            public static EventBegin(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("EventBegin", this.Param2Json(param));
                        break;
                }
            }
            public static EventEnd(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("EventEnd", this.Param2Json(param));
                        break;
                }
            }
            public static PageBegin(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("PageBegin", this.Param2Json(param));
                        break;
                }
            }
            public static PageEnd(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("PageEnd", this.Param2Json(param));
                        break;
                }
            }
            public static LevelStart(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("LevelStart", this.Param2Json(param));
                        break;
                }
            }
            public static LevelFinish(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("LevelFinish", this.Param2Json(param));
                        break;
                }
            }
            public static LevelFail(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("LevelFail", this.Param2Json(param));
                        break;
                }
            }
            public static Pay(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("Pay", this.Param2Json(param));
                        break;
                }
            }
            public static Buy(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("Buy", this.Param2Json(param));
                        break;
                }
            }
            public static Use(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("Use", this.Param2Json(param));
                        break;
                }
            }
            public static Bonus(param: Param)
            {
                switch (SystemInfo.platform)
                {
                    case Platform.Android:
                        let jc = new Android.JavaClass("tj.GSA.ExApi");
                        jc.CallStatic("Bonus", this.Param2Json(param));
                        break;
                }
            }
        }
    }

    export class SystemInfo
    {
        public static get platform(): Platform
        {
            switch (this.channel)
            {
                case Channel.android:
                    return Platform.Android;
                case Channel.iphone:
                    return Platform.iOS;
                case Channel.oppoQG:
                case Channel.vivoQG:
                case Channel.ttGame:
                case Channel.qqGame:
                case Channel.wxGame:
                case Channel.ucGame:
                case Channel.qttGame:
                case Channel._4399:
                case Channel.huaweiGame:
                    return Platform.AppRt;
            }
            return Platform.Unknown;
        }

        public static get channel(): Channel
        {
            switch (cc.sys.platform)
            {
                case cc.sys.EDITOR_PAGE:
                    return Channel.editor;
                case cc.sys.ANDROID:
                    return Channel.android;
                case cc.sys.IPHONE:
                    return Channel.iphone;
            }
            return Channel.Unknown;
        }
    }

    export namespace Android
    {
        export class Java
        {
            private static javaClass: string = "tj.tools.Java";

            private static Send(...params: any[]): any
            {
                if (typeof jsb != 'undefined')
                {
                    return jsb.reflection.callStaticMethod(Java.javaClass, ...params);
                }
                return "";
            }

            private static SerializeObjects(objs: Object0[])
            {
                let values = [];
                for (let item of objs)
                {
                    values.push("" + item);
                }
                return JSON.stringify(values);
            }

            public static Set(className: string, fieldName: string, value: Object0, obj: Object0): void
            {
                Java.Send("Set", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", className, fieldName, "" + value, "" + obj);
            }
            public static Get(className: string, fieldName: string, obj: Object0): Object0
            {
                let k: string = Java.Send("Get", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", className, fieldName, "" + obj);
                return Object0.Get(k);
            }
            public static Call(className: string, methodName: string, values: Object0[], obj: Object0): Object0
            {
                let k: string = Java.Send("Call", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", className, methodName, this.SerializeObjects(values), "" + obj);
                return Object0.Get(k);
            }
            public static New(className: string, values: Object0[]): Object0
            {
                let k: string = Java.Send("New", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", className, this.SerializeObjects(values));
                return Object0.Get(k);
            }
            public static Class(obj: Object0): string
            {
                return Java.Send("Class", "(Ljava/lang/String;)Ljava/lang/String;", "" + obj);
            }

            public static GetInt(obj: Object0): number
            {
                return Java.Send("GetInt", "(Ljava/lang/String;)I", "" + obj);
            }
            public static GetFloat(obj: Object0): number
            {
                return Java.Send("GetFloat", "(Ljava/lang/String;)F", "" + obj);
            }
            public static GetBoolean(obj: Object0): boolean
            {
                return Java.Send("GetBoolean", "(Ljava/lang/String;)Z", "" + obj);
            }
            public static GetString(obj: Object0): string
            {
                return Java.Send("GetString", "(Ljava/lang/String;)Ljava/lang/String;", "" + obj);
            }
            public static SetValue(value: Int | Float | Bool | Str)
            {
                let k = Java.Send("SetValue", "(" + value.javaSignature + ")Ljava/lang/String;", value.value);
                return Object0.Get(k);
            }
        }
    }

    export namespace iOS
    {
        export class Objc
        {
            private static objcClass: string = "TJ_Objc";

            private static Send(...params: any[]): any
            {
                if (typeof jsb != 'undefined')
                {
                    return jsb.reflection.callStaticMethod(Objc.objcClass, ...params);
                }
                return "";
            }

            private static SerializeObjects(objs: Object0[])
            {
                let values = [];
                for (let item of objs)
                {
                    values.push("" + item);
                }
                return JSON.stringify(values);
            }

            public static Set(className: string, fieldName: string, value: Object0, obj: Object0): void
            {
                Objc.Send("Set", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", className, fieldName, "" + value, "" + obj);
            }
            public static Get(className: string, fieldName: string, obj: Object0): Object0
            {
                let k: string = Objc.Send("Get", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", className, fieldName, "" + obj);
                return Object0.Get(k);
            }
            public static Call(className: string, methodName: string, values: Object0[], obj: Object0): Object0
            {
                let k: string = Objc.Send("Call_className:Call_methodName:Call_values:Call_obj:", className, methodName, this.SerializeObjects(values), "" + obj);
                return Object0.Get(k);
            }
            public static New(className: string): Object0
            {
                let k: string = Objc.Send("New_className:", className);
                return Object0.Get(k);
            }
            public static Class(obj: Object0): string
            {
                return Objc.Send("Class", "(Ljava/lang/String;)Ljava/lang/String;", "" + obj);
            }

            public static GetInt(obj: Object0): number
            {
                return Objc.Send("GetObj:", "" + obj);
            }
            public static GetFloat(obj: Object0): number
            {
                return Objc.Send("GetObj:", "" + obj);
            }
            public static GetBoolean(obj: Object0): boolean
            {
                return Objc.Send("GetObj:", "" + obj);
            }
            public static GetString(obj: Object0): string
            {
                return Objc.Send("GetObj:", "" + obj);
            }
            public static SetValue(value: Int | Float | Bool | Str)
            {
                let k = Objc.Send("SetObj:", value.value);
                return Object0.Get(k);
            }
        }
    }

}
window["TJ"] = TJ;
