///龙骨贴图错误Demo
///qq:2808949242
const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {
    @property(dragonBones.ArmatureDisplay)
    db: dragonBones.ArmatureDisplay = null;
    @property(cc.Button)
    playButton: cc.Button = null;
    @property(cc.Button)
    stopButton: cc.Button = null;
    @property(cc.Toggle)
    randomToggle: cc.Toggle = null;
    @property(cc.Toggle)
    loopToggle: cc.Toggle = null;
    @property(cc.Button)
    playAllBtn: cc.Button = null;
    @property(cc.Node)
    animBtnNode: cc.Node = null;
    @property(cc.Label)
    TipLabel: cc.Label = null;
    @property(cc.EditBox)
    timeBox: cc.EditBox = null;

    animationList: Array<string>;
    curPlayList: Array<string> = null;
    lastAction: Function = null;
    _armature: dragonBones.Armature;
    get armature() {
        if (!this._armature) {
            this._armature = this.db.armature() as dragonBones.Armature;
            if (!this._armature) {
                throw new Error(`error,this.armature=null,armature name:${this.db.armatureName}`);
            }
        }
        return this._armature;
    }
    _duration: number;

    get duration() {
        let time = parseFloat(this.timeBox.string);
        if (isNaN(time)) {
            time = 1;
            this.timeBox.string = time.toString();
        }
        this._duration = time;
        console.log(new Date().valueOf(), this._duration);
        return this._duration;
    }
    onLoad() {

    }
    randomNum(max, min = 0) {
        return min + Math.floor(Math.random() * (max - min));
    }
    start() {
        this.animationList = this.db.getAnimationNames(this.db.armatureName);
        this.playButton.node.on(cc.Node.EventType.TOUCH_START, this.playOneAnim.bind(this));
        this.stopButton.node.on(cc.Node.EventType.TOUCH_START, this.stopPlayAnim.bind(this));


        this.playAllBtn.node.on(cc.Node.EventType.TOUCH_START, this.playAllAnim.bind(this));
        this.createOtherAnimButton();
        // this.playAllAnim();

    }

    public createOtherAnimButton() {
        let count = this.animationList.length;
        let parent = this.animBtnNode.parent;
        for (let i = 0; i < count; i++) {
            let node = cc.instantiate(this.animBtnNode);
            node.getComponentInChildren(cc.Label).string = this.animationList[i];
            let size = parent.width / (count * 10);
            size = size > 50 ? 50 :
                size < 15 ? 15 : size;
            node.getComponentInChildren(cc.Label).fontSize = size;
            node.on(cc.Node.EventType.TOUCH_START, this.playSelectAnim.bind(this, this.animationList[i]));
            parent.addChild(node);
        }
        this.animBtnNode.active = false;
    }
    public lastText: string = null;
    public playSelectAnim(text: string = null) {
        if (text) {
            this.lastText = text;
        }
        this.lastAction = this.playSelectAnim;
        this.playAnim(this.lastText);
    }
    public playOneAnim() {
        let text: string;
        if (this.randomToggle.isChecked) {
            text = this.animationList[this.randomNum(this.animationList.length)];
        } else {
            if (this.lastText) {
                text = this.lastText;
            } else {
                text = this.animationList[0];
            }
        }
        this.lastAction = this.playOneAnim;
        this.playAnim(text);
    }
    public playAllAnim() {
        if (this.curPlayList === null || this.curPlayList.length === 0) {
            this.curPlayList = this.animationList.slice();
        }
        let text: string;
        if (this.randomToggle.isChecked) {
            let index = this.randomNum(this.animationList.length);
            text = this.curPlayList.splice(index, 1)[0];
        } else {
            text = this.curPlayList.shift();
        }
        this.lastAction = this.playAllAnim;
        this.playAnim(text);
    }
    public stopPlayAnim() {
        if (this._lastAnimId < 0) {
            this.tip(`not need stop`);
            return;
        }

        this.tip(`stop: ${this.lastAction.name}`);
        this.lastAnimId = -1;
        this.lastAction = null;
        this.curPlayList = null;
        this.lastText = null;
        clearTimeout(this._lastAnimId);
        this.state.stop();
        this.armature.advanceTime(0);
        this.armature.animation.reset();
    }
    public _lastAnimId: number = -1;
    public set lastAnimId(value) {
        if (this._lastAnimId < 0) {
            clearTimeout(this._lastAnimId);
        }
        this._lastAnimId = value;
    }

    state: dragonBones.AnimationState;
    tip(text) {
        this.TipLabel.string = text;
        console.log(new Date().valueOf(), text);
    }

    playAnim(text: string = null) {
        if (!text) {
            text = this.db.animationName;
            this.tip(`play ${text}`);
            if (!text) {
                text = this.db.getAnimationNames(this.db.armatureName)[0]
            }
            this.tip(`play ${text}`);
        }
        if (!text) {
            this.tip(`eror play  animation is null:${text}`);
            return;
        }
        this.tip(`play ${text}`);
        this.db.armature().animation.reset();
        // this.state = this.db.playAnimation(text, 1);
        // this.state = this.armature.animation.play(text, 1);
        // this.state = this.armature.animation.fadeIn(text, 0, -1);
        this.state = this.db.playAnimation(text, -1);
        

        this.lastAnimId = setTimeout(this.lastFrameHandler.bind(this), (this.state.totalTime + this.duration) * 1000);
        console.log(`totalTime:${this.state.totalTime},duration:${this.duration}`);
    }
    async lastFrameHandler() {
        this.tip(`play ${this.state.name} finished!`);
        if (this.loopToggle.isChecked) {
            this.tip(`继续执行上次操作`);
            if (this.lastAction) {
                this.lastAction.call(this);
            }
        }
    }
}
