// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class ScrollViewEx extends cc.ScrollView {

    isMoveLocked: boolean = true;
    _hasNestedViewGroup(event, captureListeners) {
        var touch = event.touch;
        if (!touch) return;
       
        if (!this.isMoveLocked) {
            return false;
        }
        if (event.eventPhase !== cc.Event.CAPTURING_PHASE
            && event.target === this.node
            && !captureListeners) {
            captureListeners = [];
            event.target._getCapturingTargets(event.type, captureListeners);
        }
        cc.log("===test002==",event.target.name)
        if (captureListeners) {
            for (var i = 0; i < captureListeners.length; ++i) {
                var item = captureListeners[i];
                if (this.node === item) {
                   
                    if (
                     event.target.getComponent(cc.ViewGroup) && 
                     !event.target.getComponent(cc.ViewGroup).isMoveLocked) {
                        cc.log("===test001==",event.target.name)
                        return true;
                    }
                }
                if (this.node !== item) {
                    if (item.getComponent(cc.ViewGroup)) {
                        //if(item.name=="ChatScrollView")
                       
                        if (!item.getComponent(cc.ViewGroup).isMoveLocked) {
                            cc.log("===test002==")
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
    _onTouchMoved(event, captureListeners) {
      
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;

        this._checkMoveLocked(event);

        let touch = event.touch;
        if (this.content) {
            this._handleMoveLogic(touch);
        }
        // Do not prevent touch events in inner nodes
        if (!this.cancelInnerEvents) {
            return;
        }

        let deltaMove = touch.getLocation().sub(touch.getStartLocation());
        //FIXME: touch move delta should be calculated by DPI.
        if (deltaMove.mag() > 7) {
            if (!this._touchMoved && event.target !== this.node) {
                // Simulate touch cancel for target node
                let cancelEvent = new cc.Event.EventTouch(event.getTouches(), event.bubbles);
                cancelEvent.type = cc.Node.EventType.TOUCH_CANCEL;
                cancelEvent.touch = event.touch;
                cancelEvent.simulate = true;
                event.target.dispatchEvent(cancelEvent);
                this._touchMoved = true;
            }
        }
        this._stopPropagationIfTargetIsMe(event);
    }
    _checkMoveLocked(event) {
        var touch = event.touch;
        if (!touch) return;
        if (!this.isMoveLocked) return;
        let startPoint = cc.v2(touch.getLocation().x, touch.getLocation().y);
        let endPoint = cc.v2(touch.getStartLocation().x, touch.getStartLocation().y);
        var deltaMove = endPoint.sub(startPoint);
        if (this.vertical) {
            if (Math.abs(deltaMove.y) >= 100 * cc.view.getScaleY()) {
                this.isMoveLocked = false;
            }
        }
        if (this.horizontal) {
            if (Math.abs(deltaMove.x) >= 100 * cc.view.getScaleX()) {
                this.isMoveLocked = false;
            }
        }
    }
    _handleMoveLogic(touch) {
        if (this.isMoveLocked) {
            return;
        }
        let deltaMove = touch.getDelta();
        this._processDeltaMove(deltaMove);
    }
    _handleReleaseLogic(touch) {
        if (this.isMoveLocked) {
            return;
        }
        let delta = touch.getDelta();
        this._gatherTouchMove(delta);
        this._processInertiaScroll();
        if (this._scrolling) {
            this._scrolling = false;
            if (!this._autoScrolling) {
                this._dispatchEvent('scroll-ended');
            }
        }

    }
    _onTouchBegan(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;

        let touch = event.touch;
        if (this.content) {
            this._handlePressLogic(touch);
        }
        this._touchMoved = false;
        this.isMoveLocked = true;
        this._stopPropagationIfTargetIsMe(event);
    }
    _onTouchEnded(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;

        this._dispatchEvent('touch-up');

        let touch = event.touch;
        if (this.content) {
            this._handleReleaseLogic(touch);
        }
        if (this._touchMoved) {
            event.stopPropagation();
        } else {
            this._stopPropagationIfTargetIsMe(event);
        }
        this.isMoveLocked = true;
    }
    _onTouchCancelled(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;

        // Filte touch cancel event send from self
        if (!event.simulate) {
            let touch = event.touch;
            if (this.content) {
                this._handleReleaseLogic(touch);
            }
        }
        this._stopPropagationIfTargetIsMe(event);
        this.isMoveLocked = true;
    }
}
