
var HelloWorldLayer = cc.Layer.extend({

    playBtn: null,

    stopBtn: null,

    ctor:function () {
        this._super();

        this.initEx();

        return true;
    },

    initEx: function () {

        var size = cc.director.getWinSize();

        this.playBtn = new ccui.Button(res.btn_png, res.btn_png, res.btn_png, ccui.Widget.LOCAL_TEXTURE);
        this.playBtn.setTitleText("播放");
        this.playBtn.setPressedActionEnabled(true);
        this.playBtn.addClickEventListener(this.onBtnClick.bind(this));
        this.addChild(this.playBtn);

        this.playBtn.setPosition(size.width/2 - 150, size.height/2);

        this.stopBtn = new ccui.Button(res.btn_png, res.btn_png, res.btn_png, ccui.Widget.LOCAL_TEXTURE);
        this.stopBtn.setTitleText("停止");
        this.stopBtn.setPressedActionEnabled(true);
        this.stopBtn.addClickEventListener(this.onBtnClick.bind(this));
        this.addChild(this.stopBtn);

        this.stopBtn.setPosition(size.width/2 + 150, size.height/2);
    },

    onBtnClick: function(sender) {
        switch (sender) {
            case this.playBtn:
                this.schedule(this.playSchedule, 0.1, 100000);
                break;

            case this.stopBtn:
                this.unschedule(this.playSchedule);
                jsb.AudioEngine.stopAll();
                break;
        }
    },

    playSchedule: function () {
        var playCount = Math.floor(Math.random() * 3) + 1;
        var len = music.length;

        for (let i = 0; i < playCount; i++) {
            var index = Math.floor(Math.random() * len);
            jsb.AudioEngine.play2d(music[index], false);
        }
    }

});

var HelloWorldScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new HelloWorldLayer();
        this.addChild(layer);
    }
});