import global from 'global'
const {ccclass, property} = cc._decorator;

@ccclass
export default class ballControl extends cc.Component {
    @property
    maxSpeed = 0;

    @property
    acceleration = 0;

    @property
    drag = 0;

    @property
    maxJumps = 0;

    @property
    maxJumpY = 0;
    
    @property(cc.Node)
    leftButton = null;

    @property(cc.Node)
    rightButton = null;

    @property(cc.Node)
    upButton = null;
    
    onLoad () {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getCollisionManager().enabled = true;     
        this._up = false;
        this.directionNum = 0;
        this.jumps = 1;
        this.body = this.node.getComponent(cc.RigidBody);
        if (this.leftButton) {
            this.leftButton.on('touchstart', () => {
                this.directionNum = 1;
            })
            this.leftButton.on('touchend', () => {
                this.directionNum = 0;
            })
            this.leftButton.on('touchcancel', () => {
                this.directionNum = 0;
            })
        }
        if (this.rightButton) {
            this.rightButton.on('touchstart', () => {
                this.directionNum = 2;
            })
            this.rightButton.on('touchend', () => {
                this.directionNum = 0;
            })
            this.rightButton.on('touchcancel', () => {
                this.directionNum = 0;
            })
        }
        if (this.upButton) {
            this.upButton.on('touchstart', () => {
                // this.directionNum = 3;
                if (!this._upPressed) {
                    this._up = true;
                }
                this._upPressed = true;
            })
            this.upButton.on('touchend', () => {
                this._upPressed = false;
                // this.directionNum = 0;
            })
            this.upButton.on('touchcancel', () => {
                this._upPressed = false;
                // this.directionNum = 0;
            })
        }
    }
    // 只在两个碰撞体开始接触时被调用一次
    onBeginContact (contact, selfCollider, otherCollider) {
        let selfPos = selfCollider.node.getBoundingBoxToWorld();
        let otherPos = otherCollider.node.getBoundingBoxToWorld();
        if (otherCollider.node.group === 'StaticFloor') {
            selfPos.center.y > otherPos.yMin ? this.jumps = this.maxJumps : ''
        }
    }

    // 只在两个碰撞体结束接触时被调用一次
    onEndContact (contact, selfCollider, otherCollider) {
    }

    // 每次将要处理碰撞体接触逻辑时被调用
    onPreSolve (contact, selfCollider, otherCollider) {
    }

    // 每次处理完碰撞体接触逻辑时被调用
    onPostSolve (contact, selfCollider, otherCollider) {
    }

    update (dt) {
        if (this.node.getBoundingBoxToWorld().y < cc.winSize.height/2 - 800) {
            cc.sys.localStorage.setItem('starNum', global.starNum)
            cc.director.loadScene('game')
        }

        let speed = this.body.linearVelocity;

        if (this.directionNum === 1){
            speed.x -= this.acceleration * dt
            if (speed.x < -this.maxSpeed) {
                speed.x = -this.maxSpeed
            }
        } else if (this.directionNum === 2){
            speed.x += this.acceleration * dt
            if (speed.x > this.maxSpeed) {
                speed.x = this.maxSpeed
            }
        } else {
            if (speed.x != 0) {
                let d = this.drag * dt;
                if(Math.abs(speed.x) <= d) {
                    speed.x = 0;
                } else {
                    speed.x -= speed.x > 0 ? d : -d;
                }
            }
        }

        if (this.jumps > 0 && this._up) {
            speed.y = this.maxJumpY;
            this.jumps--;
        }
        
        this._up = false;
        this.body.linearVelocity = speed;
    }
}