import global from 'global'
const {ccclass, property} = cc._decorator;
    
@ccclass
export default class ballControl extends cc.Component {

    @property(cc.Node)
    target = null;
    @property
    maxZoomRatio = 0;

    onLoad () {
        this.camera = this.getComponent(cc.Camera);
        if (this.node.getBoundingBoxToWorld() != global.camera) {
            global.camera = this.node.getBoundingBoxToWorld();
        }
    }

    onEnable () {
        cc.director.getPhysicsManager().attachDebugDrawToCamera(this.camera);
    }
    onDisable () {
        cc.director.getPhysicsManager().detachDebugDrawFromCamera(this.camera);
    }

    update (dt) {
        if (this.node.getBoundingBoxToWorld() != global.camera) {
            global.camera = this.node.getBoundingBoxToWorld();
        }
    }

    lateUpdate (dt) {
        let targetPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);
        this.node.position = this.node.parent.convertToNodeSpaceAR(cc.v2(targetPos.x, targetPos.y - 120));
        this.camera.zoomRatio = this.maxZoomRatio;
    }
};