import global from 'global'
const {ccclass, property} = cc._decorator;
    
@ccclass
export default class mapControl extends cc.Component {
    @property(cc.Prefab)
    prefabList = [];

    @property(cc.Prefab)
    starPF = null;
    
    start () {
        //初始化对象池
        this.starPool = new cc.NodePool();
        this.staticFloorOne = new cc.NodePool();
        this.staticFloorTwo = new cc.NodePool();
        let initCount = 6;
        for (let i = 0; i < initCount; ++i) {
            let star = cc.instantiate(this.starPF); // 创建节点
            let staticFloor = cc.instantiate(this.prefabList[Math.floor(Math.random()*(this.prefabList.length - 0 ))]); // 创建节点            
            this.starPool.put(star); // 通过 putInPool 接口放入对象池
            this.getPool().put(staticFloor);
        }
        //创建第一个平台
        let enemy = null;
        enemy = cc.instantiate(this.prefabList[Math.floor(Math.random()*(this.prefabList.length - 0 ))]); // 创建节点
        enemy.parent = this.node; // 将生成的敌人加入节点树
        enemy.setPosition(cc.v2(0, cc.winSize.height/2 - 300)); //第一个平台位置应于小球(也就是摄像机中心点)下方300像素的位置
        global.xMax = enemy.getBoundingBox().xMax   //储存创建的平台的最大x值，以备接下来创建其他平台用
        this.onEnemyCreate()
    }


    //创建平台节点
    onEnemyCreate () {
        let enemy = null;
        let pool = this.getPool();
        if (pool.size() > 0) { // 通过 size 接口判断对象池中是否有空闲的对象
            enemy = pool.get();
        } else { // 如果没有空闲对象，也就是对象池中备用对象不够时，我们就用 cc.instantiate 重新创建
            enemy = cc.instantiate(this.prefabList[Math.floor(Math.random()*(this.prefabList.length - 0 ))]); // 创建节点
        }
        enemy.parent = this.node; // 将生成的敌人加入节点树
        enemy.getComponent('staticFloor-generation').init(); //接下来就可以调用 enemy 身上的脚本进行初始化
        if (enemy.getBoundingBoxToWorld().xMax < global.camera.x + cc.winSize.width/2 + 300) {  //判断当前最右边的平台的距离是否大于当前屏幕+300像素，否的话继续创建平台
            return this.onEnemyCreate()
        }
    }
    //销毁平台节点
    onEnemyKilled (enemy) {
        this.getPool().put(enemy);    //回收对象池
        this.onEnemyCreate();    //创建新平台
    }
    //创建星币节点
    getStarPool (node) {
        let enemy = null;
        if (this.starPool.size() > 0) { // 通过 size 接口判断对象池中是否有空闲的对象
            enemy = this.starPool.get();
        } else { // 如果没有空闲对象，也就是对象池中备用对象不够时，我们就用 cc.instantiate 重新创建
            enemy = cc.instantiate(this.starPF);
        }
        enemy.parent = node; // 将生成的敌人加入节点树
        enemy.getComponent('star-control').init();
    }
    //回收星币节点
    putStarPool (enemy) {
        this.starPool.put(enemy)
    }

    getPool () {
        return Math.ceil(Math.random()*10) % 2 === 0 ? this.staticFloorTwo : this.staticFloorOne
    }
}