const getRandomInt = function (min, max) {
    var ratio = cc.random0To1();
    return min + Math.floor((max - min) * ratio);
};

const {ccclass, property} = cc._decorator;

@ccclass
export default class Sprite extends cc.Component {
    @property(cc.SpriteFrame)
    spriteArr = [];

    onLoad () {
        this.init()
    }
    // 只在两个碰撞体开始接触时被调用一次
    onBeginContact (contact, selfCollider, otherCollider) {
        // cc.log(selfCollider.node.name)
    }

    // 只在两个碰撞体结束接触时被调用一次
    onEndContact (contact, selfCollider, otherCollider) {
    }

    // 每次将要处理碰撞体接触逻辑时被调用
    onPreSolve (contact, selfCollider, otherCollider) {
    }

    // 每次处理完碰撞体接触逻辑时被调用
    onPostSolve (contact, selfCollider, otherCollider) {
    }
    
    //随机获取平台皮肤
    init () {
        let num = getRandomInt(0, this.spriteArr.length);
        this.node.getComponent(cc.Sprite).spriteFrame = this.spriteArr[getRandomInt(0, this.spriteArr.length)]
    }
}