import global from 'global'
const {ccclass, property} = cc._decorator;

@ccclass
export default class starControl extends cc.Component {

    onLoad () {
        this.map = cc.find('Map')
        this.anim = this.getComponent(cc.Animation);
        let anim1 = this.anim.getAnimationState('star_vanish');
        anim1.on('finished', this.onAnimCompleted, this);
    }
    //当碰撞产生的时候调用
    onCollisionEnter (other, self) {
        //判断其他碰撞体是否为ball,是的话播放消失动画
        other.node.name === 'Ball' ? this.anim.play('star_vanish') : ''
        global.starNum++
    }
    //当碰撞产生后，碰撞结束前的情况下，每次计算碰撞结果后调用
    onCollisionStay (other, self) {
    }
    //当碰撞结束后调用
    onCollisionExit (other, self) {
    }
    //自定义动画执行完毕回调
    onAnimCompleted () {
        this.map.getComponent('map-control').putStarPool(this.node)
    }
    init () {
        this.anim.play('star_idle')
    }
}