import global from 'global'
const {ccclass, property} = cc._decorator;

@ccclass
export default class staticFloorGeneration extends cc.Component {
    @property
    intervalX = 0;

    @property
    intervalY = 0;

    // use this for initialization
    onLoad () {
        this.map = cc.find("Map");    
    }

    // 只在两个碰撞体开始接触时被调用一次
    onBeginContact (contact, selfCollider, otherCollider) {
    }

    // 只在两个碰撞体结束接触时被调用一次
    onEndContact (contact, selfCollider, otherCollider) {
    }

    // 每次将要处理碰撞体接触逻辑时被调用
    onPreSolve (contact, selfCollider, otherCollider) {
    }

    // 每次处理完碰撞体接触逻辑时被调用
    onPostSolve (contact, selfCollider, otherCollider) {
    }

    // called every frame, uncomment this function to activate update callback
    update (dt) {
        //判断当前平台是否移出当前屏幕最左边-100像素，移出的话销毁当前节点并创建新节点
        if (this.node.getBoundingBoxToWorld().xMax < global.camera.x - cc.winSize.width/2 - 100) {
            let star = this.node.getChildByName('star');
            if (star !== null && star.getChildByName('star') !== null) {
                cc.log(111)
                star.getChildByName('star').getComponent('star-control').onAnimCompleted();
            }
            this.map.getComponent('map-control').onEnemyKilled(this.node)
        }
    }

    init () {
        //设定平台的随机x,y值
        let children = this.node.children;        
        let pos = cc.v2(global.xMax + Math.floor(Math.random()*(this.intervalX - 0 ) + 200), cc.winSize.height/2 + Math.floor(Math.random()*(this.intervalY - 0 ) + -this.intervalY));
        this.node.setPosition(pos);
        global.xMax = this.node.getBoundingBox().xMax;   //储存创建的平台的最大x值，以备接下来创建其他平台用
        for (var i = 0; i < children.length; ++i) {
            switch (children[i].name) {
                case 'star':
                    children[i] !== null ? children[i].getComponent('star-generation').init() : ''
                    break;
                case 'floor':
                    children[i] !== null ? children[i].getComponent('sprite').init() : ''
                    break;
            }
        }
    }
}
