//
//  GalleryJSBind.cpp
//  hello_world-mobile
//
//  Created by baichao hwang on 2019/12/19.
//

#include "GalleryJSBind.h"
#include "cocos/scripting/js-bindings/manual/jsb_module_register.hpp"
#include "cocos/scripting/js-bindings/manual/jsb_global.h"
#include "cocos/scripting/js-bindings/jswrapper/SeApi.h"
#include "cocos/scripting/js-bindings/event/EventDispatcher.h"
#include "cocos/scripting/js-bindings/manual/jsb_classtype.hpp"

#include "cocos2d.h"
//#include "JsbGalleryCtrl.h"
#include "iOSGalleryHelper.h"

USING_NS_CC;

static se::Object* __jsb_ns_GalleryJSBind_proto = nullptr;
static se::Class* __jsb_ns_GalleryJSBind_class = nullptr;

namespace ns {
class GalleryJSBind
{
public:
    GalleryJSBind()
    //        : xxx(0)
    {
        
    }
    void openGallery() {
//                JsbGalleryCtrl
//        OpenSysGallery();
        iOSGalleryHelper::OpenSysGalleryMain();
    }
    void openGalleryCB() {
        //            printf("GalleryJSBind::foo\n");
        
        if (_cb != nullptr) {
            //                _cb(xxx);
        }
    }
    
    static void static_func() {
        //            printf("GalleryJSBind::static_func\n");
    }
    
    void setCallback(const std::function<void(int)>& cb) {
        _cb = cb;
        if (_cb != nullptr)
        {
            //                printf("setCallback(cb)\n");
        }
        else
        {
            //                printf("setCallback(nullptr)\n");
        }
    }
    
    //        int xxx;
private:
    std::function<void(int)> _cb;
};
}


static bool js_GalleryJSBind_setCallback(se::State& s)
{
    const auto& args = s.args();
    int argc = (int)args.size();
    if (argc >= 1)
    {
        ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
        
        se::Value jsFunc = args[0];
        se::Value jsTarget = argc > 1 ? args[1] : se::Value::Undefined;
        
        if (jsFunc.isNullOrUndefined())
        {
            cobj->setCallback(nullptr);
        }
        else
        {
            assert(jsFunc.isObject() && jsFunc.toObject()->isFunction());
            
            // 如果当前 GalleryJSBind 是可以被 new 出来的类，我们 使用 se::Object::attachObject 把 jsFunc 和 jsTarget 关联到当前对象中
            s.thisObject()->attachObject(jsFunc.toObject());
            s.thisObject()->attachObject(jsTarget.toObject());
            
            // 如果当前 GalleryJSBind 类是一个单例类，或者永远只有一个实例的类，我们不能用 se::Object::attachObject 去关联
            // 必须使用 se::Object::root，开发者无需关系 unroot，unroot 的操作会随着 lambda 的销毁触发 jsFunc 的析构，在 se::Object 的析构函数中进行 unroot 操作。
            // js_cocos2dx_EventDispatcher_addCustomEventListener 的绑定代码就是使用此方式，因为 EventDispatcher 始终只有一个实例，
            // 如果使用 s.thisObject->attachObject(jsFunc.toObject);会导致对应的 func 和 target 永远无法被释放，引发内存泄露。
            
            // jsFunc.toObject()->root();
            // jsTarget.toObject()->root();
            
            cobj->setCallback([jsFunc, jsTarget](int counter){
                
                // CPP 回调函数中要传递数据给 JS 或者调用 JS 函数，在回调函数开始需要添加如下两行代码。
                se::ScriptEngine::getInstance()->clearException();
                se::AutoHandleScope hs;
                
                se::ValueArray args;
                args.push_back(se::Value(counter));
                
                se::Object* target = jsTarget.isObject() ? jsTarget.toObject() : nullptr;
                jsFunc.toObject()->call(args, target);
            });
        }
        
        return true;
    }
    
    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
SE_BIND_FUNC(js_GalleryJSBind_setCallback)

static bool js_GalleryJSBind_finalize(se::State& s)
{
    ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
    delete cobj;
    return true;
}
SE_BIND_FINALIZE_FUNC(js_GalleryJSBind_finalize)

static bool js_GalleryJSBind_constructor(se::State& s)
{
    ns::GalleryJSBind* cobj = new ns::GalleryJSBind();
    s.thisObject()->setPrivateData(cobj);
    return true;
}
SE_BIND_CTOR(js_GalleryJSBind_constructor, __jsb_ns_GalleryJSBind_class, js_GalleryJSBind_finalize)

static bool js_GalleryJSBind_openGallery(se::State& s)
{
    ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
    cobj->openGallery();
    return true;
}
SE_BIND_FUNC(js_GalleryJSBind_openGallery)

static bool js_GalleryJSBind_openGalleryCB(se::State& s)
{
    ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
    cobj->openGalleryCB();
    return true;
}
SE_BIND_FUNC(js_GalleryJSBind_openGalleryCB)

//static bool js_GalleryJSBind_get_xxx(se::State& s)
//{
//    ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
//    s.rval().setInt32(cobj->xxx);
//    return true;
//}
//SE_BIND_PROP_GET(js_GalleryJSBind_get_xxx)
//
//static bool js_GalleryJSBind_set_xxx(se::State& s)
//{
//    const auto& args = s.args();
//    int argc = (int)args.size();
//    if (argc > 0)
//    {
//        ns::GalleryJSBind* cobj = (ns::GalleryJSBind*)s.nativeThisObject();
//        cobj->xxx = args[0].toInt32();
//        return true;
//    }
//
//    SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", argc, 1);
//    return false;
//}
//SE_BIND_PROP_SET(js_GalleryJSBind_set_xxx)

static bool js_GalleryJSBind_static_func(se::State& s)
{
    ns::GalleryJSBind::static_func();
    return true;
}
SE_BIND_FUNC(js_GalleryJSBind_static_func)

bool js_register_ns_GalleryJSBind(se::Object* global)
{
    // 保证 namespace 对象存在
    se::Value nsVal;
    if (!global->getProperty("ns", &nsVal))
    {
        // 不存在则创建一个 JS 对象，相当于 var ns = {};
        se::HandleObject jsobj(se::Object::createPlainObject());
        nsVal.setObject(jsobj);
        
        // 将 ns 对象挂载到 global 对象中，名称为 ns
        global->setProperty("ns", nsVal);
    }
    se::Object* ns = nsVal.toObject();
    
    // 创建一个 Class 对象，开发者无需考虑 Class 对象的释放，其交由 ScriptEngine 内部自动处理
    auto cls = se::Class::create("GalleryJSBind", ns, nullptr, _SE(js_GalleryJSBind_constructor)); // 如果无构造函数，最后一个参数可传入 nullptr，则这个类在 JS 中无法被 new GalleryJSBind()出来
    
    // 为这个 Class 对象定义成员函数、属性、静态函数、析构函数
    cls->defineFunction("openGallery", _SE(js_GalleryJSBind_openGallery));
    cls->defineFunction("openGalleryCB", _SE(js_GalleryJSBind_openGalleryCB));
    //    cls->defineProperty("xxx", _SE(js_GalleryJSBind_get_xxx), _SE(js_GalleryJSBind_set_xxx));
    
    cls->defineFunction("setCallback", _SE(js_GalleryJSBind_setCallback));
    
    cls->defineFinalizeFunction(_SE(js_GalleryJSBind_finalize));
    
    // 注册类型到 JS VirtualMachine 的操作
    cls->install();
    
    // JSBClassType 为 Cocos 引擎绑定层封装的类型注册的辅助函数，此函数不属于 ScriptEngine 这层
    JSBClassType::registerClass<ns::GalleryJSBind>(cls);
    
    // 保存注册的结果，便于其他地方使用，比如类继承
    __jsb_ns_GalleryJSBind_proto = cls->getProto();
    __jsb_ns_GalleryJSBind_class = cls;
    
    // 为每个此 Class 实例化出来的对象附加一个属性
    __jsb_ns_GalleryJSBind_proto->setProperty("yyy", se::Value("helloyyy"));
    
    // 注册静态成员变量和静态成员函数
    se::Value ctorVal;
    if (ns->getProperty("GalleryJSBind", &ctorVal) && ctorVal.isObject())
    {
        ctorVal.toObject()->setProperty("static_val", se::Value(200));
        ctorVal.toObject()->defineFunction("static_func", _SE(js_GalleryJSBind_static_func));
    }
    
    // 清空异常
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


