//
//  JsbGalleryCtrl.m
//  hello_world-mobile
//
//  Created by baichao hwang on 2019/12/18.
//

#import "JsbGalleryCtrl.h"
#include "GalleryJSBind.h"

#include "cocos/scripting/js-bindings/jswrapper/SeApi.h"
#include "cocos/scripting/js-bindings/manual/jsb_classtype.hpp"
#include "cocos2d.h"


@implementation JsbGalleryCtrl

+ (instancetype)sharedSingleton {
    static JsbGalleryCtrl *_sharedSingleton = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        // 要使用self来调用
        _sharedSingleton = [[self alloc] init];
    });
    return _sharedSingleton;
}

//+(void)OpenSysGallery {
//    NSLog(@"OC-访问系统相册");
//
//    JsbGalleryCtrl* ctl = [[JsbGalleryCtrl alloc] init];
//    [ctl galleryPicker];
////    UIImagePickerController* picker = [[UIImagePickerController alloc]init];
////    picker.delegate = self;
////    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
////    picker.allowsEditing = YES;
////    UIWindow* window= [UIApplication sharedApplication].keyWindow;
////
////    [window.rootViewController presentViewController:picker
////                                            animated:YES
////                                          completion:^(void){
////        NSLog(@"ImageViewController is presented");
////    }];
//}

-(void)openGalleryPicker {
    UIImagePickerController* picker = [[UIImagePickerController alloc]init];
    picker.delegate = self;
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    picker.allowsEditing = YES;
    UIWindow* window= [UIApplication sharedApplication].keyWindow;
    
    [window.rootViewController presentViewController:picker
                                            animated:YES
                                          completion:^(void){
        NSLog(@"ImageViewController is presented");
    }];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info
{
    NSLog(@"照片选择完成");
    // 获取图片
    UIImage *image = info[UIImagePickerControllerOriginalImage];
        // Compress by quality
    CGFloat compression = 1;
    NSData *data = UIImageJPEGRepresentation(image, compression);
    
    
    
    //    self.image.image = image;
    //    NSLog(@"获取到的图片数据为：%@", image.data);
    //    JSBClassType::findClass(const T *nativeObj)
    se::ScriptEngine *se = se::ScriptEngine::getInstance();
    
    //    se->callback
    //    js_register_ns_GalleryJSBind
    NSString* funcNameOC=@"cc.imagePickerTestFunc";
    NSString* paramOC=@"这个是什么参数呀";
//    NSString* paramOC=[[NSString alloc] initWithData:data
//                                            encoding:NSUTF8StringEncoding];
    
    std::string funcName = [funcNameOC UTF8String];
    std::string param = [paramOC UTF8String];
    std::string jsCallStr = cocos2d::StringUtils::format("%s(\"%s\");",funcName.c_str(), param.c_str());
    NSLog(@"jsCallStr = %s", jsCallStr.c_str());

    //        ScriptingCore::getInstance()->evalString(jsCallStr.c_str());
    se->evalString(jsCallStr.c_str());
    
    
    
    // 获取图片后返回
    [picker dismissViewControllerAnimated:YES
                               completion:nil];
}

//按取消按钮时候的功能
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    NSLog(@"取消照片选择");
    // 返回
    [picker dismissViewControllerAnimated:YES
                               completion:nil];
}

@end
