"use strict";
cc._RF.push(module, '891e369qIhIyKXBGrp9gX44', 'MainGame');
// Scripts/Game/MainGame.js

"use strict";

var CommonJS = require("Common");
cc.Class({
    extends: cc.Component,

    properties: {
        // brickPool:null,
        // coinPool:null,
        // squarePool:null,

        //节点
        MapNode: {
            default: null,
            type: cc.Node
        },
        PlayerNode: {
            default: null,
            type: cc.Node
        },
        bombNode: {
            default: null,
            type: cc.Node
        },
        brickNode: {
            default: null,
            type: cc.Node
        },
        bubbleNode: {
            default: null,
            type: cc.Node
        },
        coinNode: {
            default: null,
            type: cc.Node
        },
        finishingLineNode: {
            default: null,
            type: cc.Node
        },
        largerNode: {
            default: null,
            type: cc.Node
        },
        robotNode: {
            default: null,
            type: cc.Node
        },
        springNode: {
            default: null,
            type: cc.Node
        },
        squareNode: {
            default: null,
            type: cc.Node
        },
        starNode: {
            default: null,
            type: cc.Node
        },
        moneyShowNode: {
            default: null,
            type: cc.Node
        },
        conditionNode: {
            default: [],
            type: cc.Node
        },
        starNodeArr: {
            default: [],
            type: cc.Node
        },
        startUINode: {
            default: null,
            type: cc.Node
        },
        endUINode: {
            default: null,
            type: cc.Node
        },

        //预制体
        brickPrefab: {
            default: null,
            type: cc.Prefab
        },
        bubblePrefab: {
            default: null,
            type: cc.Prefab
        },
        coinPrefab: {
            default: null,
            type: cc.Prefab
        },
        finishingLinePrefab: {
            default: null,
            type: cc.Prefab
        },
        squarePrefab: {
            default: null,
            type: cc.Prefab
        },
        springPrefab: {
            default: null,
            type: cc.Prefab
        },
        smokePrefab: {
            default: null,
            type: cc.Prefab
        },
        coinBoomPrefab: {
            default: null,
            type: cc.Prefab
        },

        bgmAudio: {
            default: null,
            type: cc.AudioClip
        },
        boxBoomAudioClip: {
            default: null,
            type: cc.AudioClip
        },
        boxBoomAudioClip2: {
            default: null,
            type: cc.AudioClip
        },
        coinBoomAudioClip: {
            default: null,
            type: cc.AudioClip
        },
        bubbleBoomAudioClip: {
            default: null,
            type: cc.AudioClip
        },

        starSuc: {
            default: null,
            type: cc.SpriteFrame
        },
        starFail: {
            default: null,
            type: cc.SpriteFrame
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {
        var self = this;
        this.initPool();
        // this.touchFunciton();
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getCollisionManager().enabled = true; //开启碰撞检测
        var self = this;
        this.playBgm();
        cc.eventManager.addListener({
            event: cc.EventListener.TOUCH_ALL_AT_ONCE,
            onTouchesBegan: function onTouchesBegan(touches, event) {
                if (CommonJS.playerTouch === true) {
                    for (var i = 0; i < touches.length; i++) {
                        var touchMessage = touches[i].getLocation();
                        // console.log("touchStart",touchMessage);
                        if (touchMessage.x < CommonJS.windowWidth) {
                            console.log("跳跃");
                            self.PlayerNode.getComponent("Player").isJump = true;
                            var smoke = cc.instantiate(self.smokePrefab);
                            self.node.addChild(smoke);
                            smoke.position = self.PlayerNode.position;
                        } else {
                            self.PlayerNode.getComponent("Player").runAction();
                        }
                    }
                    return true;
                }
            },
            onTouchesEnded: function onTouchesEnded(touches, event) {
                if (CommonJS.playerTouch === true) {
                    for (var i = 0; i < touches.length; i++) {
                        var touchMessage = touches[i].getLocation();
                        // console.log("touchEnd",touchMessage);
                        if (touchMessage.x < CommonJS.windowWidth) {
                            self.PlayerNode.getComponent("Player").isJump = false;
                        }
                    }
                }
            }
        }, self.node);
    },
    start: function start() {},
    initPool: function initPool() {
        CommonJS.brickPool = new cc.NodePool();
        for (var i = 0; i < 100; i++) {
            var brickPre = cc.instantiate(this.brickPrefab); // 创建节点
            CommonJS.brickPool.put(brickPre);
        }

        CommonJS.bubblePool = new cc.NodePool();
        for (var i = 0; i < 100; i++) {
            var bubblePre = cc.instantiate(this.bubblePrefab); // 创建节点
            CommonJS.bubblePool.put(bubblePre);
        }

        CommonJS.coinPool = new cc.NodePool();
        for (var i = 0; i < 200; i++) {
            var coinPre = cc.instantiate(this.coinPrefab); // 创建节点
            CommonJS.coinPool.put(coinPre);
        }

        CommonJS.finishingLinePool = new cc.NodePool();
        for (var i = 0; i < 10; i++) {
            var finishingLinePre = cc.instantiate(this.finishingLinePrefab); // 创建节点
            CommonJS.finishingLinePool.put(finishingLinePre);
        }

        CommonJS.squarePool = new cc.NodePool();
        for (var i = 0; i < 500; i++) {
            var squarePre = cc.instantiate(this.squarePrefab); // 创建节点
            CommonJS.squarePool.put(squarePre);
        }

        CommonJS.springPool = new cc.NodePool();
        for (var i = 0; i < 20; i++) {
            var springPre = cc.instantiate(this.springPrefab); // 创建节点
            CommonJS.springPool.put(springPre);
        }

        CommonJS.coinBoomPool = new cc.NodePool();
        for (var i = 0; i < 100; i++) {
            var coinPre = cc.instantiate(this.coinBoomPrefab); // 创建节点
            CommonJS.coinBoomPool.put(coinPre);
        }
    },
    clearMap: function clearMap() {
        var mapNodeArr = this.MapNode.children;
        for (var i = 0; i < mapNodeArr.length; i++) {
            var childArr = mapNodeArr[i].children;
            for (var j = 0; j < childArr.length; j++) {
                console.log("节点分组为：", i, j, childArr[j].group);
                if (childArr[j].group === "brick") {
                    CommonJS.brickPool.put(childArr[j]);
                } else if (childArr[j].group === "bubble") {
                    CommonJS.bubblePool.put(childArr[j]);
                } else if (childArr[j].group === "coin") {
                    CommonJS.coinPool.put(childArr[j]);
                } else if (childArr[j].group === "finishingLine") {
                    childArr[j].destroy();
                    // CommonJS.finishingLinePool.put(childArr[j]);
                } else if (childArr[j].group === "square") {
                    CommonJS.squarePool.put(childArr[j]);
                } else if (childArr[j].group === "spring") {
                    CommonJS.springPool.put(childArr[j]);
                }
            }
        }
    },
    drawMap: function drawMap(mapNo) {
        console.log("画地图", mapNo);
        var passInfo = wx.getStorageSync("passInfo");
        var bombArr = passInfo[mapNo].bombArr;
        var brickArr = passInfo[mapNo].brickArr;
        var bubbleArr = passInfo[mapNo].bubbleArr;
        var coinArr = passInfo[mapNo].coinArr;
        var finishingLineArr = passInfo[mapNo].finishingLine;
        var largerArr = passInfo[mapNo].largerArr;
        var robotArr = passInfo[mapNo].robotArr;
        var springArr = passInfo[mapNo].springArr;
        var squareArr = passInfo[mapNo].squareArr;
        // var starArr = passInfo[mapNo].starArr;
        this.MapNode.position = cc.v2(-667, 375);
        for (var i = 0; i < bombArr.length; ++i) {
            // console.log("生成bombArr编号"+i)

        }
        for (var i = 0; i < brickArr.length; ++i) {
            // console.log("生成brickArr编号"+i)
            var brick;
            if (CommonJS.brickPool.size() > 0) {
                brick = CommonJS.brickPool.get();
            } else {
                brick = cc.instantiate(this.brickPrefab);
            }
            var pos = cc.v2(brickArr[i].position[0], -brickArr[i].position[1]);
            this.brickNode.addChild(brick);

            brick.position = pos;
        }

        for (var i = 0; i < bubbleArr.length; ++i) {
            // console.log("生成bubbleArr编号"+i)
            var bubble;
            if (CommonJS.bubblePool.size() > 0) {
                bubble = CommonJS.bubblePool.get();
            } else {
                bubble = cc.instantiate(this.bubblePrefab);
            }
            var pos = cc.v2(bubbleArr[i].position[0] + 60, -bubbleArr[i].position[1] - 60);
            this.bubbleNode.addChild(bubble);

            bubble.position = pos;
        }

        for (var i = 0; i < coinArr.length; ++i) {
            // console.log("生成coinArr编号"+i)
            var coin = null;
            if (CommonJS.coinPool.size() > 0) {
                coin = CommonJS.coinPool.get();
            } else {
                coin = cc.instantiate(this.coinPrefab);
            }
            var pos = cc.v2(coinArr[i].position[0] + 25, -coinArr[i].position[1] - 25);
            this.coinNode.addChild(coin);
            coin.position = pos;
        }

        for (var i = 0; i < 1; ++i) {
            // console.log("生成finishingLineArr")
            var finishingLine = null;
            if (CommonJS.finishingLinePool.size() > 0) {
                finishingLine = CommonJS.finishingLinePool.get();
            } else {
                finishingLine = cc.instantiate(this.finishingLinePrefab);
            }
            var pos = cc.v2(finishingLineArr.position[0], -finishingLineArr.position[1]);
            this.finishingLineNode.addChild(finishingLine);
            finishingLine.position = pos;
        }

        for (var i = 0; i < largerArr.length; ++i) {
            // console.log("生成largerArr编号"+i)
        }
        for (var i = 0; i < robotArr.length; ++i) {
            // console.log("生成robotArr编号"+i)
        }
        for (var i = 0; i < springArr.length; ++i) {
            // console.log("生成springArr编号"+i)
            var spring = null;
            if (CommonJS.springPool.size() > 0) {
                spring = CommonJS.springPool.get();
            } else {
                spring = cc.instantiate(this.springPrefab);
            }
            spring.getComponent("Spring").type = springArr[i].type;

            var pos = cc.v2(springArr[i].position[0], -springArr[i].position[1] - 50);
            if (springArr[i].type === 3) {
                spring.rotation = 180;
                pos = cc.v2(springArr[i].position[0], springArr[i].position[1] - 180);
            }
            this.springNode.addChild(spring);
            console.log(i, "+", pos);
            spring.position = pos;
        }

        for (var i = 0; i < squareArr.length; ++i) {
            // console.log("生成squareArr编号"+i)
            var square = null;
            if (CommonJS.squarePool.size() > 0) {
                square = CommonJS.squarePool.get();
            } else {
                square = cc.instantiate(this.squarePrefab);
            }
            var pos = cc.v2(squareArr[i].position[0], -squareArr[i].position[1]);
            this.squareNode.addChild(square);
            square.position = pos;
        }
        // for(var i = 0; i<starArr.length;++i){
        //     // console.log("生成starArr编号"+i)
        // }
    },
    mapRun: function mapRun() {},
    pauseBtn: function pauseBtn() {
        console.log("暂停");
        if (cc.director.getScheduler().getTimeScale() === 0) {
            cc.director.getScheduler().setTimeScale(1);
        } else {
            cc.director.getScheduler().setTimeScale(0);
        }
    },
    quickBtn: function quickBtn() {
        console.log("快放");
        if (cc.director.getScheduler().getTimeScale() === 2) {
            cc.director.getScheduler().setTimeScale(1);
        } else {
            cc.director.getScheduler().setTimeScale(2);
        }
    },
    slowBtn: function slowBtn() {
        console.log("慢放");
        if (cc.director.getScheduler().getTimeScale() === 0.5) {
            cc.director.getScheduler().setTimeScale(1);
        } else {
            cc.director.getScheduler().setTimeScale(0.5);
        }
    },
    restart: function restart() {
        this.MapNode.position = cc.v2(-667, 375);
    },
    sprintBtn: function sprintBtn() {
        console.log("向前加速");
        cc.director.getScheduler().setTimeScale(2);
        this.PlayerNode.getComponent("Player").runAction();
    },
    updateCoinNum: function updateCoinNum() {
        this.moneyShowNode.getChildByName("hpNum").getComponent(cc.Label).string = CommonJS.getCoinNum;
    },
    updateConditionInfo: function updateConditionInfo() {
        var self = this;
        var userInfo = wx.getStorageSync("userInfo");
        var passUnlockInfo = wx.getStorageSync("passUnlockInfo");
        var thisPassUnlock = passUnlockInfo[userInfo.max_pass + 1];
        this.node.getChildByName("ConditionNode").active = true;
        this.node.getChildByName("ConditionNode").getComponent(cc.Button).enabled = false;
        this.node.getChildByName("ConditionNode").getChildByName("Text").active = false;
        this.drawMap(userInfo.max_pass);
        this.node.getChildByName("ConditionNode").getChildByName("Prize").getComponent(cc.Label).string = thisPassUnlock[0].unlock_prize;
        for (var i = 0; i < 3; i++) {
            this.conditionNode[i].getComponent(cc.Label).string = thisPassUnlock[i].unlock_name;
            if (thisPassUnlock[i].is_unlock === 0) {
                this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = 0 + "/" + thisPassUnlock[i].unlock_num;
                this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starFail;
            } else {
                this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
            }
        }
        this.scheduleOnce(function () {
            //一秒后，开启按钮
            self.node.getChildByName("ConditionNode").getComponent(cc.Button).enabled = true;
            self.node.getChildByName("ConditionNode").getChildByName("Text").active = true;
        }, 1);
    },
    endConditionInfo: function endConditionInfo() {
        var self = this;
        var userInfo = wx.getStorageSync("userInfo");
        var passUnlockInfo = wx.getStorageSync("passUnlockInfo");
        var thisPassUnlock = passUnlockInfo[userInfo.max_pass + 1];
        var sendSucInfo = "";
        this.node.getChildByName("ConditionNode").active = true;
        this.node.getChildByName("ConditionNode").getComponent(cc.Button).enabled = false;
        this.node.getChildByName("ConditionNode").getChildByName("Text").active = false;
        this.node.getChildByName("ConditionNode").getChildByName("Prize").getComponent(cc.Label).string = thisPassUnlock[0].unlock_prize;
        for (var i = 0; i < 3; i++) {
            this.conditionNode[i].getComponent(cc.Label).string = thisPassUnlock[i].unlock_name;
            if (thisPassUnlock[i].type === 1 && thisPassUnlock[i].is_unlock === 0) {
                if (CommonJS.getBoxNum >= thisPassUnlock[i].unlock_num) {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                    sendSucInfo += (i + 1).toString() + ",";
                } else {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = CommonJS.getBoxNum + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starFail;
                }
            } else if (thisPassUnlock[i].type === 1 && thisPassUnlock[i].is_unlock === 1) {
                this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                sendSucInfo += (i + 1).toString() + ",";
            } else if (thisPassUnlock[i].type === 2 && thisPassUnlock[i].is_unlock === 0) {
                if (CommonJS.getCoinNum >= thisPassUnlock[i].unlock_num) {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                    sendSucInfo += (i + 1).toString() + ",";
                } else {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = CommonJS.getCoinNum + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starFail;
                }
            } else if (thisPassUnlock[i].type === 2 && thisPassUnlock[i].is_unlock === 1) {
                this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                sendSucInfo += (i + 1).toString() + ",";
            } else if (thisPassUnlock[i].type === 3 && thisPassUnlock[i].is_unlock === 0) {
                if (CommonJS.gameTime <= thisPassUnlock[i].unlock_num) {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = CommonJS.gameTime + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                    sendSucInfo += (i + 1).toString() + ",";
                } else {
                    this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = CommonJS.gameTime + "/" + thisPassUnlock[i].unlock_num;
                    this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starFail;
                }
            } else if (thisPassUnlock[i].type === 3 && thisPassUnlock[i].is_unlock === 1) {
                this.conditionNode[i].getChildByName("Percent").getComponent(cc.Label).string = thisPassUnlock[i].unlock_num + "/" + thisPassUnlock[i].unlock_num;
                this.starNodeArr[i].getComponent(cc.Sprite).spriteFrame = this.starSuc;
                sendSucInfo += (i + 1).toString() + ",";
            }
            if (i === 2) {
                sendSucInfo = sendSucInfo.substr(0, sendSucInfo.length - 1);
                console.log("处理以后", sendSucInfo);
            }
        }
        console.log("sendSucInfo", sendSucInfo, sendSucInfo.length);
        var mstr = wx.getStorageSync("mstr");
        wx.request({
            url: "https://yxdrs.zsmgc.com.cn/A/public/index/parkour/challenge",
            data: {
                mstr: mstr,
                pass_id: userInfo.max_pass,
                criteria: sendSucInfo
            },
            method: "POST",
            success: function success(res) {
                console.log("challenge接口对接成功", res);
                self.scheduleOnce(function () {
                    //一秒后，打开结算页面
                    self.node.getChildByName("ConditionNode").active = false;
                    self.endUINode.active = true; //1.字符串长度；2.关卡数；3.是否三星；4.三星奖励金币数
                    self.endUINode.getComponent("EndUI").endUIShow(sendSucInfo.length, userInfo.max_pass, res.data.data.is_receive, thisPassUnlock[0].unlock_prize);
                }, 3);
            }
        });
    },
    startGame: function startGame() {
        var _this = this;

        console.log("开始游戏");
        var runAction1 = cc.moveTo(2, cc.v2(-100, -249));
        var endAction = cc.callFunc(function () {
            console.log("位置", _this.node.getChildByName("Player").position);
            CommonJS.bgSpeed = 1;
            CommonJS.playerTouch = true;
            CommonJS.isGameStart = true;
            CommonJS.timeClock();
            console.log("计时器", CommonJS.isGameStart);
        });
        CommonJS.bgSpeed = 0;
        this.node.getChildByName("ConditionNode").active = false;
        cc.director.getScheduler().setTimeScale(1);
        this.node.getChildByName("Player").active = true;
        this.node.getChildByName("Player").stopAllActions();
        this.node.getChildByName("Player").position = cc.v2(-900, -240);
        this.node.getChildByName("Player").runAction(cc.sequence(runAction1, endAction));
        this.node.getChildByName("Player").getComponent("Player").isJump = false;
        this.node.getChildByName("Player").getComponent("Player").isSprint = false;
        this.node.getChildByName("Player").getComponent("Player").isInvincible = false;
        console.log("玩家初始化", this.node.getNumberOfRunningActions(), this.node.getChildByName("Player").position);
    },
    playBgm: function playBgm() {
        var bgmAudio = cc.audioEngine.playMusic(this.bgmAudio, true);
        cc.audioEngine.setVolume(bgmAudio, 0.2);
    },
    playBoxBoom1: function playBoxBoom1() {
        var boxBoomAudio = cc.audioEngine.play(this.boxBoomAudioClip, false, 1);
    },
    playBoxBoom2: function playBoxBoom2() {
        var boxBoomAudio = cc.audioEngine.play(this.boxBoomAudioClip2, false, 1);
    },
    playCoinBoom: function playCoinBoom() {
        var coinBoomAudioAudio = cc.audioEngine.play(this.coinBoomAudioClip, false, 1);
    },
    playBubbleBoom: function playBubbleBoom() {
        var bubbleAudio = cc.audioEngine.play(this.bubbleBoomAudioClip, false, 1);
    },
    update: function update(dt) {}
});

cc._RF.pop();