(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Scripts/Game/Player.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '88176iAfEpLp49jhBKfOG+f', 'Player', __filename);
// Scripts/Game/Player.js

"use strict";

var CommonJS = require("Common");
cc.Class({
    extends: cc.Component,

    properties: {
        hp: 0,
        isJump: false,
        isSprint: false,
        isInvincible: false,
        isJumpNode: {
            default: null,
            type: cc.Node
        },
        isSprintNode: {
            default: null,
            type: cc.Node
        },

        boxBoomPrefab: {
            default: null,
            type: cc.Prefab
        },
        bubbleBoomPrefab: {
            default: null,
            type: cc.Prefab
        },
        coinBoomPrefab: {
            default: null,
            type: cc.Prefab
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {
        var _this = this;

        this.mainGame = cc.find("Canvas/GameNode");
        this.startPos = this.node.position;
        this.gang_body = this.node.getComponent(cc.RigidBody);

        this.action1 = cc.moveBy(0.5, cc.v2(120, 0));
        this.action2 = cc.moveBy(0.5, cc.v2(120, 200));
        this.action3 = cc.moveBy(1, cc.v2(-120, 0));
        this.endAction = cc.callFunc(function () {
            _this.isSprint = false;
            _this.isInvincible = false;
            _this.node.getChildByName("DragonNode").rotation = 15;
            cc.director.getScheduler().setTimeScale(1);
        });
        this.endAction2 = cc.callFunc(function () {
            // this.gang_body.gravityScale = 5;
            cc.director.getPhysicsManager().enabled = true;

            CommonJS.bgSpeed = 1.1;
            _this.scheduleOnce(function () {
                this.node.getChildByName("SprintNode").active = false;
            }, 0.2);
            _this.scheduleOnce(function () {
                CommonJS.bgSpeed = 1;
            }, 0.5);
        });

        this.dropAction1 = cc.moveBy(0.5, cc.v2(-50, 0));
        this.dropAction2 = cc.moveBy(0.2, cc.v2(50, 0));
        this.dropEndAction2 = cc.callFunc(function () {
            CommonJS.bgSpeed = 1;
        });

        this.gameOverAction1 = cc.moveTo(2, cc.v2(1000, -249));
        this.gameOverAction2 = cc.callFunc(function () {
            CommonJS.bgSpeed = 0.1;
            _this.node.active = false;
            console.log("隐藏主角");
            // this.node.position=cc.v2(-900,249);
        });
    },
    start: function start() {},
    runAction: function runAction() {
        if (this.isSprint === false) {
            this.isSprint = true;
            this.isInvincible = true;
            // this.gang_body.gravityScale = 0;
            cc.director.getPhysicsManager().enabled = false;
            cc.director.getScheduler().setTimeScale(2);
            if (this.isJump === true) {
                this.node.getChildByName("SprintNode").active = true;
                this.node.runAction(cc.sequence(this.action2, this.endAction2, this.action3, this.endAction));
            } else {
                this.node.getChildByName("SprintNode").active = true;
                this.node.getChildByName("DragonNode").rotation = 30;
                this.node.runAction(cc.sequence(this.action1, this.endAction2, this.action3, this.endAction));
            }
        }
    },


    //碰撞检测
    onCollisionEnter: function onCollisionEnter(other, self) {
        console.log("碰到了：", other.node.group);
        if (other.node.group == "brick") {
            var pos = this.node.position;
            if (this.isInvincible === true) {
                var boxBoom = cc.instantiate(this.boxBoomPrefab);
                // other.node.parent.addChild(boxBoom);
                this.mainGame.addChild(boxBoom);
                boxBoom.position = pos;
                CommonJS.brickPool.put(other.node);
                this.mainGame.getComponent("MainGame").playBoxBoom1();
            } else {
                //减生命值，后退
                CommonJS.bgSpeed = 0;
                this.node.runAction(cc.sequence(this.dropAction1, this.dropAction2, this.dropEndAction2));
                this.mainGame.getComponent("MainGame").playBoxBoom2();
            }
        } else if (other.node.group == "box") {
            var pos = this.node.position;
            if (this.isInvincible === true) {
                var _boxBoom = cc.instantiate(this.boxBoomPrefab);
                // other.node.parent.addChild(boxBoom);
                this.mainGame.addChild(_boxBoom);
                _boxBoom.position = pos;
                CommonJS.squarePool.put(other.node);
                CommonJS.getBoxNum += 1;
                this.mainGame.getComponent("MainGame").playBoxBoom1();
            } else {
                //减生命值，后退
                CommonJS.bgSpeed = 0;
                this.node.runAction(cc.sequence(this.dropAction1, this.dropAction2, this.dropEndAction2));
                var _boxBoom2 = cc.instantiate(this.boxBoomPrefab);
                // other.node.parent.addChild(boxBoom);
                this.mainGame.addChild(_boxBoom2);
                _boxBoom2.position = pos;
                CommonJS.squarePool.put(other.node);
                this.mainGame.getComponent("MainGame").playBoxBoom2();
            }
        } else if (other.node.group == "coin") {
            var pos = other.node.position;
            var coinBoom = null;
            if (CommonJS.coinBoomPool.size() > 0) {
                coinBoom = CommonJS.coinBoomPool.get();
                console.log("够了");
            } else {
                coinBoom = cc.instantiate(this.coinBoomPrefab);
                console.log("不够");
            }
            other.node.parent.addChild(coinBoom);
            coinBoom.position = pos;
            CommonJS.coinPool.put(other.node);
            CommonJS.getCoinNum += 1;
            this.mainGame.getComponent("MainGame").playCoinBoom();
            this.mainGame.getComponent("MainGame").updateCoinNum();
        } else if (other.node.group == "spring") {
            other.node.getComponent("Spring").playAnim();
            console.log("type", other.node.getComponent("Spring").type);
            if (other.node.getComponent("Spring").type === 1) {
                //往上跳

                // this.node.stopAllActions();
                // console.log("速度",this.gang_body.linearVelocity)
                if (this.gang_body.linearVelocity.y > 1500) {
                    this.gang_body.linearVelocity = cc.v2(200, 1000);
                } else {
                    this.gang_body.linearVelocity = cc.v2(200, 1500);
                }
            } else if (other.node.getComponent("Spring").type === 2) {
                //斜着往上跳
                // this.node.stopAllActions();
                this.gang_body.linearVelocity = cc.v2(500, 1700);
            } else if (other.node.getComponent("Spring").type === 3) {
                //斜着往上跳
                // this.node.stopAllActions();
                this.gang_body.linearVelocity = cc.v2(500, -1700);
            }
        } else if (other.node.group == "bubble") {
            if (this.isInvincible === true) {
                var pos = other.node.position;
                var bubbleBoom = cc.instantiate(this.bubbleBoomPrefab);
                other.node.parent.addChild(bubbleBoom);
                bubbleBoom.position = pos;
                CommonJS.bubblePool.put(other.node);
                this.mainGame.getComponent("MainGame").playBubbleBoom();
                CommonJS.bgSpeed = 1;
            } else {
                cc.director.getPhysicsManager().enabled = false;
                CommonJS.bgSpeed = 0;
                this.mainGame.getComponent("MainGame").playBubbleBoom();
                this.node.runAction(cc.sequence(this.dropAction1, this.dropAction2));
                if (Math.abs(this.node.x - other.node.x - CommonJS.windowWidth) >= other.node.width) {
                    other.node.getComponent("Bubble").runScaleAction(1);
                } else {
                    other.node.getComponent("Bubble").runScaleAction(2);
                }
            }
        } else if (other.node.group === "finishingLine") {
            console.log("游戏结束");
            other.node.getChildByName("lightCross").active = true;
            other.node.getChildByName("left").active = true;
            other.node.getChildByName("right").active = true;
            CommonJS.bgSpeed = 0.1;
            CommonJS.isGameStart = false;
            console.log("游戏结束,用时：", CommonJS.gameTime);
            this.node.runAction(cc.sequence(this.gameOverAction1, this.gameOverAction2));
            this.mainGame.getComponent("MainGame").endConditionInfo();
        }
    },

    update: function update(dt) {
        if (this.isJump === true) {
            if (this.node.y >= 300) {
                this.isJump = false;
                this.gang_body.linearVelocity = cc.v2(0, 0);
                // console.log("速度为0");
                // this.node.runAction(cc.moveTo(1,this.startPos));
            } else {
                this.gang_body.linearVelocity = cc.v2(50, 300);
                // console.log("给个速度");
            }
        }

        if (this.node.x >= -100) {
            // console.log("超过-100");
            this.node.x -= 1;
            this.gang_body.linearVelocity.x -= 0.1;
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Player.js.map
        