
/**
 * 命名 node = n_  label = l_  sprite = sp_ button = btn_   scrollView = sc_
 */

var Point = function (x, y) {
    this.x = Number(x.toFixed(2)) || 0;
    this.y = Number(y.toFixed(2)) || 0;
}

Point.prototype = {
    /*~!Vector*/
    toArray: function () {
        return [this.x, this.y]
    },
    //加
    add: function (v) {
        return new Point(this.x + v.x, this.y + v.y);
    },
    //减
    sub: function (v) {
        return new Point(this.x - v.x, this.y - v.y);
    },
    //平方根
    getMod: function () {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    },
    //乘 除
    mulNum: function (num) {
        return new Point(this.x * num, this.y * num);
    },
    //负向量
    getNegative: function () {
        return new Point(-this.x, -this.y);
    },
    //点积
    dotMul: function (v) {
        return this.x * v.x + this.y * v.y;
    },
    /**
     *返回一个常数代表b在a上的投影乘以a的长度
     */
    crossMul: function (v) {
        return this.x * v.y - this.y * v.x;
    },
    /**
     *获取夹角,注意返回的是角度
     */
    getAngle: function (v) {
        return Math.acos(this.dotMul(v) / (this.getMod() * v.getMod())) * 180 / Math.PI;

    },
    /**
     *获取夹角,返回的是弧度
     */
    getRadian: function (v) {
        var m1 = this.getMod(), m2 = v.getMod();
        if (m1 == 0 || m2 == 0) {
            return 0;
        }
        return Math.acos(this.dotMul(v) / (m1 * m2));
    },
    distance: function (v) {
        return Math.sqrt((this.x - v.x) * (this.x - v.x) + (this.y - v.y) * (this.y - v.y))
    },
    distance2: function (v) {
        return (this.x - v.x) * (this.x - v.x) + (this.y - v.y) * (this.y - v.y)
    },
    /**
     *求某向量的法向量,返回一个单位向量,其模为1,返回的向量总是指向this向量的右边
     * @return
     */
    getNormal: function () {
        return new Point(this.y / (Math.sqrt(this.x * this.x + this.y * this.y)), -this.x / (Math.sqrt(this.x * this.x + this.y * this.y)));
    },
    reflex: function (v) {
        var normal = v.getNormal();//先求法向量

        return this.sub(normal.mulNum(2 * this.dotMul(normal)));
    },
    mirror: function (v) {
        return this.reflex(v).getNegative();
    },
    isZero: function () {
        if (this.x == 0 && this.y == 0) return true; else return false;
    },
    /**
     *判断某个点是否在某个矩形区域里，如果在里面的话，并且存在第四个参数的话（true），
     *就继续判断相对矩形中心点所在象限，最后返回象限，不存在第四个参数返回-1
     *如果不在矩形区域里，就直接返回false
     *
     *@param {vector} t 矩形左上角坐标
     *@param {vector} b 矩形右下角坐标
     *@param {boolean} q 是否返回象限
     *@return {number} 象限或者-1
     */
    isIn: function (t, b, q) {
        var r1 = this.sub(t), r2 = this.sub(b)
        if (r1.x >= 0 && r1.y >= 0 && r2.x <= 0 && r2.y <= 0) {
            if (q) {
                var c = t.add(b).mulNum(0.5)
                return this.getQ(c)
            } else {
                return -1;
            }
        } else {
            return false;
        }
    },
    /**
     *获取第一个点相对第二个点所在的象限
     *
     *@param {vector} pc 第二个点的坐标
     */
    getQ: function (pc) {
        var r = this.sub(pc);
        if (r.x >= 0 && r.y >= 0) {
            return 4
        } else if (r.x < 0 && r.y >= 0) {
            return 3
        } else if (r.x < 0 && r.y < 0) {
            return 2
        } else if (r.x >= 0 && r.y < 0) {
            return 1
        }
    },
    //向量的旋转 OB=(xcosα-ysinα,xsinα+ycosα)
    rotate: function (eg1) {
        var eg = (eg1 / 180) * Math.PI.toFixed(2)
        return new Point(this.x * Math.cos(eg) - this.y * Math.sin(eg), this.x * Math.sin(eg) + this.y * Math.cos(eg));
    },
    toString: function () {
        return this.x + ":" + this.y;
    }
    /*END~!Vector*/
}

var Utils = {

    //适配分辨率默认高度适配，iphonex宽度适配
    setDesignResolution: function () {
        var canvas = cc.find("Canvas").getComponent(cc.Canvas);
        let winSize = cc.director.getWinSize();
        if (winSize.width / winSize.height > 9 / 16) {
            canvas.fitWidth = false;
            canvas.fitHeight = true;
        } else {
            canvas.fitWidth = true;
            canvas.fitHeight = false;
        }
    },

    /**
     * 
     * @param {String} key 保存的键值
     * @param {String} value  保存的值
     */
    setKVUserData(key, value, success, fail) {
        if (window.GAME_SAVE_TYPE === 1) {
            cc.sys.localStorage.setItem(key, value);
        }
        else {
            // Data.setData(value, success, fail);
        }
    },

    /**
     * 
     * @param {String} key 获取对应内容的键值
     * @param {String} callback 存储服务端的话需要回调函数
     */
    getKVUserData(key, success, fail) {
        if (window.GAME_SAVE_TYPE === 1) {
            return cc.sys.localStorage.getItem(key);
        } else {
            Data.getData(success, fail);
        }
    },

    /**
     * 
     * @param {String} imagUrl 相对rescourse下的路径
     * @param {Number} type 加载资源类型
     * @param {*} callback 加载之后回调
     */
    loadRes(imagUrl, type, callback) {
        cc.loader.loadRes(imagUrl, type, function (err, obj) {
            if (err) {
                cc.error(err.message || err);
                return;
            }
            typeof (callback) == 'function' && callback(obj);
        });
    },


    /**
     * 
     * @param {*} node 淡入节点
     * @param {Number} time 淡入时间 默认1s
     */
    fadeIn(node, time) {
        let fadetime = time ? time : 1
        node.opacity = 0;
        node.runAction(cc.fadeIn(fadetime));
    },

    /**
     * 获取上传服务器的存储信息
     */
    getSaveData(callback) {
        if (window.GAME_SAVE_TYPE === 1) {
            let data = cc.sys.localStorage.getItem(window.GAME_SAVE_HANDLER);
            if (data) {
                window.INIT_GAME_SAVE_DATA = JSON.parse(data);
            }
            else {
                cc.sys.localStorage.setItem(window.GAME_SAVE_HANDLER, JSON.stringify(window.INIT_GAME_SAVE_DATA));
                data = window.INIT_GAME_SAVE_DATA;
            }
            // if(callback){
            //     callback(data);
            // }
        }
        else {
            Data.getData((res) => {
                if (res.data.data && res.data.data.length > 0 && res.data.data != '{}') {
                    // console.log("getSaveData", res.data.data);
                    window.INIT_GAME_SAVE_DATA = JSON.parse(res.data.data);
                    // window.INIT_GAME_SAVE_DATA.skin[window.INIT_GAME_SAVE_DATA.skin.length - 1] = 0;
                }
                for (let i = 0; i < 6; i++) {
                    if (!window.INIT_GAME_SAVE_DATA.skin[i]) {
                        window.INIT_GAME_SAVE_DATA.skin[i] = 0;
                    }
                }
                for (let j = 0; j < 10; j++) {
                    if (!window.INIT_GAME_SAVE_DATA.man[j]) {
                        window.INIT_GAME_SAVE_DATA.man[j] = 0;
                    }
                }
                if (callback) {
                    callback(window.INIT_GAME_SAVE_DATA);
                }
            }, () => {
                console.log("failed get data");
                if (window.isWeChatPlatform) {
                    wx.showModal({
                        title: '联网超时',
                        content: '获取服务器数据失败，请重试',
                        confirmText: '确定',
                        success: (res) => {
                            if (res.confirm) {
                                wx.exitMiniProgram();
                            }
                        },
                    });
                }
            });
        }
        // for (let i = 0; i < window.GAME_SAVE_SERIALIZE.length; i++) {
        //     let data = cc.sys.localStorage.getItem(window.GAME_SAVE_SERIALIZE[i]);
        //     if (data) {
        //         obj[window.GAME_SAVE_SERIALIZE[i]] = JSON.parse(data);
        //     }
        // }
        // return JSON.stringify(obj);
    },

    /**
     * 
     * @param {String} jsonobj 存储信息解析
     */
    setSaveData() {
        if (window.GAME_SAVE_TYPE === 1) {
            cc.sys.localStorage.setItem(window.GAME_SAVE_HANDLER, JSON.stringify(window.INIT_GAME_SAVE_DATA));
        } else {

            Data.setData(JSON.stringify(window.INIT_GAME_SAVE_DATA), () => {
                console.log("save net data success");
            }, () => {
                console.log("save net data fail");
                console.log("本地数据设置成功", JSON.stringify(window.INIT_GAME_SAVE_DATA));
                cc.sys.localStorage.setItem(window.GAME_SAVE_HANDLER, JSON.stringify(window.INIT_GAME_SAVE_DATA));
            });
        }
        // let obj = JSON.parse(jsonobj);
        // for (let i = 0; i < window.GAME_SAVE_SERIALIZE.length; i++) {
        //     if (obj[window.GAME_SAVE_SERIALIZE[i]]) {
        //         cc.sys.localStorage.setItem(window.GAME_SAVE_SERIALIZE[i], JSON.stringify(obj[window.GAME_SAVE_SERIALIZE[i]]));
        //     }
        // }
    },

    /**
     * @param {Number}min max随机数范围
     */
    random(min, max) {
        return min + Math.floor(Math.random() * (max - min));
    },

    /**
     * 获取两个点的夹角
     */
    getAngle(x1, y1, x2, y2) {
        // 直角的边长
        var x = Math.abs(x1 - x2);
        var y = Math.abs(y1 - y2);
        // 斜边长
        var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
        // 余弦
        var cos = y / z;
        // 弧度
        var radina = Math.acos(cos);
        // 角度
        var angle = 180 / (Math.PI / radina);
        return angle;
    },

    /**
     * @desc 从给定整数范围内生成n个不重复的随机数 n不能超过给定范围
     * @param {Number} min 
     * @param {Number} max 
     */
    getRandomSDiff(min, max, n) {
        if (max - min + 1 < n) return [];
        var originalArray = new Array;
        var len = max - min + 1;
        for (let i = 0; i < len; i++) {
            originalArray[i] = min + i;
        }
        var randomArray = new Array;
        for (let i = 0; i < n; i++) {
            let t = this.random(0, len - 1 - i)
            randomArray[i] = originalArray[t];
            var temp = originalArray[len - 1 - i];
            originalArray[len - 1 - i] = originalArray[t];
            originalArray[t] = temp;
        }
        return randomArray;
    },

    /**
     * 
     * @param {String} text 文字描述
     * @param {*} parentNode 父节点，默认cc.find("Canvas")
     * @param {Number} x *坐标x默认0
     * @param {Number} y *坐标y默认0
     * @param {Number} font_size*字体大小默认40
     * @param {*} color 字体颜色
     * @param {Number} time 飘字移动时间
     * @param {Number} ydis 移动距离
     */
    showTipsText(text, parentNode, x, y, font_size, color, time, ydis, type) {
        var node = new cc.Node('tipstext');
        node.setLocalZOrder(1000);
        var label = node.addComponent(cc.Label);
        label.fontFamily = '黑体';
        label.string = text;
        let xx = x ? x : 0;
        let yy = y ? y : 0;
        label.fontSize = font_size ? font_size : 40;
        label.lineHeight = font_size ? font_size + 10 : 40;
        node.color = color ? color : cc.Color.WHITE;
        if (parentNode && cc.isValid(parentNode)) {
            node.parent = parentNode;
        }
        else {
            node.parent = cc.find("Canvas");
        }
        let movetime = time ? time : 0.5;
        let dis = ydis ? ydis : 70;
        node.setPosition(xx, yy);
        var action1 = cc.moveBy(movetime, cc.p(0, dis))
        var action2 = cc.fadeOut(1)
        var action3 = cc.scaleTo(movetime, 1.3, 1.3);
        var action4 = cc.spawn(action1, action3);
        var action5 = type ? action1 : action4;
        node.runAction(cc.sequence(action5, action2, cc.callFunc(() => {
            node.destroy();
        })));
    },

    /**
     * 
     * @param {String} text 文字描述
     * @param {*} parentNode 父节点，默认cc.find("Canvas")
     * @param {Number} x *坐标x默认0
     * @param {Number} y *坐标y默认0
     * @param {Number} font_size*字体大小默认40
     * @param {*} color 字体颜色
     * @param {Number} time 飘字移动时间
     * @param {Number} ydis 移动距离
     */
    showPerfectText(text, parentNode, x, y, font_size, color) {
        var node = new cc.Node('prefecttext');

        var label = node.addComponent(cc.Label);
        label.fontFamily = '微软雅黑';
        label.string = text;
        let xx = x ? x : 0;
        let yy = y ? y : 0;
        label.fontSize = font_size ? font_size : 40;
        label.lineHeight = font_size ? font_size + 10 : 40;
        node.color = color ? color : cc.Color.WHITE;
        if (parentNode && cc.isValid(parentNode)) {
            node.parent = parentNode;
        }
        else {
            node.parent = cc.find("Canvas");
        }
        node.setLocalZOrder(1 << 10);
        node.setPosition(xx, yy);
        node.runAction(cc.sequence(cc.scaleTo(0.2, 1.5, 1.5).easing(cc.easeIn(3.0)),
            cc.scaleTo(0.2, 1.0, 1.0).easing(cc.easeOut(3.0)), cc.fadeOut(0.8), cc.callFunc(() => {
                node.destroy();
            })));
    },

    showTipsTextBg(text, parentNode, time, ydis, color) {
        cc.loader.loadRes('prefabs/n_showtips', cc.Prefab, function (err, obj) {
            if (err) {
                cc.error(err.message || err);
                return;
            }
            let node = cc.instantiate(obj);
            node.setLocalZOrder(1 << 10);
            let label = cc.find('bg/l_text', node).getComponent(cc.Label);
            label.string = text;
            if (color)
                label.node.color = color;
            if (parentNode && cc.isValid(parentNode)) {
                node.parent = parentNode;
            }
            else {
                node.parent = cc.find("Canvas");
            }
            let movetime = time ? time : 0.5;
            let dis = ydis ? ydis : 70;
            node.setPosition(0, 0);
            var action1 = cc.moveBy(movetime, cc.p(0, dis))
            var action2 = cc.fadeOut(1)
            // var action3 = cc.scaleTo(movetime, 1.3, 1.3);
            // var action4 = cc.spawn(action1, action3);
            node.runAction(cc.sequence(action1, action2, cc.callFunc(() => {
                node.destroy();
            })));
        });


    },

    /**
     * 
     * @param {String} text 文字描述
     * @param {*} parentNode 父节点，默认cc.find("Canvas")
     * @param {Number} x *坐标x默认0
     * @param {Number} y *坐标y默认0
     * @param {Number} font_size*字体大小默认40
     * @param {*} color 字体颜色
     * @param {Number} time 飘字移动时间
     * @param {Number} ydis 移动距离
     */
    showHurtText(text, parentNode, x, y, font_size, color, time, ydis) {
        var node = new cc.Node('hurttext');
        node.setLocalZOrder(1000);
        var label = node.addComponent(cc.Label);
        label.fontFamily = '微软雅黑';
        label.string = text;
        let xx = x ? x : 0;
        let yy = y ? y : 0;
        label.fontSize = font_size ? font_size : 40;
        label.lineHeight = font_size ? font_size + 10 : 40;
        node.color = color ? color : cc.Color.WHITE;
        if (parentNode && cc.isValid(parentNode)) {
            node.parent = parentNode;
        }
        else {
            node.parent = cc.find("Canvas");
        }
        let movetime = time ? time : 0.5;
        let dis = ydis ? ydis : 70;
        node.setPosition(xx, yy);
        this.dir = !this.dir;
        let movex = this.dir ? -45 : 45;
        var action1 = cc.moveBy(movetime, cc.p(movex, dis)).easing(cc.easeOut(3.0));
        var action2 = cc.fadeOut(1)
        var action3 = cc.scaleTo(movetime, 1.3, 1.3);
        var action4 = cc.spawn(action1, action3);
        node.runAction(cc.sequence(action4, action2, cc.callFunc(() => {
            node.destroy();
        })));
    },

    /**
     *          
     * @param {string} sprite_name 资源路径
     * @param {*} parentNode 父节点 默认canvas
     * @param {Vec2} startpos 开始位置
     * @param {Vec2} targetpos 结束位置
     * @param {function} callback 回调
     * @param {Number} time 时间
     */
    moveIcon(sprite_name, parentNode, startpos, targetpos, callback, time) {
        let runtime = time ? time : 1;
        this.loadRes(sprite_name, cc.SpriteFrame, (sprite) => {
            var node = new cc.Node('iconmove');
            var spritenode = node.addComponent(cc.Sprite);
            spritenode.spriteFrame = sprite;
            if (parentNode && cc.isValid(parentNode)) {
                node.parent = parentNode;
            }
            else {
                node.parent = cc.find("Canvas");
            }
            node.position = startpos;
            node.setLocalZOrder(1000);
            node.runAction(cc.sequence(cc.moveTo(runtime, targetpos).easing(cc.easeIn(3.0)), cc.callFunc(() => {
                if (callback)
                    callback();
                node.destroy();
            })));
        })
    },

    /**
     * 添加音效
     * @param musicUrl 音效路径
     * @constructor
     */
    SetSoundEffect(musicUrl, boo, volum) {
        let voluem = volum ? volum : 1;
        if (window.MUSIC_SHOW_OFF) {
            var audioUrl = cc.url.raw("resources/" + musicUrl);
            return cc.audioEngine.play(audioUrl, boo, voluem);
        }
    },

    stopSoundEffect(effectid) {
        if (typeof (effectid) == 'number') {
            cc.audioEngine.stop(effectid);
        }
    },

    //播放背景音乐
    playBgmMusic(musicUrl, volum) {
        if (window.MUSIC_SHOW_OFF && (typeof (window.bgmAudioID) != 'number')) {
            let voluem = volum ? volum : 1;
            var audioUrl = cc.url.raw("resources/" + musicUrl);
            window.bgmAudioID = cc.audioEngine.play(audioUrl, true, voluem);
        }
    },

    resumBgmMusic() {
        console.log("resumBgm", window.MUSIC_SHOW_OFF, window.bgmAudioID);
        if (window.MUSIC_SHOW_OFF) {
            // cc.audioEngine.resumeAll();
            // cc.audioEngine.stopAll();
            // let voluem = volum ? volum : 1;
            cc.audioEngine.stop(window.bgmAudioID);
            window.bgmAudioID = null;
            setTimeout(() => {
                var audioUrl = cc.url.raw("resources/" + window.BGM);
                window.bgmAudioID = cc.audioEngine.play(audioUrl, true, 0.5);
            }, 500);
        }
    },

    //停止背景音乐
    stopBgmMusic() {
        cc.audioEngine.stopAll();
        window.bgmAudioID = null;
    },

    //格式化秒数
    /**
     * 
     * @param {Number} sec 秒数
     */
    formatSecToTime(s) {
        var t;
        if (s > -1) {
            var hour = Math.floor(s / 3600);
            var min = Math.floor(s / 60) % 60;
            var sec = s % 60;
            if (hour < 10) {
                t = '0' + hour + ":";
            } else {
                t = hour + ":";
            }

            if (min < 10) { t += "0"; }
            t += min + ":";
            if (sec < 10) { t += "0"; }
            t += sec;
        }
        return t;
    },

    /**
     * 求两个向量的夹角
     */
    getAngle(v, v2) {
        var p1 = new Point(v.x, v.y);
        var p2 = new Point(v2.x, v2.y);
        return p1.getAngle(p2);
    },

    getPoint(x, y) {
        return new Point(x, y);
    },


    timestampToTime(timestamp) {
        var date = new Date(timestamp);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
        // Y = date.getFullYear() + '-';
        // M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
        // D = date.getDate() + ' ';
        // h = date.getHours() + ':';
        // m = date.getMinutes() + ':';
        // s = date.getSeconds();
        return date;
        // return Y + M + D + h + m + s;
    }
};


module.exports = Utils;