// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class AutoExactFit extends cc.Component {

    start() {
        let currentSize = cc.view.getCanvasSize();
        let designSize = cc.view.getDesignResolutionSize();
        let scale = this.convertScale(designSize.width, designSize.height, currentSize.width, currentSize.height);
        cc.Canvas.instance.node.scaleX = scale.scaleW;
        cc.Canvas.instance.node.scaleY = scale.scaleH;
        console.log(scale);
    }

    convertScale(dW: number, dH: number, cW: number, cH: number): { scaleW: number, scaleH: number } {
        let a = dW / dH;
        let b = cW / cH;
        let scaleW = 1;
        let scaleH = 1;
        if (a < b) { // 宽度比设计分辨率大，缩放W
            scaleW = b / a;
        } else { // 高度比设计分辨率大，缩放H
            scaleH = a / b;
        }
        return { scaleW: scaleW, scaleH: scaleH };
    }

    // update (dt) {}
}
