/**
 * 优化NPC生成动画clip的代码 避免多个相同角色多次重复执行相同代码，
 *  主题：
 *    一个npc实例化后， 会进行模板生成，这个过程中，需要根据动画ID去查找相应帧
 *    最后将6个基本动作全部创建成clip
 *    
 *    这意味着 如果NPC的外观是一致的，那么重复的代码就会执行，带来没必要的消耗
*/

// 调用方式： NpcAniManager.getWalkA(id: number) // 如果没找到返回undefined

export default class NpcAniManager {
  // 动画帧存储对象
  static _anims: object = {}

  // 获取动画帧
  static getAnimClip(id: number, clipName: string): cc.AnimationClip {
    // 避免多次访问
    let temp = this._anims[id]
    // 查找是否有此动画帧对象
    if (!temp) return
    // 返回结果 可能是undefined 或者 clip
    return temp[clipName]
  }

  // 获取某个ID的所有动画帧
  static getAnimAllClip(id: number) {
    return this._anims[id]
  }

  // 保存动画帧
  static _setAnimClip(id: number, clipName: string, clip: cc.AnimationClip) {
    let temp = this._anims[id]
    // 赋值空对象 以id为名
    if (!temp) temp = this._anims[id] = {}
    // clipName 为key clip 为值
    return temp[clipName] = clip
  }

  // 动态添加clip
  static createClip(id: number, frames: Array<cc.SpriteFrame>, name: string, ispeed: number = 1, wrapMode: cc.WrapMode = cc.WrapMode.Loop): cc.AnimationClip {
    // 创建一个clip
    let clip = cc.AnimationClip.createWithSpriteFrames(frames, frames.length)
    // 命名
    clip.name = name
    // 播放速度
    clip.speed = ispeed
    // 播放速率
    clip.sample = 60
    // 循环模式
    clip.wrapMode = wrapMode

    // 保存动画帧
    this._setAnimClip(id, name, clip)

    return clip
  }

  // 创建动画
  static createFrames(arr: Array<string>, atlas: cc.SpriteAtlas): Array<cc.SpriteFrame> {
    let frames = []
    // 动态创建clip 
    arr.forEach((item, i) => {

      let sprite = atlas.getSpriteFrame(item)
      // 异常处理
      if (!sprite) {
        console.warn('获取帧错误, 这将导致动画播放异常 ' + item)
      }
      frames[i] = sprite
    })
    // 
    return frames
  }

}

/**
let animAllClip = NpcAniManager.getAnimAllClip(animId)

    if (animAllClip) { // 存在的情况
      let {npc1_front, npc1_rear, stand_a, stand_b, action_a, action_b} = animAllClip
      // 更改动画速度
      npc1_front.speed = this.walkIspeed
      npc1_rear.speed = this.walkIspeed
      
      // 添加动画帧
      npcAnim.addClip(npc1_front)
      npcAnim.addClip(npc1_rear)
      npcAnim.addClip(stand_a)
      npcAnim.addClip(stand_b)
      npcAnim.addClip(action_a)
      npcAnim.addClip(action_b)

    }
*/