import NpcManager from "./EVA_npc/NpcManager";
// 资源加载类
import ResLoaderManager from "./Manager/ResLoaderManager";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Game extends cc.Component {

  // npc 管理者
  npcManager: NpcManager = null

  sm: ResLoaderManager = null

  //Test 引导
  guideIndex = 0;

  // 初始化
  init() {
    // 资源管理实例
    this.sm = ResLoaderManager.getInstance()
    // 获取NPC管理器实例
    this.npcManager = NpcManager.getInstance()
  }

  // 加载开始
  load() {
    // 资源加载器
    let res = ResLoaderManager.getInstance()
    res.initJsonCfg((completedCount, totalCount) => { // 加载配置资源
      if (completedCount === totalCount) {
        res.initPrefaRes((completedCount, totalCount) => { // 加载预制体资源
          if (completedCount === totalCount) {
            res.initSpriteAtlas((completedCount, totalCount) => { // 加载图集资源
              if (completedCount === totalCount) { // 加载完成
                this.loadOver()
              }
            })
          }

        })
      }
    })
  }

  loadOver() {
    // NPC管理器初始化自己所需的数据
    this.npcManager.init()
    // NPC管理器初始化数据完成后 开始创建NPC
    this.npcManager.npcStart()
  }


  onLoad() {
    // 初始化程序
    this.init()
    this.load()
  }

  // start() { }

  // update (dt) {}
}