
/** 资源加载路径 需要加载的所有资源*/
export const SpAtlasPath = [
  // NPC 图集
  "npc/adult01",
]

/** 预制体资源路径*/
export const PrefabPath = [
  "prefab/eva_npc/npc"
]

export const JsonCfgPath = [
  "jsonCfg/animation",
  "jsonCfg/visitor",
]
/** 资源管理类*/
export default class ResLoaderManager {

  /** 图集资源列表*/
  private spAtlasDatas: Map<string, cc.SpriteAtlas> = new Map();
  /** 配置资源列表*/
  private cfgDatas: Map<string, any> = new Map();
  /** 预制体资源列表*/
  private prfDatas: Map<string, cc.Prefab> = new Map();

  //管理各类数据
  private static _instance: ResLoaderManager;

  static getInstance() {
    if (!this._instance) {
      this._instance = new ResLoaderManager();
    }
    return this._instance;
  }

  initSpriteAtlas(cb: Function) {
    //初始加载所有游戏资源
    //加载过程回调
    let progressCallback = (completedCount, totalCount, item) => { cb(completedCount, totalCount) }
    //加载结束回调
    let completeCallback = (err, resource) => {
      if (err) {
        cc.error(err)
        return;
      }

      for (let i = 0; i < resource.length; i++) {
        let strArr = resource[i].name.split(".");
        this.spAtlasDatas.set(strArr[0], resource[i]);
      }

    }

    cc.loader.loadResArray(SpAtlasPath, cc.SpriteAtlas, progressCallback, completeCallback)
  }

  /** 配置数据加载*/
  initJsonCfg(cb: Function) {
    //加载过程回调
    let progressCallback = (completedCount, totalCount, item) => { cb(completedCount, totalCount) }
    //加载结束回调
    let completeCallback = (err, jsonArr) => {
      if (err) {
        cc.error(err)
        return;
      }
      // 便利结果
      jsonArr.forEach(item => {
        // 获取配置文件名
        let name = item.name
        this.cfgDatas.set(name, item.json)
      });
      // cc.log(jsonArr);
    }

    cc.loader.loadResArray(JsonCfgPath, cc.JsonAsset, progressCallback, completeCallback)

  }

  /** 预制体资源加载*/
  initPrefaRes(cb: Function) {
    //加载过程回调
    let progressCallback = (completedCount, totalCount, item) => { cb(completedCount, totalCount) }
    //加载结束回调
    let completeCallback = (err, prefabs) => {
      if (err) {
        cc.error(err)
        return;
      }
      //cc.log(prefabs);
      prefabs.forEach(item => this.prfDatas.set(item.name, item))
    }

    cc.loader.loadResArray(PrefabPath, cc.Prefab, progressCallback, completeCallback)

  }

  /** 根据名字获取某张图集*/
  public getSpriteAtlasByName(name: string) {

    let data = this.spAtlasDatas.get(name);

    return data;
  }

  /** 根据名字获取某个预制体*/

  public getPrefab(name: string) {
    return this.prfDatas.get(name)
  }

  /** 根据名字获取某个配置表*/

  public getConfig(name: string) {
    return this.cfgDatas.get(name)
  }

}
