
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/scripts/AStar/AStarManager');
require('./assets/scripts/AStar/AStarNode');
require('./assets/scripts/AStar/BinaryHeap');
require('./assets/scripts/EVA_npc/NpcAniManager');
require('./assets/scripts/EVA_npc/NpcManager');
require('./assets/scripts/EVA_npc/NpcNormal');
require('./assets/scripts/EVA_npc/NpcSuper');
require('./assets/scripts/Game');
require('./assets/scripts/Manager/ResLoaderManager');
require('./assets/scripts/util/MapControl');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/AStar/AStarManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7fbcfPuElhNDr5d2sH+uzyy', 'AStarManager');
// scripts/AStar/AStarManager.ts

"use strict";
// /**
//  * A 星算法 管理器， 提供路径查找等功能， 地图为内置， 属于定制化 Manager
//  * 
// */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var BinaryHeap_1 = require("./BinaryHeap");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var AStarManager = /** @class */ (function () {
    // 私有化构造函数
    function AStarManager() {
        // 开放列表
        this.openList = new BinaryHeap_1.default();
        // 关闭列表
        this.closeList = null;
        // 哈希表 提升查找性能
        this.nodeSet = new Map();
        // 地图信息 是公共的 二维数组
        this.mapArr = [];
        // 遮挡物图层对象
        this.wallLayer = null;
        // 初始化信息
        this.initData();
        // 对于当前场景而言， 地图只需要初始化一次
        this.initMap();
    }
    AStarManager_1 = AStarManager;
    // 访问实例的唯一方式
    AStarManager.getInstance = function () {
        if (this.instance === null) {
            this.instance = new AStarManager_1();
        }
        return this.instance;
    };
    // 初始化需要动态加载的信息
    AStarManager.prototype.initData = function () {
        // 获取节点
        var node = cc.find('Canvas/Baseview/obj_map/map100');
        // 获取节点下的遮挡物组件
        this.wallLayer = node.getComponent(cc.TiledMap).getLayer('wall');
    };
    // 初始化地图 64 * 64 目前为手动设置
    AStarManager.prototype.initMap = function () {
        // 初始化地图
        for (var i = 0; i < 145; i++) { //93
            this.mapArr[i] = [];
            for (var j = 0; j < 29; j++) { // 145/5    135 / 5   27
                // 减少计算
                var temp = j * 5;
                // 初始化每一个点的坐标
                this.mapArr[i][temp] = {
                    x: i,
                    y: temp
                };
                this.mapArr[i][temp + 1] = {
                    x: i,
                    y: temp + 1
                };
                this.mapArr[i][temp + 2] = {
                    x: i,
                    y: temp + 2
                };
                this.mapArr[i][temp + 3] = {
                    x: i,
                    y: temp + 3
                };
                this.mapArr[i][temp + 4] = {
                    x: i,
                    y: temp + 4
                };
            }
        }
    };
    // 路径查找， 传入坐标点 
    AStarManager.prototype.findPath = function (beginPoint, endPoint) {
        var _a = this, closeList = _a.closeList, openList = _a.openList, mapArr = _a.mapArr, nodeSet = _a.nodeSet, findNearNodeToOpenList = this.findNearNodeToOpenList.bind(this);
        // 先清除一遍
        this.openList.clear();
        // hast表清空
        nodeSet.clear();
        // 绑定this
        // 重置开放列表和关闭列表
        closeList = this.closeList = [];
        openList = this.openList;
        // 传入的起点坐标和终点坐标一致，应该如何处理
        if (beginPoint.x === endPoint.x && beginPoint.y === endPoint.y) {
            console.log('起点和终点位置相同');
            return null;
        }
        // 判断传入的数值是否是非法
        if (beginPoint.x >= mapArr.length ||
            endPoint.x >= mapArr.length ||
            beginPoint.y >= mapArr[0].length ||
            endPoint.y >= mapArr[0].length) {
            console.log('传入坐标非法');
            return null;
        }
        // 初始化起点节点
        var startNode = {
            x: beginPoint.x,
            y: beginPoint.y,
            g: 0, h: 0, f: 0,
            parent: null
        };
        // 将当前起点坐标传入关闭列表中
        closeList.push(startNode);
        // 初始化hash
        nodeSet.set(startNode.x + ',' + startNode.y, 1);
        // 开始寻路 当前场景不进行斜边寻路 如果在地图周围都围上一层空白的墙，可以减少掉很多程序判断的过程
        while (true) {
            var startNodeX = startNode.x, startNodeY = startNode.y;
            // {x-1,y} 
            findNearNodeToOpenList(startNodeX - 1, startNodeY, endPoint, startNode);
            // {x,y-1}
            findNearNodeToOpenList(startNodeX, startNodeY - 1, endPoint, startNode);
            // {x,y+1}
            findNearNodeToOpenList(startNodeX, startNodeY + 1, endPoint, startNode);
            // {x+1,y}
            findNearNodeToOpenList(startNodeX + 1, startNodeY, endPoint, startNode);
            // 记录下一次的起点
            startNode = openList.shift();
            // 取出f值最小的那位， 放入closeList中
            closeList.push(startNode);
            if (!startNode) {
                return null;
            }
            // 判断起点是否和终点相同 或者循环次数达到性能峰值
            if (openList.getLength() <= 0) {
                console.warn('未找到可行路径');
                // 路径被穷尽
                return null;
            }
            else if (startNode.x === endPoint.x && startNode.y === endPoint.y) { // 是否没有寻找到路径
                // 查找到路径 存放的数组
                var pathList = [];
                // 取出最后一位节点
                var lastNode = closeList[closeList.length - 1];
                pathList.push(lastNode);
                // 开始回溯
                while (lastNode.parent !== null) {
                    // 插入节点
                    pathList.unshift(lastNode.parent);
                    // 循环引用
                    lastNode = lastNode.parent;
                }
                // 弹出路径列表
                return pathList;
            }
        }
    };
    // 寻找周围的坐标， 并且将其加入openList中
    AStarManager.prototype.findNearNodeToOpenList = function (x, y, endNode, parentNode) {
        var _a = this, mapArr = _a.mapArr, wallLayer = _a.wallLayer, openList = _a.openList, nodeSet = _a.nodeSet, g = 1, key, h, pathNode;
        // 判断传入的数值是否是非法 坐标超出边界
        if (x >= mapArr.length ||
            x < 0 ||
            y >= mapArr[0].length ||
            y < 0)
            return null;
        // 再次判断当前点是否是可通行路径，  
        if (wallLayer.getTileGIDAt(x, y) !== 0)
            return;
        //根据房间是否解锁来解锁寻路
        // if (wallLayer.getTileGIDAt(x, y) == 0) return
        // if (wallLayer.getTileGIDAt(x, y) == 17) return;
        // if (wallLayer.getTileGIDAt(x, y) == 18) return;
        // if (wallLayer.getTileGIDAt(x, y) == 19) return;
        // if (wallLayer.getTileGIDAt(x, y) == 20) return;
        // 保存下key，后面还要使用
        key = x + ',' + y;
        // 判断当前点是否存在于 开放列表或者关闭列表中 如果存在则直接返回
        if (nodeSet.has(key))
            return;
        // 通路， 计算 g， f， h
        // 计算离起点距离， 起点距离就是 当前点的g值， 加上父节点的g值
        g = g + parentNode.g;
        // 离终点距离 曼哈顿式
        h = Math.abs(x - endNode.x) + Math.abs(y - endNode.y);
        // h = (x - endNode.x) * (((x - endNode.x) >> 31 << 1) + 1) + (x - endNode.x) * (((x - endNode.x) >> 31 << 1) + 1)
        // 路径节点
        pathNode = {
            x: x, y: y, g: g, h: h,
            f: g + h,
            // 回溯所需父节点
            parent: parentNode
        };
        // 加入开放列表中
        openList.insert(pathNode);
        // 存入hash
        nodeSet.set(key, 1);
        return true;
    };
    var AStarManager_1;
    // 单例
    AStarManager.instance = null;
    AStarManager = AStarManager_1 = __decorate([
        ccclass
    ], AStarManager);
    return AStarManager;
}());
exports.default = AStarManager;
/**
 * hash 表查找优化
 *  A 星查找路径中，当其获取到一个点，他要去开放列表和关闭列表中查看是否有这个值，比对的就是x，y值
 *  如果有就退出程序，如果没有则加入开放列表
 *  存储的key 以这种形式 x + ',' + y -> 3,23 保证不重复 字符串形式
 *
 *  经数据证实， 大数据下Map的查找比Set快
 *
 *  大体优化已完成
 *    细节优化：
 *      1. 减少while 中的function，set，get
 *          function 的执行会进入调用栈，减少function可以减少调用栈
 *
 *  初始化优化：
 *    一开始生成地图数组信息，需要双层循环，这两层循环数量太大，93 * 135 = 12555 初始化需要上万次循环
 *
 *    减少循环次数，在同一个循环中处理更多的事情 在第二层for循环中，减少循环次数，增加每次循环做的事情， 那么初始化循环只需要执行 2000多次
 *
 *
*/

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/Game.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '65c1aiT6bVJ4bfXcq+jnmrf', 'Game');
// scripts/Game.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NpcManager_1 = require("./EVA_npc/NpcManager");
// 资源加载类
var ResLoaderManager_1 = require("./Manager/ResLoaderManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Game = /** @class */ (function (_super) {
    __extends(Game, _super);
    function Game() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // npc 管理者
        _this.npcManager = null;
        _this.sm = null;
        //Test 引导
        _this.guideIndex = 0;
        return _this;
        // start() { }
        // update (dt) {}
    }
    // 初始化
    Game.prototype.init = function () {
        // 资源管理实例
        this.sm = ResLoaderManager_1.default.getInstance();
        // 获取NPC管理器实例
        this.npcManager = NpcManager_1.default.getInstance();
    };
    // 加载开始
    Game.prototype.load = function () {
        var _this = this;
        // 资源加载器
        var res = ResLoaderManager_1.default.getInstance();
        res.initJsonCfg(function (completedCount, totalCount) {
            if (completedCount === totalCount) {
                res.initPrefaRes(function (completedCount, totalCount) {
                    if (completedCount === totalCount) {
                        res.initSpriteAtlas(function (completedCount, totalCount) {
                            if (completedCount === totalCount) { // 加载完成
                                _this.loadOver();
                            }
                        });
                    }
                });
            }
        });
    };
    Game.prototype.loadOver = function () {
        // NPC管理器初始化自己所需的数据
        this.npcManager.init();
        // NPC管理器初始化数据完成后 开始创建NPC
        this.npcManager.npcStart();
    };
    Game.prototype.onLoad = function () {
        // 初始化程序
        this.init();
        this.load();
    };
    Game = __decorate([
        ccclass
    ], Game);
    return Game;
}(cc.Component));
exports.default = Game;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/util/MapControl.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1758aVZtK5Gzq+5vGDpXX2/', 'MapControl');
// scripts/util/MapControl.ts

"use strict";
/**
 * @author xshu
 * @date 2019-12-07
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var MapControl = /** @class */ (function (_super) {
    __extends(MapControl, _super);
    function MapControl() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.map = null;
        _this.scaleTime = null;
        _this.defaultScaling = 1;
        _this.minScale = 0.61; //小于这个会露底
        _this.maxScale = 1.5;
        _this.moveOffset = 2;
        _this.increaseRate = 10000;
        _this.locked = false; // 操作锁
        _this.singleTouchCb = null; // 点击回调函数
        _this.isMoving = false; // 是否拖动地图flag
        _this.mapTouchList = []; // 触摸点列表容器
        _this.isStrict = false; // 默认为非严格模式
        return _this;
    }
    MapControl.prototype.onLoad = function () {
        this.map = cc.find("obj_map", this.node);
    };
    MapControl.prototype.start = function () {
        this.addEvent();
        //this.smoothOperate(this.map, cc.Vec2.ZERO, this.defaultScaling); //cc.Vec2.ZERO   cc.v2(-3440, -1720)
    };
    // 有些设备单点过于灵敏，单点操作会触发TOUCH_MOVE回调，在这里作误差值判断
    MapControl.prototype.canStartMove = function (touch) {
        var startPos = touch.getStartLocation();
        var nowPos = touch.getLocation();
        // 有些设备单点过于灵敏，单点操作会触发TOUCH_MOVE回调，在这里作误差值判断
        return (Math.abs(nowPos.x - startPos.x) > this.moveOffset
            || Math.abs(nowPos.y - startPos.y) > this.moveOffset);
    };
    MapControl.prototype.addEvent = function () {
        var _this = this;
        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
            if (_this.locked)
                return;
            var touches = event.getTouches(); // 获取所有触摸点
            if (_this.isStrict) { // 严格模式下过滤掉初始点击位置不在目标节点范围内的触摸点
                touches
                    .filter(function (v) {
                    var startPos = cc.v2(v.getStartLocation()); // 触摸点最初的位置
                    var worldPos = _this.node.convertToWorldSpaceAR(cc.Vec2.ZERO);
                    var worldRect = cc.rect(worldPos.x - _this.node.width / 2, worldPos.y - _this.node.height / 2, _this.node.width, _this.node.height);
                    return worldRect.contains(startPos);
                })
                    .forEach(function (v) {
                    var intersection = _this.mapTouchList.filter(function (v1) { return v1.id === v.getID(); });
                    if (intersection.length === 0)
                        _this.mapTouchList[_this.mapTouchList.length] = ({ id: v.getID(), touch: v });
                });
                touches = _this.mapTouchList.map(function (v) { return v.touch; });
            }
            if (touches.length >= 2) {
                // multi touch
                _this.isMoving = true;
                var touch1 = touches[0];
                var touch2 = touches[1];
                var delta1 = cc.v2(touch1.getDelta());
                var delta2 = cc.v2(touch2.getDelta());
                var touchPoint1 = _this.map.convertToNodeSpaceAR(cc.v2(touch1.getLocation()));
                var touchPoint2 = _this.map.convertToNodeSpaceAR(cc.v2(touch2.getLocation()));
                var distance = touchPoint1.sub(touchPoint2);
                var delta = delta1.sub(delta2);
                var scale = 1;
                if (Math.abs(distance.x) > Math.abs(distance.y)) {
                    scale = (distance.x + delta.x) / distance.x * _this.map.scaleX;
                }
                else {
                    scale = (distance.y + delta.y) / distance.y * _this.map.scaleY;
                }
                var pos = touchPoint2.add(cc.v2(distance.x / 2, distance.y / 2));
                _this.smoothOperate(_this.map, pos, scale);
            }
            else if (touches.length === 1) {
                // single touch
                // cc.log(this.canStartMove(touches[0]));
                // cc.log(this.isMoving);
                if (_this.isMoving || _this.canStartMove(touches[0])) {
                    _this.isMoving = true;
                    var dir = cc.v2(touches[0].getDelta());
                    _this.dealMove(dir, _this.map, _this.node);
                }
            }
        });
        this.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (this.locked)
                return;
            var touches = this.isStrict ? this.mapTouchList : event.getTouches();
            if (touches.length <= 1) {
                if (!this.isMoving) {
                    var worldPos = cc.v2(event.getLocation());
                    var nodePos = this.map.convertToNodeSpaceAR(worldPos);
                    this.dealSelect(nodePos);
                }
                this.isMoving = false; // 当容器中仅剩最后一个触摸点时将移动flag还原
            }
            ;
            if (this.isStrict)
                this.removeTouchFromContent(event, this.mapTouchList);
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
            if (this.locked)
                return;
            var touches = this.isStrict ? this.mapTouchList : event.getTouches();
            // 当容器中仅剩最后一个触摸点时将移动flag还原
            if (touches.length <= 1)
                this.isMoving = false;
            if (this.isStrict)
                this.removeTouchFromContent(event, this.mapTouchList);
        }, this);
        //gun
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, function (event) {
            if (this.locked)
                return;
            var worldPos = cc.v2(event.getLocation());
            var scrollDelta = event.getScrollY();
            var scale = (this.map.scale + (scrollDelta / this.increaseRate));
            var target = this.map;
            var pos = target.convertToNodeSpaceAR(worldPos);
            this.smoothOperate(target, pos, scale);
        }, this);
    };
    MapControl.prototype.removeTouchFromContent = function (event, content) {
        var eventToucheIDs = event['getTouches']().map(function (v) { return v.getID(); });
        for (var len = content.length, i = len - 1; i >= 0; --i) {
            if (eventToucheIDs.indexOf(content[i].id) > -1)
                content.splice(i, 1); // 删除触摸
        }
    };
    MapControl.prototype.smoothOperate = function (target, pos, scale) {
        // 放大缩小
        if (this.minScale <= scale && scale <= this.maxScale) {
            // 当前缩放值与原来缩放值之差
            var deltaScale = scale - target.scaleX;
            // 当前点击的坐标与缩放值差像乘
            var gapPos = pos.scale(cc.v2(deltaScale, deltaScale));
            // 当前node坐标位置减去点击 点击坐标和缩放值的值
            var mapPos = target.getPosition().sub(gapPos);
            scale = Math.floor(scale * 100) / 100;
            target.scale = scale;
            this.dealScalePos(mapPos, target);
        }
        else {
            scale = cc.misc.clampf(scale, this.minScale, this.maxScale);
        }
        if (cc.isValid(this.scaleTime)) // 更新 label 显示
            this.scaleTime.string = "缩放：" + (Math.floor(scale * 100) + "%");
    };
    MapControl.prototype.dealScalePos = function (pos, target) {
        if (target.scale === 1) {
            pos = cc.Vec2.ZERO;
            //pos = cc.v2(-3440, -1720);
        }
        else {
            var worldPos = this.node.convertToWorldSpaceAR(pos);
            var nodePos = this.node.convertToNodeSpaceAR(worldPos);
            var edge = this.calculateEdge(target, this.node, nodePos);
            if (edge.left > 0) {
                pos.x -= edge.left;
            }
            if (edge.right > 0) {
                pos.x += edge.right;
            }
            if (edge.top > 0) {
                pos.y += edge.top;
            }
            if (edge.bottom > 0) {
                pos.y -= edge.bottom;
            }
        }
        target.setPosition(pos);
    };
    /** 处理移动*/
    MapControl.prototype.dealMove = function (dir, map, container) {
        var worldPos = map.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var nodePos = container.convertToNodeSpaceAR(worldPos);
        nodePos.x += dir.x;
        nodePos.y += dir.y;
        var edge = this.calculateEdge(map, container, nodePos);
        if (edge.left <= 0 && edge.right <= 0) {
            map.x += dir.x;
        }
        if (edge.top <= 0 && edge.bottom <= 0) {
            map.y += dir.y;
        }
    };
    MapControl.prototype.dealSelect = function (nodePos) {
        //cc.log(`click map on (${nodePos.x}, ${nodePos.y})`);
        // do sth
        if (this.singleTouchCb)
            this.singleTouchCb(nodePos);
    };
    // 计算map的四条边距离容器的距离，为负代表超出去
    MapControl.prototype.calculateEdge = function (target, container, nodePos) {
        // distance to the edge when anchor is (0.5, 0.5) 
        var horizontalDistance = (container.width - target.width * target.scaleX) / 2;
        var verticalDistance = (container.height - target.height * target.scaleY) / 2;
        // let left: number = horizontalDistance + nodePos.x;
        // let right: number = horizontalDistance - nodePos.x;
        // let top: number = verticalDistance - nodePos.y;
        // let bottom: number = verticalDistance + nodePos.y;
        var left = horizontalDistance + nodePos.x + 450;
        var right = horizontalDistance - nodePos.x + 444;
        var top = verticalDistance - nodePos.y + 178;
        var bottom = verticalDistance + nodePos.y + 261;
        // cc.log(left, right, top, bottom)
        // cc.log(nodePos.x, nodePos.y)
        return { left: left, right: right, top: top, bottom: bottom };
    };
    /**
     * @brief 设置是否严格模式，如果为严格模式，则会过滤不在目标身上的触摸点， 反之不作处理
     *              默认为非严格模式
     * @param isStrict
     */
    MapControl.prototype.setStrictPattern = function (isStrict) {
        this.isStrict = isStrict;
    };
    MapControl.prototype.getStrictPattern = function () {
        return this.isStrict;
    };
    __decorate([
        property({
            type: cc.Node,
            tooltip: '目标节点'
        })
    ], MapControl.prototype, "map", void 0);
    __decorate([
        property(cc.Label)
    ], MapControl.prototype, "scaleTime", void 0);
    __decorate([
        property({
            tooltip: '图片初始缩放'
        })
    ], MapControl.prototype, "defaultScaling", void 0);
    __decorate([
        property({
            tooltip: '图片缩放最小scale'
        })
    ], MapControl.prototype, "minScale", void 0);
    __decorate([
        property({
            tooltip: '图片缩放最大scale'
        })
    ], MapControl.prototype, "maxScale", void 0);
    __decorate([
        property({
            tooltip: '单点触摸容忍误差'
        })
    ], MapControl.prototype, "moveOffset", void 0);
    __decorate([
        property({
            tooltip: '滚轮缩放比率'
        })
    ], MapControl.prototype, "increaseRate", void 0);
    __decorate([
        property
    ], MapControl.prototype, "isStrict", void 0);
    MapControl = __decorate([
        ccclass
    ], MapControl);
    return MapControl;
}(cc.Component));
module.exports = MapControl;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcSuper.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '4c5c4SRsBdHkbvo2x85R+vo', 'NpcSuper');
// scripts/EVA_npc/NpcSuper.ts

"use strict";
/*
  Npc 们的公共继承类
  决定了普通NPC和特殊NPC的原型
*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var AStarManager_1 = require("../AStar/AStarManager");
var ResLoaderManager_1 = require("../Manager/ResLoaderManager");
var NpcAniManager_1 = require("./NpcAniManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// 定义位置 常量
var Posi;
(function (Posi) {
    Posi[Posi["TOP"] = 0] = "TOP";
    Posi[Posi["RIGHT"] = 1] = "RIGHT";
    Posi[Posi["BOTTOM"] = 2] = "BOTTOM";
    Posi[Posi["LEFT"] = 3] = "LEFT";
})(Posi || (Posi = {}));
var NpcState;
(function (NpcState) {
    NpcState[NpcState["VISIT"] = 0] = "VISIT";
    NpcState[NpcState["WALK"] = 1] = "WALK";
    NpcState[NpcState["FREE"] = 2] = "FREE";
    NpcState[NpcState["LEAVE"] = 3] = "LEAVE";
    NpcState[NpcState["INTERACTIVE"] = 4] = "INTERACTIVE";
})(NpcState = exports.NpcState || (exports.NpcState = {}));
// NPC 的心情常量
var Mood;
(function (Mood) {
    Mood[Mood["AMAZEMENT"] = 0] = "AMAZEMENT";
    Mood[Mood["ANGER"] = 1] = "ANGER";
    Mood[Mood["CHERISH"] = 2] = "CHERISH";
    Mood[Mood["CRY"] = 3] = "CRY";
    Mood[Mood["CRYING"] = 4] = "CRYING";
    Mood[Mood["FIGHTING"] = 5] = "FIGHTING";
    Mood[Mood["LIKE"] = 6] = "LIKE";
    Mood[Mood["QUERY"] = 7] = "QUERY";
    Mood[Mood["SMILE"] = 8] = "SMILE";
    Mood[Mood["SUN_SMILE"] = 9] = "SUN_SMILE";
    Mood[Mood["SWEAT"] = 10] = "SWEAT";
})(Mood = exports.Mood || (exports.Mood = {}));
var NpcSupper = /** @class */ (function (_super) {
    __extends(NpcSupper, _super);
    function NpcSupper() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /*********特殊属性 决定npc的核心*********/
        // 当前npc在配置表中的ID 方便以后的操作
        _this.npcId = null;
        // 性别
        _this.sex = null;
        // 年龄
        _this.age = null;
        // 口头禅
        _this.phraseList = null;
        // 图集资源地址 每个NPC都有一个独一无二的标识地址, 程序会根据这个标识地址去添加固定字符串然后寻找特定图片
        _this.source = null;
        // npc名称
        _this.npcName = null;
        /*********特殊属性 决定npc的核心*********/
        // 墙的图层 用于做 坐标处理
        _this.wallLayer = null;
        /** 透明坐标图层*/
        _this.moveLayer = null;
        // npc 节点
        _this.npcNode = null;
        // npc 节点上的动画组件
        _this.npcAnim = null;
        // npc节点上的文字节点
        _this.npcStateWrap = null;
        // 描述NPC 状态信息的表情节点
        _this.npcMoodNode = null;
        // 描述NPC 状态信息的表情Sprite组件
        _this.npcMood = null;
        // 资源管理的实例
        _this.sm = null;
        // 移动的下标
        _this.moveIndex = null;
        // 移动的数组
        _this.moveList = null;
        // 当前npc所在的 x，y坐标
        _this.coordinate = null;
        // 外界要求前往的目标点
        _this.targetCoordinate = null;
        // 是否在参观展品还是在行走, 需要一个状态 
        _this.state = null;
        // npc 当前移动的方向
        _this.movePosi = null;
        // 已经参观过多少个展品
        _this.visited = null;
        // 期待参观数 当已参观数量大于等于 期待参观数时，就通知外界， 这个npc想要离开
        _this.visit = null;
        // 获取A* 管理器的实例
        _this.aStarInstance = null;
        // npc 的移动速度
        _this.ispeed = null;
        // npc 的移动动画执行速度
        _this.walkIspeed = null;
        // 所有NPC的动画配置对象
        _this.npcAnimConfig = null;
        // npc的标志
        _this.sign = null;
        return _this;
        // start() { }
        // update() { }
    }
    // 初始化数据
    NpcSupper.prototype.init = function () {
        // 获取表情节点
        this.npcMoodNode = this.node.getChildByName('look');
        // 获取表情节点的 Sprite 组件
        this.npcMood = this.npcMoodNode.getChildByName('icon').getComponent(cc.Sprite);
        // 获取文字容器
        this.npcStateWrap = this.node.getChildByName('stateWrap');
        // 初始化npc节点
        this.npcNode = cc.find('img_npc', this.node);
        // 获取动画组件
        this.npcAnim = this.npcNode.getComponent(cc.Animation);
        // 初始化npc的速度 最快0.5 - 1 保留2位有限小数
        var offset = +(Math.random() * 0.3 + 0.2).toFixed(2); // 一点小偏移
        this.ispeed = 1 - offset; // 这个是移动一段距离的时间
        // npc 的移动动画执行速度
        this.walkIspeed = 1 + offset;
        // 获取墙的图层
        var map = cc.find('Canvas/Baseview/obj_map/map100').getComponent(cc.TiledMap);
        this.wallLayer = map.getLayer('wall');
        this.moveLayer = map.getLayer('move');
        // 初始化已参观数
        this.visited = 0;
        // 初始化期待参观数
        this.visit = Number.MAX_VALUE;
        // 初始化A*实例
        this.aStarInstance = AStarManager_1.default.getInstance();
        // 初始化资源管理的实例
        var sm = this.sm = ResLoaderManager_1.default.getInstance();
        // 读取配置表
        this.npcAnimConfig = sm.getConfig('animation');
    };
    // 更改当前移动方向
    NpcSupper.prototype.changeMovePosi = function (state) {
        this.movePosi = state;
    };
    // 更改当前NPC状态
    NpcSupper.prototype.changeState = function (state) {
        this.state = state;
    };
    // 转向 将原先4个函数 合并成一个函数
    NpcSupper.prototype.turnACorner = function (direction, scaleX, animName) {
        // 避免重复触发
        if (this.movePosi === direction)
            return;
        // 改变行进方向
        this.changeMovePosi(direction);
        // 镜像翻转节点
        this.npcNode.scaleX = scaleX;
        // 播放动画
        this.npcAnim.play(animName);
    };
    // 从当前点, 移动到某一点
    NpcSupper.prototype.moveTo = function (target) {
        var _this = this;
        // 当前位置信息
        var coordinate = this.coordinate;
        // 坐标点比对
        if (coordinate.x - target.x > 0) {
            // 向左
            this.turnACorner(Posi.LEFT, 1, 'npc1_rear');
        }
        else if (coordinate.x - target.x < 0) {
            // 向右
            this.turnACorner(Posi.RIGHT, -1, 'npc1_front');
        }
        else if (coordinate.y - target.y > 0) { // 因为当前程序不走斜角， 所以可以连着esle
            // 向前
            this.turnACorner(Posi.TOP, -1, 'npc1_rear');
        }
        else if (coordinate.y - target.y < 0) {
            // 向后
            this.turnACorner(Posi.BOTTOM, 1, 'npc1_front');
        }
        // 切换坐标
        this.coordinate = target;
        // 判断是否透明点
        if (this.node.opacity !== 0) {
            this.moveLayer.getTileGIDAt(target.x, target.y) != 0 ? this.node.opacity = 127.5 : this.node.opacity = 255;
        }
        // 计算坐标位置
        var v2 = this.correctCoordinate(target);
        // 前往
        cc.tween(this.node)
            .to(this.ispeed, { position: v2 })
            .call(function () {
            // 因为需要多次访问 提前存下
            var len = _this.moveList.length;
            // 移动未结束
            if (_this.moveIndex < len - 1) {
                // 可以进行下一次移动
                _this.moveTo(_this.moveList[++_this.moveIndex]);
            }
            else {
                // 移动结束 进入分支 开始执行不同的程序
                _this.shunt();
            }
            // 在这里处理 当moveIndex 移动到倒数第二个格子的时候, 同时是离开的时候淡出
            if (_this.moveIndex === len - 2 && _this.visit === _this.visited) {
                // 淡出
                _this.fadeOut();
            }
        })
            .start();
    };
    // 由管理器决定终点位置
    NpcSupper.prototype.go = function (posi) {
        // 每次管理器调用这个函数时, 不管当前终点有无抵达, 一样切换行进坐标点 同时更改数组下标
        var moveList = this.aStarInstance.findPath(this.coordinate, posi);
        // 容错判断 如果没有查找到可行路径
        if (moveList === null) {
            // 先退出当前寻路
            // 丢弃当前点，直接进入下一次
            return false;
        }
        this.moveList = moveList;
        // 下标归零
        this.moveIndex = 0;
        // 决定目标点
        this.targetCoordinate = posi;
        // 如果npc 当前还在行走中, 你就切换终点, 那么就直接return 程序会自己接上去的
        if (this.state != NpcState.WALK) {
            // 迭代器启动
            this.moveTo(this.moveList[++this.moveIndex]);
        }
        // npc 状态进入 行走
        this.changeState(NpcState.WALK);
        // 路径可行
        return true;
    };
    // 分流 当moveTo抵达终点后, 有三种情况需要处理
    NpcSupper.prototype.shunt = function () {
        // 1 抵达是展台 那么进入参观阶段
        // 2 抵达的是闲逛点 那么进入等待阶段
        // 判断终点是否是展台并且没有参观完成 -1 是因为如果函数进入这里
        if (this.targetCoordinate.direction && this.visited < this.visit) {
            // npc需要去参观当前展台
            this.lookAround();
            // 是否未抵达参观数量要求
            if (this.visited < this.visit) {
                // 这个函数中有延迟器 逗留一段时间后 通知外界 npc需要前往下一个参观点
                this.delayGoNext(this.produce); // 传入的参数是一个函数， 这个函数是用于制作产出
            }
            else if (this.visited === this.visit) {
                // 该离开这里令人怀念的地方了
                this.leval();
            }
        }
        else if (!this.targetCoordinate.direction && this.visited < this.visit) {
            // 当前npc没有参观完成展台, 并且终点不是站台位置 说明处于闲逛中
            // 等待
            this.wait();
            // 我要前往下一个参观点
            this.delayGoNext();
        }
        else if (this.visited === this.visit) { // 因为每当npc移动到一个点后都会触发这个函数
            // 销毁阶段 
            this.node.removeFromParent();
        }
    };
    // NPC 处于等待状态 这只是个动画的切换, 它会根据你当前的方位执行等待动画
    NpcSupper.prototype.wait = function () {
        // 切换NPC状态
        this.changeState(NpcState.FREE);
        // 移动结束 移动方向置为空
        this.movePosi = null;
        Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
        // 镜像翻转
        this.npcNode.scaleX = 1;
    };
    // 参观
    NpcSupper.prototype.lookAround = function () {
        // 更改npc状态进入参观
        this.changeState(NpcState.VISIT);
        // 根据当前展台朝向 定义人物位置 依据的是展台朝向
        switch (this.targetCoordinate.direction) {
            case 'top':
                Math.random() > 0.5 ? this.npcAnim.play('stand_a') : this.npcAnim.play('action_a');
                // 镜像翻转
                this.npcNode.scaleX = -1;
                break;
            case 'right':
                Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
                // 镜像翻转
                this.npcNode.scaleX = -1;
                break;
            case 'bottom':
                Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
                // 镜像翻转
                this.npcNode.scaleX = 1;
                break;
            case 'left':
                Math.random() > 0.5 ? this.npcAnim.play('stand_a') : this.npcAnim.play('action_a');
                // 镜像翻转
                this.npcNode.scaleX = 1;
                break;
        }
        // 移动结束 移动方向置为空
        this.movePosi = null;
        // 参观完成 参观数 ++
        this.visited++;
    };
    // 淡入
    NpcSupper.prototype.fadeIn = function (cb) {
        if (cb === void 0) { cb = function () { }; }
        // 新版API
        cc.tween(this.node)
            .to(.5, { opacity: 255 })
            .call(cb.bind(this))
            .start();
    };
    // 淡出
    NpcSupper.prototype.fadeOut = function (cb) {
        if (cb === void 0) { cb = function () { }; }
        // 
        cc.tween(this.node)
            .to(.5, { opacity: 0 })
            .call(cb.bind(this))
            .start();
    };
    // 离场
    NpcSupper.prototype.leval = function () {
        var _this = this;
        // 通知外界 我要离开
        this.scheduleOnce(function () {
            // 当参观展品数达到数量 那么就直接告诉外界, 我要离开
            var event = new cc.Event.EventCustom('leave', false);
            // 设置参数
            event.setUserData(_this);
            // 发送事件
            cc.systemEvent.dispatchEvent(event);
            // 最后一次金币生成
            _this.produce();
            // 更改状态
            _this.changeState(NpcState.LEAVE);
        }, 3);
    };
    // 对goNext进行一个延迟
    NpcSupper.prototype.delayGoNext = function (func) {
        var _this = this;
        // 延迟一段时间
        this.scheduleOnce(function () {
            // goNext 执行
            _this.goNext(func);
        }, Math.random() * 5 + 5);
        // 停留时间是 最低5秒 最长9.9秒 Math.random() * 5 + 5
    };
    // 前往下一个逗留点
    NpcSupper.prototype.goNext = function (func) {
        // 这个一般是等npc离开后产出金币用的
        func && func.call(this);
        // 参观一段时间通知管理， 当前npc 希望前往另一个参观点
        var event = new cc.Event.EventCustom('visitfinish', false);
        // 设置参数
        event.setUserData(this);
        // 发射
        cc.systemEvent.dispatchEvent(event);
    };
    // 计算并修正坐标
    NpcSupper.prototype.correctCoordinate = function (_a) {
        var x = _a.x, y = _a.y;
        var _b;
        (_b = this.wallLayer.getPositionAt(x, y), x = _b.x, y = _b.y);
        // 因为 坐标转换有些偏差， 需要矫正这些偏差.0
        return cc.v2(x + 32, y + 16);
    };
    // 根据管理器要求 设置出生点
    NpcSupper.prototype.setBirthPoint = function (posi) {
        // 赋值当前点坐标
        this.coordinate = posi;
        // 计算坐标 并赋值
        this.node.setPosition(this.correctCoordinate(posi));
    };
    // 外界调用 注入模板 暂时不要进行内部自己随机
    NpcSupper.prototype.soulInit = function (config) {
        var _this = this;
        // 需要初始化的信息包括 npc的外观，npc的口头禅， npc的年龄， npc的性别等类人信息
        this.phraseList = config.visitor_phrase; // 口头禅 是数组， 从中随机
        this.source = config.visitor_resources; // npc图集地址
        // 避免重复访问
        var npcAnim = this.npcAnim;
        var animId = config.animation_id;
        // 查询一次 如果一个没有，说明其他也没有
        var walkA1 = NpcAniManager_1.default.getAnimClip(animId, 'npc1_front');
        if (walkA1) { // 存在的情况
            // 更改动画速度
            var walkB1 = NpcAniManager_1.default.getAnimClip(animId, 'npc1_rear');
            walkA1.speed = this.walkIspeed;
            walkB1.speed = this.walkIspeed;
            // 添加动画帧
            npcAnim.addClip(walkA1);
            npcAnim.addClip(walkB1);
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'stand_a'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'stand_b'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'action_a'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'action_b'));
        }
        else { // 没有的情况
            // 拿到对应的动画配置表
            var animConfig = this.npcAnimConfig[animId];
            // 动作集
            var walkA = animConfig.walk_a, walkB = animConfig.walk_b, standA = animConfig.stand_b_1, standB = animConfig.stand_a_1, actionA = animConfig.stand_b_2, actionB = animConfig.stand_a_2;
            // 获取图集资源 TEST
            var atlas = this.sm.getSpriteAtlasByName(this.source.split('/')[1]);
            // 创建动画帧并添加
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(walkA, atlas), 'npc1_front', this.walkIspeed));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(walkB, atlas), 'npc1_rear', this.walkIspeed));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(standA, atlas), 'stand_a', animConfig.stand_a_1_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(standB, atlas), 'stand_b', animConfig.stand_a_1_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(actionA, atlas), 'action_a', animConfig.stand_a_2_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(actionB, atlas), 'action_b', animConfig.stand_a_2_gap));
        }
        // UI 渲染 过1秒钟左右后再获取最新的高度
        this.scheduleOnce(function () {
            _this.initEnd();
        }, 1);
    };
    // 当所有同步和异步操作都执行完成 执行这里的代码， 一般都是UI处理
    NpcSupper.prototype.initEnd = function () {
        // 处理节点高度问题 每个NPC高度都不一致 
        this.npcMoodNode.y = this.npcNode.height + 5;
        this.npcStateWrap.y = this.npcNode.height + 10;
    };
    // 产出人气
    NpcSupper.prototype.produce = function () {
    };
    NpcSupper.prototype.onLoad = function () {
        // 设置当前节点透明
        this.node.opacity = 0;
        // 初始化中
        this.init();
        // init 完成后 执行淡入
        this.fadeIn();
    };
    __decorate([
        property(cc.TiledLayer)
    ], NpcSupper.prototype, "wallLayer", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcSupper.prototype, "moveLayer", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcNode", void 0);
    __decorate([
        property(cc.Animation)
    ], NpcSupper.prototype, "npcAnim", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcStateWrap", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcMoodNode", void 0);
    __decorate([
        property(cc.Sprite)
    ], NpcSupper.prototype, "npcMood", void 0);
    NpcSupper = __decorate([
        ccclass
    ], NpcSupper);
    return NpcSupper;
}(cc.Component));
exports.default = NpcSupper;
/*
  A* 优化
  寻找离终点最近的中转点
  判断是否离npc过远， 如果过远，再以当前中转点为距离
  寻找离当前点最近的中转点

  13.2 14.25 10.9 15.9 14.7
  68.95 / 5
  13.790000000000001

  18.0 20.1 20.6 16.5 17.8
  93 / 5
  18.6

  18.5 16.4 20.4 19.6 20.0
  94.9 / 5
  18.98

  对话处理
    相同特点 -> 框会根据字体动态拉伸大小， 而且是动画形式

    如何确定框的大小

    大声说话 -> 字体变大
    长句陈述 ->
    内心想法

*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/Manager/ResLoaderManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd4213eLzwdH/Kucjk55ZNdX', 'ResLoaderManager');
// scripts/Manager/ResLoaderManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** 资源加载路径 需要加载的所有资源*/
exports.SpAtlasPath = [
    // NPC 图集
    "npc/adult01",
];
/** 预制体资源路径*/
exports.PrefabPath = [
    "prefab/eva_npc/npc"
];
exports.JsonCfgPath = [
    "jsonCfg/animation",
    "jsonCfg/visitor",
];
/** 资源管理类*/
var ResLoaderManager = /** @class */ (function () {
    function ResLoaderManager() {
        /** 图集资源列表*/
        this.spAtlasDatas = new Map();
        /** 配置资源列表*/
        this.cfgDatas = new Map();
        /** 预制体资源列表*/
        this.prfDatas = new Map();
    }
    ResLoaderManager.getInstance = function () {
        if (!this._instance) {
            this._instance = new ResLoaderManager();
        }
        return this._instance;
    };
    ResLoaderManager.prototype.initSpriteAtlas = function (cb) {
        var _this = this;
        //初始加载所有游戏资源
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, resource) {
            if (err) {
                cc.error(err);
                return;
            }
            for (var i = 0; i < resource.length; i++) {
                var strArr = resource[i].name.split(".");
                _this.spAtlasDatas.set(strArr[0], resource[i]);
            }
        };
        cc.loader.loadResArray(exports.SpAtlasPath, cc.SpriteAtlas, progressCallback, completeCallback);
    };
    /** 配置数据加载*/
    ResLoaderManager.prototype.initJsonCfg = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, jsonArr) {
            if (err) {
                cc.error(err);
                return;
            }
            // 便利结果
            jsonArr.forEach(function (item) {
                // 获取配置文件名
                var name = item.name;
                _this.cfgDatas.set(name, item.json);
            });
            // cc.log(jsonArr);
        };
        cc.loader.loadResArray(exports.JsonCfgPath, cc.JsonAsset, progressCallback, completeCallback);
    };
    /** 预制体资源加载*/
    ResLoaderManager.prototype.initPrefaRes = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, prefabs) {
            if (err) {
                cc.error(err);
                return;
            }
            //cc.log(prefabs);
            prefabs.forEach(function (item) { return _this.prfDatas.set(item.name, item); });
        };
        cc.loader.loadResArray(exports.PrefabPath, cc.Prefab, progressCallback, completeCallback);
    };
    /** 根据名字获取某张图集*/
    ResLoaderManager.prototype.getSpriteAtlasByName = function (name) {
        var data = this.spAtlasDatas.get(name);
        return data;
    };
    /** 根据名字获取某个预制体*/
    ResLoaderManager.prototype.getPrefab = function (name) {
        return this.prfDatas.get(name);
    };
    /** 根据名字获取某个配置表*/
    ResLoaderManager.prototype.getConfig = function (name) {
        return this.cfgDatas.get(name);
    };
    return ResLoaderManager;
}());
exports.default = ResLoaderManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcNormal.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'e92123oqRhN+bVA0dS+/qW/', 'NpcNormal');
// scripts/EVA_npc/NpcNormal.ts

"use strict";
/*
  普通NPC
*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NpcSuper_1 = require("./NpcSuper");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NpcNormal = /** @class */ (function (_super) {
    __extends(NpcNormal, _super);
    function NpcNormal() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NpcNormal = __decorate([
        ccclass
    ], NpcNormal);
    return NpcNormal;
}(NpcSuper_1.default));
exports.default = NpcNormal;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcRVZBX25wY1xcTnBjTm9ybWFsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTs7RUFFRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBRUYsdUNBQW1DO0FBRTdCLElBQUEsa0JBQXFDLEVBQW5DLG9CQUFPLEVBQUUsc0JBQTBCLENBQUM7QUFHNUM7SUFBdUMsNkJBQVM7SUFBaEQ7O0lBRUEsQ0FBQztJQUZvQixTQUFTO1FBRDdCLE9BQU87T0FDYSxTQUFTLENBRTdCO0lBQUQsZ0JBQUM7Q0FGRCxBQUVDLENBRnNDLGtCQUFTLEdBRS9DO2tCQUZvQixTQUFTIiwiZmlsZSI6IiIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiLyogXHJcbiAg5pmu6YCaTlBDXHJcbiovXHJcblxyXG5pbXBvcnQgTnBjU3VwcGVyIGZyb20gXCIuL05wY1N1cGVyXCI7XHJcblxyXG5jb25zdCB7IGNjY2xhc3MsIHByb3BlcnR5IH0gPSBjYy5fZGVjb3JhdG9yO1xyXG5cclxuQGNjY2xhc3NcclxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTnBjTm9ybWFsIGV4dGVuZHMgTnBjU3VwcGVyIHtcclxuXHJcbn0iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/AStar/BinaryHeap.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '56b64wLrbxBJIjcI34tiaBr', 'BinaryHeap');
// scripts/AStar/BinaryHeap.ts

"use strict";
/**
 * A Star 寻路优化
 * 二叉堆优化
 *
 * 二叉堆是一种完全二叉树，有两种类型：最大堆（大根堆）、最小堆（小根堆）
 * 因为A 星查找F值最小，所以这里使用最小堆，父节点比子节点小或相等 保证最小位在上方
 * 实际存储是以数组形式，但是逻辑层面是树型
 *
 * 取出和删除都会改变原有的二叉堆
 *
 * 取出最小值
 * 删除某一位
 * 查找某一位
*/
Object.defineProperty(exports, "__esModule", { value: true });
var BinaryHeap = /** @class */ (function () {
    function BinaryHeap() {
        // 初始化二叉堆
        this._tree = [];
    }
    /**
     * 逻辑： 父节点下标为parentI 子节点下标为i
     *  直接将当前点插入到最后一位，
     *  与其父节点比较，如果小于其父节点就交换位置
     *  然后重复
     *
    */
    BinaryHeap.prototype.insert = function (node) {
        var i, parentI;
        // 插入尾部
        this._tree.push(node);
        // 获取下标
        i = this._tree.length - 1;
        // 重复执行 是否比其父节点小
        while (true) {
            // 那么如何求出父节点下标 (i - 1) / 2 有小数点直接舍去小数点位
            // parentI = Math.floor((i - 1) / 2) // 细节优化 
            parentI = (i - 1) >> 1;
            // 比较大小
            if (this._tree[parentI] && node.f < this._tree[parentI].f) { // 条件成立 位置交换
                var temp = this._tree[parentI];
                this._tree[parentI] = node;
                this._tree[i] = temp;
                // 下标置换
                i = parentI;
                // 下一轮
            }
            else { // 等于或者大于都不成立
                return;
            }
        }
    };
    /**
     * 逻辑类似，
     *  但是是加入节点的反向过程，反向下沉
     *  删除根节点
     *  将尾部节点补到根节点处
     *  判断其是否符合最小堆规则，不符合就下沉 一个一个往上置换
     *  左孩子下标就是 2 * parent + 1  右孩子下标是2 * parent + 2
    */
    BinaryHeap.prototype.shift = function () {
        // 提前声明
        var parentI, node, lastNode, tree;
        // 获取引用
        tree = this._tree;
        // 要被返回的F值最小的那个节点
        node = tree.shift();
        // 将最后一位补到根节点处
        lastNode = tree.pop();
        // 将尾部节点补到根节点处
        tree.unshift(lastNode);
        // 父节点下标初始化
        parentI = 0;
        // 循环判断其是否小于其两个子节点中最小的那位
        while (true) {
            var leftI = void 0, rightI = void 0;
            // 求出左右孩子的下标
            // leftI = 2 * parentI + 1
            leftI = (parentI << 1) + 1;
            rightI = leftI + 1;
            // 首先有无这两个位置的节点
            if (leftI >= this._tree.length && rightI >= this._tree.length) {
                return node;
            }
            // 对比两个子节点谁更小
            if (tree[rightI] == undefined || tree[leftI].f <= tree[rightI].f) { // 相等或者左子节点小 获取rightI 等于undefined 为什么不判断leftI呢，因为前面已经判断过了
                if (tree[parentI].f > tree[leftI].f) { // 置换条件，当前父节点大于最小的一位子节点
                    // 通过中间变量执行上浮操作
                    var temp = tree[parentI];
                    tree[parentI] = tree[leftI];
                    tree[leftI] = temp;
                    // 坐标转换
                    parentI = leftI;
                    // 下一轮
                    continue;
                }
                else {
                    return node;
                }
            }
            else { // 右子节点小
                if (tree[parentI].f > tree[rightI].f) { // 置换条件，当前父节点大于最小的一位子节点
                    // 通过中间变量执行上浮操作
                    var temp = tree[parentI];
                    tree[parentI] = tree[rightI];
                    tree[rightI] = temp;
                    // 坐标转换
                    parentI = rightI;
                    // 下一轮
                    continue;
                }
                else {
                    return node;
                }
            }
        }
        // 返回 保持和原数组方法一致
        return node;
    };
    // 清空二叉堆
    BinaryHeap.prototype.clear = function () {
        // 直接丢弃原有数组，等待GC
        this._tree = [];
    };
    // 返回二叉堆长度
    BinaryHeap.prototype.getLength = function () {
        return this._tree.length;
    };
    return BinaryHeap;
}());
exports.default = BinaryHeap;
/**
 *          9
 *    30          32
 *  40  56      -10
 *
 *  0. [9, 30, 32, 40, 56]
 *  1. [56, 30, 32, 40]
 *  p = 0
 *  求出左右子节点索引
 *  l = 0 * 2 + 1    // 1
 *  r = l + 1        // 2
 *
 *  比对 30 <= 32  // true
 *     56 > 30 // true
 *      [30, 56, 32, 40] // p = 1
 *
 *  求出左右子节点索引
 *  l = 1 * 2 + 1    // 3
 *  r = l + 1        // 4
 *
 *  比对 40 <= undefined || r == undefined // true
 *    56 > 40 // true
 *      [30, 40, 32, 56] // p = 3
 *
 *  求出左右子节点索引
 *  l = 1 * 2 + 1    // 7
 *  r = l + 1        // 8
 *
 *  长度超出，直接返回
 *
 *
*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/AStar/AStarNode.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'bb1aaD4i9pAHpr2XJxNSq6M', 'AStarNode');
// scripts/AStar/AStarNode.ts

"use strict";
/**
 * Node 定义数据结构
 * 寻路时的节点应该存在哪些信息
 *
*/
Object.defineProperty(exports, "__esModule", { value: true });

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcQVN0YXJcXEFTdGFyTm9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7O0FBQUE7Ozs7RUFJRSIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBOb2RlIOWumuS5ieaVsOaNrue7k+aehFxyXG4gKiDlr7vot6/ml7bnmoToioLngrnlupTor6XlrZjlnKjlk6rkupvkv6Hmga9cclxuICogXHJcbiovXHJcblxyXG4vLyDoioLngrnlupTor6XnrKblkIjov5nmoLfnmoTnu5PmnoRcclxuZXhwb3J0IGRlZmF1bHQgaW50ZXJmYWNlIEFTdGFyTm9kZSB7XHJcbiAgLy8geCDlnZDmoIdcclxuICB4OiBudW1iZXJcclxuICAvLyB55Z2Q5qCHXHJcbiAgeTogbnVtYmVyXHJcblxyXG4gIC8vIOemu+e7iOeCueeahOS7o+S7t1xyXG4gIGY6IG51bWJlclxyXG4gIC8vIOemu+i1t+eCueeahOi3neemu1xyXG4gIGc6IG51bWJlclxyXG4gIC8vIOemu+e7iOeCueeahOmihOS8sOi3neemu1xyXG4gIGg6IG51bWJlclxyXG5cclxuICAvLyDorrDlvZXkuIrkuIDngrnnmoTkv6Hmga/vvIwg57G75Ly85LqO6ZO+6KGo57uT5p6EXHJcbiAgcGFyZW50OiBBU3Rhck5vZGVcclxufVxyXG4iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcAniManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd43bcqYllVCJY4lu31yHQoj', 'NpcAniManager');
// scripts/EVA_npc/NpcAniManager.ts

"use strict";
/**
 * 优化NPC生成动画clip的代码 避免多个相同角色多次重复执行相同代码，
 *  主题：
 *    一个npc实例化后， 会进行模板生成，这个过程中，需要根据动画ID去查找相应帧
 *    最后将6个基本动作全部创建成clip
 *
 *    这意味着 如果NPC的外观是一致的，那么重复的代码就会执行，带来没必要的消耗
*/
Object.defineProperty(exports, "__esModule", { value: true });
// 调用方式： NpcAniManager.getWalkA(id: number) // 如果没找到返回undefined
var NpcAniManager = /** @class */ (function () {
    function NpcAniManager() {
    }
    // 获取动画帧
    NpcAniManager.getAnimClip = function (id, clipName) {
        // 避免多次访问
        var temp = this._anims[id];
        // 查找是否有此动画帧对象
        if (!temp)
            return;
        // 返回结果 可能是undefined 或者 clip
        return temp[clipName];
    };
    // 获取某个ID的所有动画帧
    NpcAniManager.getAnimAllClip = function (id) {
        return this._anims[id];
    };
    // 保存动画帧
    NpcAniManager._setAnimClip = function (id, clipName, clip) {
        var temp = this._anims[id];
        // 赋值空对象 以id为名
        if (!temp)
            temp = this._anims[id] = {};
        // clipName 为key clip 为值
        return temp[clipName] = clip;
    };
    // 动态添加clip
    NpcAniManager.createClip = function (id, frames, name, ispeed, wrapMode) {
        if (ispeed === void 0) { ispeed = 1; }
        if (wrapMode === void 0) { wrapMode = cc.WrapMode.Loop; }
        // 创建一个clip
        var clip = cc.AnimationClip.createWithSpriteFrames(frames, frames.length);
        // 命名
        clip.name = name;
        // 播放速度
        clip.speed = ispeed;
        // 播放速率
        clip.sample = 60;
        // 循环模式
        clip.wrapMode = wrapMode;
        // 保存动画帧
        this._setAnimClip(id, name, clip);
        return clip;
    };
    // 创建动画
    NpcAniManager.createFrames = function (arr, atlas) {
        var frames = [];
        // 动态创建clip 
        arr.forEach(function (item, i) {
            var sprite = atlas.getSpriteFrame(item);
            // 异常处理
            if (!sprite) {
                console.warn('获取帧错误, 这将导致动画播放异常 ' + item);
            }
            frames[i] = sprite;
        });
        // 
        return frames;
    };
    // 动画帧存储对象
    NpcAniManager._anims = {};
    return NpcAniManager;
}());
exports.default = NpcAniManager;
/**
let animAllClip = NpcAniManager.getAnimAllClip(animId)

    if (animAllClip) { // 存在的情况
      let {npc1_front, npc1_rear, stand_a, stand_b, action_a, action_b} = animAllClip
      // 更改动画速度
      npc1_front.speed = this.walkIspeed
      npc1_rear.speed = this.walkIspeed
      
      // 添加动画帧
      npcAnim.addClip(npc1_front)
      npcAnim.addClip(npc1_rear)
      npcAnim.addClip(stand_a)
      npcAnim.addClip(stand_b)
      npcAnim.addClip(action_a)
      npcAnim.addClip(action_b)

    }
*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '00f0aUY9PZGkLgT0vj6/LAR', 'NpcManager');
// scripts/EVA_npc/NpcManager.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NpcNormal_1 = require("./NpcNormal");
var ResLoaderManager_1 = require("../Manager/ResLoaderManager");
/*
  Npc 的管理调度类
  单例实现
*/
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// 当程序去随机生成位置时，会遇到一些没有标清楚的点，对这些点进行寻路通常结果会失败，会带来极大的性能开销 通过手动遍历记录点信息让程序可以跳过这些点 坐标点都是独一无二的 (x,y) 作为对象名
var NpcManager = /** @class */ (function (_super) {
    __extends(NpcManager, _super);
    function NpcManager() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // Npc的通用预制体
        _this.npcPrefab = null;
        // NPC 添加进入这一层
        _this.wallLayer = null;
        // 对象层 记录了 逗留点 离开点 初始化点的信息 
        _this.pointLayer = null;
        /** 透明层 记录人物需要透明的位置*/
        _this.moveLayer = null;
        // 空闲展台列表
        _this.freeExhibitions = [];
        // 所有展台列表 {124: {x: y,}}
        _this.allExhibitions = {};
        // 参观完成的 NPC 列表, 但是没有空闲展台供其参观, 所以先加入列表 等候下一次调度
        _this.visitFinish = [];
        // NPC 入场点
        _this.inPointList = [];
        // NPC 离场点
        _this.outPointList = [];
        // NPC 闲逛点 随机生成，不能重复
        _this.strollList = [];
        // 所有普通NPC的配置对象
        _this.npcConfig = null;
        // 所有特殊NPC的配置对象
        _this.npcSC = null;
        // 通用口头禅列表
        _this.phraseList = null;
        /***************** 配置NPC的属性 *****************/
        // 从游戏开始到目前为止的NPC数量 只增加不减少
        _this.allNpcNum = null;
        // 当前处于场馆中的npc数量 不包括bus上的旅游团
        _this.npcNum = null;
        // 场上的特殊Npc数量
        _this.specialNpcNum = 0;
        // 游戏一开始 游客上限默认为5
        _this.upperLimit = null;
        // 特殊NPC ID列表
        _this.specialNpcIdList = null;
        return _this;
    }
    NpcManager_1 = NpcManager;
    /***************** 配置NPC的属性 *****************/
    // 获取实例
    NpcManager.getInstance = function () {
        if (this.instance === null) {
            this.instance = new NpcManager_1();
        }
        return this.instance;
    };
    // 初始化
    NpcManager.prototype.init = function () {
        // TEST
        // this.freeExhibitions.push({
        //   x: 33,
        //   y: 44,
        //   direction: 'bottom'
        // })
        // 初始化数据
        this.initData();
        // 初始化停留点信息
        this.initPoints();
        // 事件绑定
        this.bindEvent();
    };
    // 初始化数据
    NpcManager.prototype.initData = function () {
        // 获取地图
        var map = cc.find('Canvas/Baseview/obj_map/map100').getComponent(cc.TiledMap);
        // 获取墙的图层
        this.wallLayer = map.getLayer('wall');
        // 获取对象层
        this.pointLayer = map.getObjectGroup("point");
        this.moveLayer = map.getLayer("move");
        // 获取资源管理器的实例 因为只初始化一次, 所以就没必要保存成属性
        var sm = ResLoaderManager_1.default.getInstance();
        // 获取npc预制体
        this.npcPrefab = sm.getPrefab('npc');
        // 读取配置表
        this.npcConfig = sm.getConfig('visitor');
        // 获取通用口头禅
        this.phraseList = [];
        // NPC 配置数据初始化
        this.allNpcNum = this.npcNum = 0;
        this.upperLimit = 40;
    };
    /** 初始化 所有的开始 停留 结束 点*/
    NpcManager.prototype.initPoints = function () {
        var list = this.pointLayer.getObjects();
        for (var i = 0; i < list.length; i++) {
            // 临时变量， 只做接收list[i] 的值
            var temp = list[i];
            if (temp.pointType == 0) {
                this.inPointList.push({
                    x: temp.posx,
                    y: temp.posy
                });
            }
            else if (temp.pointType == 1) {
                var dirStr = '';
                switch (temp.direction) {
                    case 1:
                        dirStr = 'left';
                        break;
                    case 2:
                        dirStr = 'top';
                        break;
                    case 3:
                        dirStr = 'right';
                        break;
                    case 4:
                        dirStr = 'bottom';
                        break;
                }
                var data = {
                    x: temp.posx,
                    y: temp.posy,
                    direction: dirStr
                };
                // 保存所有展品的ID 和对应的信息
                this.allExhibitions[temp['id']] = data;
                // TEST
                this.freeExhibitions.push(data);
            }
            else if (temp.pointType == 2) {
                // this.outPointList.push({
                //   x: temp.posx,
                //   y: temp.posy
                // })
            }
        }
    };
    // NPC开始实例化, 不再交由Game类
    NpcManager.prototype.npcStart = function () {
        var _this = this;
        // 定时器开启, 每隔一段时间触发 实例化NPC进馆
        this.schedule(function () {
            //只有当前npc数量没有超出限制时 才会实例化 
            if (_this.npcNum < _this.upperLimit) {
                _this.instantiateNpc();
            }
        }, 5);
    };
    /** 添加游客上限*/
    NpcManager.prototype.addVisitorMax = function (num) {
        this.upperLimit += num;
    };
    // 事件绑定
    NpcManager.prototype.bindEvent = function () {
        // 参观完成
        cc.systemEvent.on('visitfinish', this.release.bind(this));
        // npc 期望离开
        // cc.systemEvent.on('leave', this.leave.bind(this))
    };
    // 实例化NPC
    NpcManager.prototype.instantiateNpc = function () {
        var _this = this;
        // 生成实例
        var node = cc.instantiate(this.npcPrefab);
        // 每实例化一个NPC总数+1
        this.npcNum++;
        this.allNpcNum++;
        // 挂载节点 onload 触发
        this.moveLayer.addUserNode(node);
        // 挂载脚本 再获取其身上的脚本组件 传入出生点坐标信息
        var npc = node.addComponent(NpcNormal_1.default);
        var config = this.npcConfig[~~(Math.random() * this.npcConfig.length)];
        // 增加一些基本口头禅用于进入
        config.visitor_phrase = config.visitor_phrase.concat(this.phraseList);
        // 初始化NPC的核心 一个NPC默认只是个模板，这也是npc初始化的必要步骤之一
        npc.soulInit(config);
        // 初始化出生点 ~~(Math.random() * this.inPointList.length)
        // npc.setBirthPoint(this.inPointList[~~(Math.random() * this.inPointList.length)])
        npc.setBirthPoint(this.inPointList[0]);
        // npc.setBirthPoint(this.findStrollPoint(this.wallLayer))
        // 这段函数太过耗时, 先让出执行权
        setTimeout(function () {
            // 资源调度
            _this.dispatch(npc);
        }, 100);
    };
    // 调度NPC 前往闲置的展台
    NpcManager.prototype.dispatch = function (npc) {
        var random = ~~(this.freeExhibitions.length * Math.random());
        // 从空闲展台中，拿取第一位，
        var visit = this.freeExhibitions.splice(random, 1)[0];
        // 如果有值的话说明有空位
        if (visit) {
            // 通知其行进至哪个地点
            var isFeasible = npc.go(visit);
            // 看下当前传入的坐标点是否可行 如果找不到路径， 那么返回false 否则返回true
            if (!isFeasible) {
                console.log('寻路失败');
                // 再次进行调度
                this.dispatch(npc);
                // 同时 当前点将会被清除
            }
        }
        else {
            // 先找一遍看下它在不在里面， 如果已经在里面就不添加进入
            var isInVisitFinish = this.visitFinish.find(function (item) { return item === npc; });
            if (isInVisitFinish == undefined) {
                // 将当前NPC先加入闲逛列表
                this.visitFinish.push(npc);
            }
            // 没有空位 NPC进入闲逛
            // 查找闲逛点 传入npc所在的墙的图层， 二是npc当前的位置
            var posi = this.findStrollPoint(npc.coordinate);
            // go go go
            var isFeasible = npc.go(posi);
            // 看下当前传入的坐标点是否可行 如果找不到路径， 那么返回false 否则返回true
            if (!isFeasible) {
                // 他都没有添加进去 清除个锤子
                if (isInVisitFinish == undefined) {
                    // 当然 得先清除下当前NPC在闲逛列表中的标记
                    this.visitFinish.pop();
                }
                // 再次进行调度
                this.dispatch(npc);
            }
        }
    };
    // 当npc参观完成后， 需要释放其身上的展台信息， 同时将该NPC加入空闲NPC列表中
    NpcManager.prototype.release = function (data) {
        // 接收到了节点
        var npc = data.getUserData();
        // 释放当前展台
        if (npc.targetCoordinate.direction != undefined) {
            // 只有当它记录了展台信息才释放回去
            this.freeExhibitions.push(npc.targetCoordinate);
        }
        // 判断当前是否有处于闲逛中的npc
        if (this.visitFinish.length > 0) {
            // 调度当前npc
            var freeNpc = this.visitFinish.shift();
            // 进入寻路
            this.dispatch(freeNpc);
        }
        // 调度
        this.dispatch(npc);
    };
    // 寻找空闲可用点 当展品坐标数量不足的情况下，npc可以去展馆内闲逛
    NpcManager.prototype.findStrollPoint = function (coordinate) {
        var len = this.strollList.length;
        if (len <= 0) {
            cc.warn('闲逛点数量为0, 已经安排npc前往应急点');
            return { x: 41, y: 105 };
        }
        else {
            var _a = this.strollList[~~(Math.random() * len)], x = _a.x, y = _a.y;
            if (coordinate.x !== x && coordinate.y !== y) { // 避免相同点
                return { x: x, y: y };
            }
            else {
                // 递归调用
                return this.findStrollPoint(coordinate);
            }
        }
    };
    var NpcManager_1;
    // 实例
    NpcManager.instance = null;
    __decorate([
        property(cc.Prefab)
    ], NpcManager.prototype, "npcPrefab", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcManager.prototype, "wallLayer", void 0);
    __decorate([
        property(cc.TiledObjectGroup)
    ], NpcManager.prototype, "pointLayer", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcManager.prototype, "moveLayer", void 0);
    NpcManager = NpcManager_1 = __decorate([
        ccclass
    ], NpcManager);
    return NpcManager;
}(cc.Component));
exports.default = NpcManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------
