
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/AStar/AStarManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7fbcfPuElhNDr5d2sH+uzyy', 'AStarManager');
// scripts/AStar/AStarManager.ts

"use strict";
// /**
//  * A 星算法 管理器， 提供路径查找等功能， 地图为内置， 属于定制化 Manager
//  * 
// */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var BinaryHeap_1 = require("./BinaryHeap");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var AStarManager = /** @class */ (function () {
    // 私有化构造函数
    function AStarManager() {
        // 开放列表
        this.openList = new BinaryHeap_1.default();
        // 关闭列表
        this.closeList = null;
        // 哈希表 提升查找性能
        this.nodeSet = new Map();
        // 地图信息 是公共的 二维数组
        this.mapArr = [];
        // 遮挡物图层对象
        this.wallLayer = null;
        // 初始化信息
        this.initData();
        // 对于当前场景而言， 地图只需要初始化一次
        this.initMap();
    }
    AStarManager_1 = AStarManager;
    // 访问实例的唯一方式
    AStarManager.getInstance = function () {
        if (this.instance === null) {
            this.instance = new AStarManager_1();
        }
        return this.instance;
    };
    // 初始化需要动态加载的信息
    AStarManager.prototype.initData = function () {
        // 获取节点
        var node = cc.find('Canvas/Baseview/obj_map/map100');
        // 获取节点下的遮挡物组件
        this.wallLayer = node.getComponent(cc.TiledMap).getLayer('wall');
    };
    // 初始化地图 64 * 64 目前为手动设置
    AStarManager.prototype.initMap = function () {
        // 初始化地图
        for (var i = 0; i < 145; i++) { //93
            this.mapArr[i] = [];
            for (var j = 0; j < 29; j++) { // 145/5    135 / 5   27
                // 减少计算
                var temp = j * 5;
                // 初始化每一个点的坐标
                this.mapArr[i][temp] = {
                    x: i,
                    y: temp
                };
                this.mapArr[i][temp + 1] = {
                    x: i,
                    y: temp + 1
                };
                this.mapArr[i][temp + 2] = {
                    x: i,
                    y: temp + 2
                };
                this.mapArr[i][temp + 3] = {
                    x: i,
                    y: temp + 3
                };
                this.mapArr[i][temp + 4] = {
                    x: i,
                    y: temp + 4
                };
            }
        }
    };
    // 路径查找， 传入坐标点 
    AStarManager.prototype.findPath = function (beginPoint, endPoint) {
        var _a = this, closeList = _a.closeList, openList = _a.openList, mapArr = _a.mapArr, nodeSet = _a.nodeSet, findNearNodeToOpenList = this.findNearNodeToOpenList.bind(this);
        // 先清除一遍
        this.openList.clear();
        // hast表清空
        nodeSet.clear();
        // 绑定this
        // 重置开放列表和关闭列表
        closeList = this.closeList = [];
        openList = this.openList;
        // 传入的起点坐标和终点坐标一致，应该如何处理
        if (beginPoint.x === endPoint.x && beginPoint.y === endPoint.y) {
            console.log('起点和终点位置相同');
            return null;
        }
        // 判断传入的数值是否是非法
        if (beginPoint.x >= mapArr.length ||
            endPoint.x >= mapArr.length ||
            beginPoint.y >= mapArr[0].length ||
            endPoint.y >= mapArr[0].length) {
            console.log('传入坐标非法');
            return null;
        }
        // 初始化起点节点
        var startNode = {
            x: beginPoint.x,
            y: beginPoint.y,
            g: 0, h: 0, f: 0,
            parent: null
        };
        // 将当前起点坐标传入关闭列表中
        closeList.push(startNode);
        // 初始化hash
        nodeSet.set(startNode.x + ',' + startNode.y, 1);
        // 开始寻路 当前场景不进行斜边寻路 如果在地图周围都围上一层空白的墙，可以减少掉很多程序判断的过程
        while (true) {
            var startNodeX = startNode.x, startNodeY = startNode.y;
            // {x-1,y} 
            findNearNodeToOpenList(startNodeX - 1, startNodeY, endPoint, startNode);
            // {x,y-1}
            findNearNodeToOpenList(startNodeX, startNodeY - 1, endPoint, startNode);
            // {x,y+1}
            findNearNodeToOpenList(startNodeX, startNodeY + 1, endPoint, startNode);
            // {x+1,y}
            findNearNodeToOpenList(startNodeX + 1, startNodeY, endPoint, startNode);
            // 记录下一次的起点
            startNode = openList.shift();
            // 取出f值最小的那位， 放入closeList中
            closeList.push(startNode);
            if (!startNode) {
                return null;
            }
            // 判断起点是否和终点相同 或者循环次数达到性能峰值
            if (openList.getLength() <= 0) {
                console.warn('未找到可行路径');
                // 路径被穷尽
                return null;
            }
            else if (startNode.x === endPoint.x && startNode.y === endPoint.y) { // 是否没有寻找到路径
                // 查找到路径 存放的数组
                var pathList = [];
                // 取出最后一位节点
                var lastNode = closeList[closeList.length - 1];
                pathList.push(lastNode);
                // 开始回溯
                while (lastNode.parent !== null) {
                    // 插入节点
                    pathList.unshift(lastNode.parent);
                    // 循环引用
                    lastNode = lastNode.parent;
                }
                // 弹出路径列表
                return pathList;
            }
        }
    };
    // 寻找周围的坐标， 并且将其加入openList中
    AStarManager.prototype.findNearNodeToOpenList = function (x, y, endNode, parentNode) {
        var _a = this, mapArr = _a.mapArr, wallLayer = _a.wallLayer, openList = _a.openList, nodeSet = _a.nodeSet, g = 1, key, h, pathNode;
        // 判断传入的数值是否是非法 坐标超出边界
        if (x >= mapArr.length ||
            x < 0 ||
            y >= mapArr[0].length ||
            y < 0)
            return null;
        // 再次判断当前点是否是可通行路径，  
        if (wallLayer.getTileGIDAt(x, y) !== 0)
            return;
        //根据房间是否解锁来解锁寻路
        // if (wallLayer.getTileGIDAt(x, y) == 0) return
        // if (wallLayer.getTileGIDAt(x, y) == 17) return;
        // if (wallLayer.getTileGIDAt(x, y) == 18) return;
        // if (wallLayer.getTileGIDAt(x, y) == 19) return;
        // if (wallLayer.getTileGIDAt(x, y) == 20) return;
        // 保存下key，后面还要使用
        key = x + ',' + y;
        // 判断当前点是否存在于 开放列表或者关闭列表中 如果存在则直接返回
        if (nodeSet.has(key))
            return;
        // 通路， 计算 g， f， h
        // 计算离起点距离， 起点距离就是 当前点的g值， 加上父节点的g值
        g = g + parentNode.g;
        // 离终点距离 曼哈顿式
        h = Math.abs(x - endNode.x) + Math.abs(y - endNode.y);
        // h = (x - endNode.x) * (((x - endNode.x) >> 31 << 1) + 1) + (x - endNode.x) * (((x - endNode.x) >> 31 << 1) + 1)
        // 路径节点
        pathNode = {
            x: x, y: y, g: g, h: h,
            f: g + h,
            // 回溯所需父节点
            parent: parentNode
        };
        // 加入开放列表中
        openList.insert(pathNode);
        // 存入hash
        nodeSet.set(key, 1);
        return true;
    };
    var AStarManager_1;
    // 单例
    AStarManager.instance = null;
    AStarManager = AStarManager_1 = __decorate([
        ccclass
    ], AStarManager);
    return AStarManager;
}());
exports.default = AStarManager;
/**
 * hash 表查找优化
 *  A 星查找路径中，当其获取到一个点，他要去开放列表和关闭列表中查看是否有这个值，比对的就是x，y值
 *  如果有就退出程序，如果没有则加入开放列表
 *  存储的key 以这种形式 x + ',' + y -> 3,23 保证不重复 字符串形式
 *
 *  经数据证实， 大数据下Map的查找比Set快
 *
 *  大体优化已完成
 *    细节优化：
 *      1. 减少while 中的function，set，get
 *          function 的执行会进入调用栈，减少function可以减少调用栈
 *
 *  初始化优化：
 *    一开始生成地图数组信息，需要双层循环，这两层循环数量太大，93 * 135 = 12555 初始化需要上万次循环
 *
 *    减少循环次数，在同一个循环中处理更多的事情 在第二层for循环中，减少循环次数，增加每次循环做的事情， 那么初始化循环只需要执行 2000多次
 *
 *
*/

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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