
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/AStar/BinaryHeap.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '56b64wLrbxBJIjcI34tiaBr', 'BinaryHeap');
// scripts/AStar/BinaryHeap.ts

"use strict";
/**
 * A Star 寻路优化
 * 二叉堆优化
 *
 * 二叉堆是一种完全二叉树，有两种类型：最大堆（大根堆）、最小堆（小根堆）
 * 因为A 星查找F值最小，所以这里使用最小堆，父节点比子节点小或相等 保证最小位在上方
 * 实际存储是以数组形式，但是逻辑层面是树型
 *
 * 取出和删除都会改变原有的二叉堆
 *
 * 取出最小值
 * 删除某一位
 * 查找某一位
*/
Object.defineProperty(exports, "__esModule", { value: true });
var BinaryHeap = /** @class */ (function () {
    function BinaryHeap() {
        // 初始化二叉堆
        this._tree = [];
    }
    /**
     * 逻辑： 父节点下标为parentI 子节点下标为i
     *  直接将当前点插入到最后一位，
     *  与其父节点比较，如果小于其父节点就交换位置
     *  然后重复
     *
    */
    BinaryHeap.prototype.insert = function (node) {
        var i, parentI;
        // 插入尾部
        this._tree.push(node);
        // 获取下标
        i = this._tree.length - 1;
        // 重复执行 是否比其父节点小
        while (true) {
            // 那么如何求出父节点下标 (i - 1) / 2 有小数点直接舍去小数点位
            // parentI = Math.floor((i - 1) / 2) // 细节优化 
            parentI = (i - 1) >> 1;
            // 比较大小
            if (this._tree[parentI] && node.f < this._tree[parentI].f) { // 条件成立 位置交换
                var temp = this._tree[parentI];
                this._tree[parentI] = node;
                this._tree[i] = temp;
                // 下标置换
                i = parentI;
                // 下一轮
            }
            else { // 等于或者大于都不成立
                return;
            }
        }
    };
    /**
     * 逻辑类似，
     *  但是是加入节点的反向过程，反向下沉
     *  删除根节点
     *  将尾部节点补到根节点处
     *  判断其是否符合最小堆规则，不符合就下沉 一个一个往上置换
     *  左孩子下标就是 2 * parent + 1  右孩子下标是2 * parent + 2
    */
    BinaryHeap.prototype.shift = function () {
        // 提前声明
        var parentI, node, lastNode, tree;
        // 获取引用
        tree = this._tree;
        // 要被返回的F值最小的那个节点
        node = tree.shift();
        // 将最后一位补到根节点处
        lastNode = tree.pop();
        // 将尾部节点补到根节点处
        tree.unshift(lastNode);
        // 父节点下标初始化
        parentI = 0;
        // 循环判断其是否小于其两个子节点中最小的那位
        while (true) {
            var leftI = void 0, rightI = void 0;
            // 求出左右孩子的下标
            // leftI = 2 * parentI + 1
            leftI = (parentI << 1) + 1;
            rightI = leftI + 1;
            // 首先有无这两个位置的节点
            if (leftI >= this._tree.length && rightI >= this._tree.length) {
                return node;
            }
            // 对比两个子节点谁更小
            if (tree[rightI] == undefined || tree[leftI].f <= tree[rightI].f) { // 相等或者左子节点小 获取rightI 等于undefined 为什么不判断leftI呢，因为前面已经判断过了
                if (tree[parentI].f > tree[leftI].f) { // 置换条件，当前父节点大于最小的一位子节点
                    // 通过中间变量执行上浮操作
                    var temp = tree[parentI];
                    tree[parentI] = tree[leftI];
                    tree[leftI] = temp;
                    // 坐标转换
                    parentI = leftI;
                    // 下一轮
                    continue;
                }
                else {
                    return node;
                }
            }
            else { // 右子节点小
                if (tree[parentI].f > tree[rightI].f) { // 置换条件，当前父节点大于最小的一位子节点
                    // 通过中间变量执行上浮操作
                    var temp = tree[parentI];
                    tree[parentI] = tree[rightI];
                    tree[rightI] = temp;
                    // 坐标转换
                    parentI = rightI;
                    // 下一轮
                    continue;
                }
                else {
                    return node;
                }
            }
        }
        // 返回 保持和原数组方法一致
        return node;
    };
    // 清空二叉堆
    BinaryHeap.prototype.clear = function () {
        // 直接丢弃原有数组，等待GC
        this._tree = [];
    };
    // 返回二叉堆长度
    BinaryHeap.prototype.getLength = function () {
        return this._tree.length;
    };
    return BinaryHeap;
}());
exports.default = BinaryHeap;
/**
 *          9
 *    30          32
 *  40  56      -10
 *
 *  0. [9, 30, 32, 40, 56]
 *  1. [56, 30, 32, 40]
 *  p = 0
 *  求出左右子节点索引
 *  l = 0 * 2 + 1    // 1
 *  r = l + 1        // 2
 *
 *  比对 30 <= 32  // true
 *     56 > 30 // true
 *      [30, 56, 32, 40] // p = 1
 *
 *  求出左右子节点索引
 *  l = 1 * 2 + 1    // 3
 *  r = l + 1        // 4
 *
 *  比对 40 <= undefined || r == undefined // true
 *    56 > 40 // true
 *      [30, 40, 32, 56] // p = 3
 *
 *  求出左右子节点索引
 *  l = 1 * 2 + 1    // 7
 *  r = l + 1        // 8
 *
 *  长度超出，直接返回
 *
 *
*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcQVN0YXJcXEJpbmFyeUhlYXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7O0VBYUU7O0FBSUY7SUFLRTtRQUNFLFNBQVM7UUFDVCxJQUFJLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQTtJQUNqQixDQUFDO0lBRUQ7Ozs7OztNQU1FO0lBQ0YsMkJBQU0sR0FBTixVQUFPLElBQWU7UUFDcEIsSUFBSSxDQUFDLEVBQUUsT0FBTyxDQUFDO1FBQ2YsT0FBTztRQUNQLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO1FBQ3JCLE9BQU87UUFDUCxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFBO1FBRXpCLGdCQUFnQjtRQUNoQixPQUFPLElBQUksRUFBRTtZQUNYLHVDQUF1QztZQUN2Qyw2Q0FBNkM7WUFDN0MsT0FBTyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQTtZQUN0QixPQUFPO1lBQ1AsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxZQUFZO2dCQUN2RSxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFBO2dCQUM5QixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQTtnQkFDMUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUE7Z0JBQ3BCLE9BQU87Z0JBQ1AsQ0FBQyxHQUFHLE9BQU8sQ0FBQTtnQkFFWCxNQUFNO2FBQ1A7aUJBQU0sRUFBRSxhQUFhO2dCQUNwQixPQUFNO2FBQ1A7U0FDRjtJQUNILENBQUM7SUFFRDs7Ozs7OztNQU9FO0lBQ0YsMEJBQUssR0FBTDtRQUNFLE9BQU87UUFDUCxJQUFJLE9BQU8sRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksQ0FBQztRQUNsQyxPQUFPO1FBQ1AsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUE7UUFDakIsaUJBQWlCO1FBQ2pCLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUE7UUFDbkIsY0FBYztRQUNkLFFBQVEsR0FBRyxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUE7UUFDckIsY0FBYztRQUNkLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUE7UUFDdEIsV0FBVztRQUNYLE9BQU8sR0FBRyxDQUFDLENBQUE7UUFDWCx3QkFBd0I7UUFDeEIsT0FBTyxJQUFJLEVBQUU7WUFDWCxJQUFJLEtBQUssU0FBQSxFQUFFLE1BQU0sU0FBQSxDQUFDO1lBQ2xCLFlBQVk7WUFDWiwwQkFBMEI7WUFDMUIsS0FBSyxHQUFHLENBQUMsT0FBTyxJQUFJLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQTtZQUMxQixNQUFNLEdBQUcsS0FBSyxHQUFHLENBQUMsQ0FBQTtZQUVsQixlQUFlO1lBQ2YsSUFBRyxLQUFLLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLElBQUksTUFBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFO2dCQUM1RCxPQUFPLElBQUksQ0FBQTthQUNaO1lBRUQsYUFBYTtZQUNiLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLFNBQVMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSx5REFBeUQ7Z0JBQzNILElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsdUJBQXVCO29CQUM1RCxlQUFlO29CQUNmLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQTtvQkFDeEIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQTtvQkFDM0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLElBQUksQ0FBQTtvQkFDbEIsT0FBTztvQkFDUCxPQUFPLEdBQUcsS0FBSyxDQUFBO29CQUNmLE1BQU07b0JBQ04sU0FBUTtpQkFDVDtxQkFBTTtvQkFDTCxPQUFPLElBQUksQ0FBQTtpQkFDWjthQUNGO2lCQUFNLEVBQUUsUUFBUTtnQkFDZixJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLHVCQUF1QjtvQkFDN0QsZUFBZTtvQkFDZixJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUE7b0JBQ3hCLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7b0JBQzVCLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxJQUFJLENBQUE7b0JBQ25CLE9BQU87b0JBQ1AsT0FBTyxHQUFHLE1BQU0sQ0FBQTtvQkFDaEIsTUFBTTtvQkFDTixTQUFRO2lCQUNUO3FCQUFNO29CQUNMLE9BQU8sSUFBSSxDQUFBO2lCQUNaO2FBQ0Y7U0FFRjtRQUVELGdCQUFnQjtRQUNoQixPQUFPLElBQUksQ0FBQTtJQUNiLENBQUM7SUFFRCxRQUFRO0lBQ1IsMEJBQUssR0FBTDtRQUNFLGdCQUFnQjtRQUNoQixJQUFJLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQTtJQUNqQixDQUFDO0lBRUQsVUFBVTtJQUNWLDhCQUFTLEdBQVQ7UUFDRSxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFBO0lBQzFCLENBQUM7SUFDSCxpQkFBQztBQUFELENBM0hBLEFBMkhDLElBQUE7O0FBR0Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUErQkUiLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyIvKipcclxuICogQSBTdGFyIOWvu+i3r+S8mOWMliBcclxuICog5LqM5Y+J5aCG5LyY5YyWXHJcbiAqIFxyXG4gKiDkuozlj4nloIbmmK/kuIDnp43lrozlhajkuozlj4nmoJHvvIzmnInkuKTnp43nsbvlnovvvJrmnIDlpKfloIbvvIjlpKfmoLnloIbvvInjgIHmnIDlsI/loIbvvIjlsI/moLnloIbvvIlcclxuICog5Zug5Li6QSDmmJ/mn6Xmib5G5YC85pyA5bCP77yM5omA5Lul6L+Z6YeM5L2/55So5pyA5bCP5aCG77yM54i26IqC54K55q+U5a2Q6IqC54K55bCP5oiW55u4562JIOS/neivgeacgOWwj+S9jeWcqOS4iuaWuVxyXG4gKiDlrp7pmYXlrZjlgqjmmK/ku6XmlbDnu4TlvaLlvI/vvIzkvYbmmK/pgLvovpHlsYLpnaLmmK/moJHlnotcclxuICogXHJcbiAqIOWPluWHuuWSjOWIoOmZpOmDveS8muaUueWPmOWOn+acieeahOS6jOWPieWghlxyXG4gKiBcclxuICog5Y+W5Ye65pyA5bCP5YC8XHJcbiAqIOWIoOmZpOafkOS4gOS9jVxyXG4gKiDmn6Xmib7mn5DkuIDkvY1cclxuKi9cclxuXHJcbmltcG9ydCBBU3Rhck5vZGUgZnJvbSBcIi4vQVN0YXJOb2RlXCJcclxuXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEJpbmFyeUhlYXAge1xyXG5cclxuICAvLyDkuozlj4nloIbomb3nhLbmmK/lrozlhajkuozlj4nmoJHvvIzkvYblhbbmnKzotKjov5jmmK/nlLHmlbDnu4Tpobrluo/lrZjlgqhcclxuICBfdHJlZTogQXJyYXk8QVN0YXJOb2RlPlxyXG5cclxuICBjb25zdHJ1Y3RvcigpIHtcclxuICAgIC8vIOWIneWni+WMluS6jOWPieWghlxyXG4gICAgdGhpcy5fdHJlZSA9IFtdXHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiDpgLvovpHvvJog54i26IqC54K55LiL5qCH5Li6cGFyZW50SSDlrZDoioLngrnkuIvmoIfkuLppXHJcbiAgICogIOebtOaOpeWwhuW9k+WJjeeCueaPkuWFpeWIsOacgOWQjuS4gOS9je+8jFxyXG4gICAqICDkuI7lhbbniLboioLngrnmr5TovoPvvIzlpoLmnpzlsI/kuo7lhbbniLboioLngrnlsLHkuqTmjaLkvY3nva5cclxuICAgKiAg54S25ZCO6YeN5aSNXHJcbiAgICogXHJcbiAgKi9cclxuICBpbnNlcnQobm9kZTogQVN0YXJOb2RlKSB7XHJcbiAgICBsZXQgaSwgcGFyZW50STtcclxuICAgIC8vIOaPkuWFpeWwvumDqFxyXG4gICAgdGhpcy5fdHJlZS5wdXNoKG5vZGUpXHJcbiAgICAvLyDojrflj5bkuIvmoIdcclxuICAgIGkgPSB0aGlzLl90cmVlLmxlbmd0aCAtIDFcclxuXHJcbiAgICAvLyDph43lpI3miafooYwg5piv5ZCm5q+U5YW254i26IqC54K55bCPXHJcbiAgICB3aGlsZSAodHJ1ZSkge1xyXG4gICAgICAvLyDpgqPkuYjlpoLkvZXmsYLlh7rniLboioLngrnkuIvmoIcgKGkgLSAxKSAvIDIg5pyJ5bCP5pWw54K555u05o6l6IiN5Y675bCP5pWw54K55L2NXHJcbiAgICAgIC8vIHBhcmVudEkgPSBNYXRoLmZsb29yKChpIC0gMSkgLyAyKSAvLyDnu4boioLkvJjljJYgXHJcbiAgICAgIHBhcmVudEkgPSAoaSAtIDEpID4+IDFcclxuICAgICAgLy8g5q+U6L6D5aSn5bCPXHJcbiAgICAgIGlmICh0aGlzLl90cmVlW3BhcmVudEldICYmIG5vZGUuZiA8IHRoaXMuX3RyZWVbcGFyZW50SV0uZikgeyAvLyDmnaHku7bmiJDnq4sg5L2N572u5Lqk5o2iXHJcbiAgICAgICAgbGV0IHRlbXAgPSB0aGlzLl90cmVlW3BhcmVudEldXHJcbiAgICAgICAgdGhpcy5fdHJlZVtwYXJlbnRJXSA9IG5vZGVcclxuICAgICAgICB0aGlzLl90cmVlW2ldID0gdGVtcFxyXG4gICAgICAgIC8vIOS4i+agh+e9ruaNolxyXG4gICAgICAgIGkgPSBwYXJlbnRJXHJcblxyXG4gICAgICAgIC8vIOS4i+S4gOi9rlxyXG4gICAgICB9IGVsc2UgeyAvLyDnrYnkuo7miJbogIXlpKfkuo7pg73kuI3miJDnq4tcclxuICAgICAgICByZXR1cm5cclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICog6YC76L6R57G75Ly877yMXHJcbiAgICogIOS9huaYr+aYr+WKoOWFpeiKgueCueeahOWPjeWQkei/h+eoi++8jOWPjeWQkeS4i+ayiVxyXG4gICAqICDliKDpmaTmoLnoioLngrlcclxuICAgKiAg5bCG5bC+6YOo6IqC54K56KGl5Yiw5qC56IqC54K55aSEXHJcbiAgICogIOWIpOaWreWFtuaYr+WQpuespuWQiOacgOWwj+WghuinhOWIme+8jOS4jeespuWQiOWwseS4i+ayiSDkuIDkuKrkuIDkuKrlvoDkuIrnva7mjaJcclxuICAgKiAg5bem5a2p5a2Q5LiL5qCH5bCx5pivIDIgKiBwYXJlbnQgKyAxICDlj7PlranlrZDkuIvmoIfmmK8yICogcGFyZW50ICsgMlxyXG4gICovXHJcbiAgc2hpZnQoKTogQVN0YXJOb2RlIHtcclxuICAgIC8vIOaPkOWJjeWjsOaYjlxyXG4gICAgbGV0IHBhcmVudEksIG5vZGUsIGxhc3ROb2RlLCB0cmVlO1xyXG4gICAgLy8g6I635Y+W5byV55SoXHJcbiAgICB0cmVlID0gdGhpcy5fdHJlZVxyXG4gICAgLy8g6KaB6KKr6L+U5Zue55qERuWAvOacgOWwj+eahOmCo+S4quiKgueCuVxyXG4gICAgbm9kZSA9IHRyZWUuc2hpZnQoKVxyXG4gICAgLy8g5bCG5pyA5ZCO5LiA5L2N6KGl5Yiw5qC56IqC54K55aSEXHJcbiAgICBsYXN0Tm9kZSA9IHRyZWUucG9wKClcclxuICAgIC8vIOWwhuWwvumDqOiKgueCueihpeWIsOagueiKgueCueWkhFxyXG4gICAgdHJlZS51bnNoaWZ0KGxhc3ROb2RlKVxyXG4gICAgLy8g54i26IqC54K55LiL5qCH5Yid5aeL5YyWXHJcbiAgICBwYXJlbnRJID0gMFxyXG4gICAgLy8g5b6q546v5Yik5pat5YW25piv5ZCm5bCP5LqO5YW25Lik5Liq5a2Q6IqC54K55Lit5pyA5bCP55qE6YKj5L2NXHJcbiAgICB3aGlsZSAodHJ1ZSkge1xyXG4gICAgICBsZXQgbGVmdEksIHJpZ2h0STtcclxuICAgICAgLy8g5rGC5Ye65bem5Y+z5a2p5a2Q55qE5LiL5qCHXHJcbiAgICAgIC8vIGxlZnRJID0gMiAqIHBhcmVudEkgKyAxXHJcbiAgICAgIGxlZnRJID0gKHBhcmVudEkgPDwgMSkgKyAxXHJcbiAgICAgIHJpZ2h0SSA9IGxlZnRJICsgMVxyXG5cclxuICAgICAgLy8g6aaW5YWI5pyJ5peg6L+Z5Lik5Liq5L2N572u55qE6IqC54K5XHJcbiAgICAgIGlmKGxlZnRJID49IHRoaXMuX3RyZWUubGVuZ3RoICYmIHJpZ2h0SSA+PSB0aGlzLl90cmVlLmxlbmd0aCkge1xyXG4gICAgICAgIHJldHVybiBub2RlXHJcbiAgICAgIH1cclxuXHJcbiAgICAgIC8vIOWvueavlOS4pOS4quWtkOiKgueCueiwgeabtOWwj1xyXG4gICAgICBpZiAodHJlZVtyaWdodEldID09IHVuZGVmaW5lZCB8fCB0cmVlW2xlZnRJXS5mIDw9IHRyZWVbcmlnaHRJXS5mKSB7IC8vIOebuOetieaIluiAheW3puWtkOiKgueCueWwjyDojrflj5ZyaWdodEkg562J5LqOdW5kZWZpbmVkIOS4uuS7gOS5iOS4jeWIpOaWrWxlZnRJ5ZGi77yM5Zug5Li65YmN6Z2i5bey57uP5Yik5pat6L+H5LqGXHJcbiAgICAgICAgaWYgKHRyZWVbcGFyZW50SV0uZiA+IHRyZWVbbGVmdEldLmYpIHsgLy8g572u5o2i5p2h5Lu277yM5b2T5YmN54i26IqC54K55aSn5LqO5pyA5bCP55qE5LiA5L2N5a2Q6IqC54K5XHJcbiAgICAgICAgICAvLyDpgJrov4fkuK3pl7Tlj5jph4/miafooYzkuIrmta7mk43kvZxcclxuICAgICAgICAgIGxldCB0ZW1wID0gdHJlZVtwYXJlbnRJXVxyXG4gICAgICAgICAgdHJlZVtwYXJlbnRJXSA9IHRyZWVbbGVmdEldXHJcbiAgICAgICAgICB0cmVlW2xlZnRJXSA9IHRlbXBcclxuICAgICAgICAgIC8vIOWdkOagh+i9rOaNolxyXG4gICAgICAgICAgcGFyZW50SSA9IGxlZnRJXHJcbiAgICAgICAgICAvLyDkuIvkuIDova5cclxuICAgICAgICAgIGNvbnRpbnVlXHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgIHJldHVybiBub2RlXHJcbiAgICAgICAgfVxyXG4gICAgICB9IGVsc2UgeyAvLyDlj7PlrZDoioLngrnlsI9cclxuICAgICAgICBpZiAodHJlZVtwYXJlbnRJXS5mID4gdHJlZVtyaWdodEldLmYpIHsgLy8g572u5o2i5p2h5Lu277yM5b2T5YmN54i26IqC54K55aSn5LqO5pyA5bCP55qE5LiA5L2N5a2Q6IqC54K5XHJcbiAgICAgICAgICAvLyDpgJrov4fkuK3pl7Tlj5jph4/miafooYzkuIrmta7mk43kvZxcclxuICAgICAgICAgIGxldCB0ZW1wID0gdHJlZVtwYXJlbnRJXVxyXG4gICAgICAgICAgdHJlZVtwYXJlbnRJXSA9IHRyZWVbcmlnaHRJXVxyXG4gICAgICAgICAgdHJlZVtyaWdodEldID0gdGVtcFxyXG4gICAgICAgICAgLy8g5Z2Q5qCH6L2s5o2iXHJcbiAgICAgICAgICBwYXJlbnRJID0gcmlnaHRJXHJcbiAgICAgICAgICAvLyDkuIvkuIDova5cclxuICAgICAgICAgIGNvbnRpbnVlXHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgIHJldHVybiBub2RlXHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcblxyXG4gICAgfVxyXG5cclxuICAgIC8vIOi/lOWbniDkv53mjIHlkozljp/mlbDnu4Tmlrnms5XkuIDoh7RcclxuICAgIHJldHVybiBub2RlXHJcbiAgfVxyXG5cclxuICAvLyDmuIXnqbrkuozlj4nloIZcclxuICBjbGVhcigpIHtcclxuICAgIC8vIOebtOaOpeS4ouW8g+WOn+acieaVsOe7hO+8jOetieW+hUdDXHJcbiAgICB0aGlzLl90cmVlID0gW11cclxuICB9XHJcblxyXG4gIC8vIOi/lOWbnuS6jOWPieWghumVv+W6plxyXG4gIGdldExlbmd0aCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX3RyZWUubGVuZ3RoXHJcbiAgfVxyXG59XHJcblxyXG5cclxuLyoqXHJcbiAqICAgICAgICAgIDlcclxuICogICAgMzAgICAgICAgICAgMzJcclxuICogIDQwICA1NiAgICAgIC0xMFxyXG4gKlxyXG4gKiAgMC4gWzksIDMwLCAzMiwgNDAsIDU2XVxyXG4gKiAgMS4gWzU2LCAzMCwgMzIsIDQwXVxyXG4gKiAgcCA9IDBcclxuICogIOaxguWHuuW3puWPs+WtkOiKgueCuee0ouW8lVxyXG4gKiAgbCA9IDAgKiAyICsgMSAgICAvLyAxXHJcbiAqICByID0gbCArIDEgICAgICAgIC8vIDJcclxuICpcclxuICogIOavlOWvuSAzMCA8PSAzMiAgLy8gdHJ1ZVxyXG4gKiAgICAgNTYgPiAzMCAvLyB0cnVlXHJcbiAqICAgICAgWzMwLCA1NiwgMzIsIDQwXSAvLyBwID0gMVxyXG4gKiBcclxuICogIOaxguWHuuW3puWPs+WtkOiKgueCuee0ouW8lVxyXG4gKiAgbCA9IDEgKiAyICsgMSAgICAvLyAzXHJcbiAqICByID0gbCArIDEgICAgICAgIC8vIDRcclxuICogIFxyXG4gKiAg5q+U5a+5IDQwIDw9IHVuZGVmaW5lZCB8fCByID09IHVuZGVmaW5lZCAvLyB0cnVlXHJcbiAqICAgIDU2ID4gNDAgLy8gdHJ1ZVxyXG4gKiAgICAgIFszMCwgNDAsIDMyLCA1Nl0gLy8gcCA9IDNcclxuICogXHJcbiAqICDmsYLlh7rlt6blj7PlrZDoioLngrnntKLlvJVcclxuICogIGwgPSAxICogMiArIDEgICAgLy8gN1xyXG4gKiAgciA9IGwgKyAxICAgICAgICAvLyA4XHJcbiAqIFxyXG4gKiAg6ZW/5bqm6LaF5Ye677yM55u05o6l6L+U5ZueXHJcbiAqIFxyXG4gKiBcclxuKi8iXX0=