
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcAniManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd43bcqYllVCJY4lu31yHQoj', 'NpcAniManager');
// scripts/EVA_npc/NpcAniManager.ts

"use strict";
/**
 * 优化NPC生成动画clip的代码 避免多个相同角色多次重复执行相同代码，
 *  主题：
 *    一个npc实例化后， 会进行模板生成，这个过程中，需要根据动画ID去查找相应帧
 *    最后将6个基本动作全部创建成clip
 *
 *    这意味着 如果NPC的外观是一致的，那么重复的代码就会执行，带来没必要的消耗
*/
Object.defineProperty(exports, "__esModule", { value: true });
// 调用方式： NpcAniManager.getWalkA(id: number) // 如果没找到返回undefined
var NpcAniManager = /** @class */ (function () {
    function NpcAniManager() {
    }
    // 获取动画帧
    NpcAniManager.getAnimClip = function (id, clipName) {
        // 避免多次访问
        var temp = this._anims[id];
        // 查找是否有此动画帧对象
        if (!temp)
            return;
        // 返回结果 可能是undefined 或者 clip
        return temp[clipName];
    };
    // 获取某个ID的所有动画帧
    NpcAniManager.getAnimAllClip = function (id) {
        return this._anims[id];
    };
    // 保存动画帧
    NpcAniManager._setAnimClip = function (id, clipName, clip) {
        var temp = this._anims[id];
        // 赋值空对象 以id为名
        if (!temp)
            temp = this._anims[id] = {};
        // clipName 为key clip 为值
        return temp[clipName] = clip;
    };
    // 动态添加clip
    NpcAniManager.createClip = function (id, frames, name, ispeed, wrapMode) {
        if (ispeed === void 0) { ispeed = 1; }
        if (wrapMode === void 0) { wrapMode = cc.WrapMode.Loop; }
        // 创建一个clip
        var clip = cc.AnimationClip.createWithSpriteFrames(frames, frames.length);
        // 命名
        clip.name = name;
        // 播放速度
        clip.speed = ispeed;
        // 播放速率
        clip.sample = 60;
        // 循环模式
        clip.wrapMode = wrapMode;
        // 保存动画帧
        this._setAnimClip(id, name, clip);
        return clip;
    };
    // 创建动画
    NpcAniManager.createFrames = function (arr, atlas) {
        var frames = [];
        // 动态创建clip 
        arr.forEach(function (item, i) {
            var sprite = atlas.getSpriteFrame(item);
            // 异常处理
            if (!sprite) {
                console.warn('获取帧错误, 这将导致动画播放异常 ' + item);
            }
            frames[i] = sprite;
        });
        // 
        return frames;
    };
    // 动画帧存储对象
    NpcAniManager._anims = {};
    return NpcAniManager;
}());
exports.default = NpcAniManager;
/**
let animAllClip = NpcAniManager.getAnimAllClip(animId)

    if (animAllClip) { // 存在的情况
      let {npc1_front, npc1_rear, stand_a, stand_b, action_a, action_b} = animAllClip
      // 更改动画速度
      npc1_front.speed = this.walkIspeed
      npc1_rear.speed = this.walkIspeed
      
      // 添加动画帧
      npcAnim.addClip(npc1_front)
      npcAnim.addClip(npc1_rear)
      npcAnim.addClip(stand_a)
      npcAnim.addClip(stand_b)
      npcAnim.addClip(action_a)
      npcAnim.addClip(action_b)

    }
*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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