
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '00f0aUY9PZGkLgT0vj6/LAR', 'NpcManager');
// scripts/EVA_npc/NpcManager.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NpcNormal_1 = require("./NpcNormal");
var ResLoaderManager_1 = require("../Manager/ResLoaderManager");
/*
  Npc 的管理调度类
  单例实现
*/
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// 当程序去随机生成位置时，会遇到一些没有标清楚的点，对这些点进行寻路通常结果会失败，会带来极大的性能开销 通过手动遍历记录点信息让程序可以跳过这些点 坐标点都是独一无二的 (x,y) 作为对象名
var NpcManager = /** @class */ (function (_super) {
    __extends(NpcManager, _super);
    function NpcManager() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // Npc的通用预制体
        _this.npcPrefab = null;
        // NPC 添加进入这一层
        _this.wallLayer = null;
        // 对象层 记录了 逗留点 离开点 初始化点的信息 
        _this.pointLayer = null;
        /** 透明层 记录人物需要透明的位置*/
        _this.moveLayer = null;
        // 空闲展台列表
        _this.freeExhibitions = [];
        // 所有展台列表 {124: {x: y,}}
        _this.allExhibitions = {};
        // 参观完成的 NPC 列表, 但是没有空闲展台供其参观, 所以先加入列表 等候下一次调度
        _this.visitFinish = [];
        // NPC 入场点
        _this.inPointList = [];
        // NPC 离场点
        _this.outPointList = [];
        // NPC 闲逛点 随机生成，不能重复
        _this.strollList = [];
        // 所有普通NPC的配置对象
        _this.npcConfig = null;
        // 所有特殊NPC的配置对象
        _this.npcSC = null;
        // 通用口头禅列表
        _this.phraseList = null;
        /***************** 配置NPC的属性 *****************/
        // 从游戏开始到目前为止的NPC数量 只增加不减少
        _this.allNpcNum = null;
        // 当前处于场馆中的npc数量 不包括bus上的旅游团
        _this.npcNum = null;
        // 场上的特殊Npc数量
        _this.specialNpcNum = 0;
        // 游戏一开始 游客上限默认为5
        _this.upperLimit = null;
        // 特殊NPC ID列表
        _this.specialNpcIdList = null;
        return _this;
    }
    NpcManager_1 = NpcManager;
    /***************** 配置NPC的属性 *****************/
    // 获取实例
    NpcManager.getInstance = function () {
        if (this.instance === null) {
            this.instance = new NpcManager_1();
        }
        return this.instance;
    };
    // 初始化
    NpcManager.prototype.init = function () {
        // TEST
        // this.freeExhibitions.push({
        //   x: 33,
        //   y: 44,
        //   direction: 'bottom'
        // })
        // 初始化数据
        this.initData();
        // 初始化停留点信息
        this.initPoints();
        // 事件绑定
        this.bindEvent();
    };
    // 初始化数据
    NpcManager.prototype.initData = function () {
        // 获取地图
        var map = cc.find('Canvas/Baseview/obj_map/map100').getComponent(cc.TiledMap);
        // 获取墙的图层
        this.wallLayer = map.getLayer('wall');
        // 获取对象层
        this.pointLayer = map.getObjectGroup("point");
        this.moveLayer = map.getLayer("move");
        // 获取资源管理器的实例 因为只初始化一次, 所以就没必要保存成属性
        var sm = ResLoaderManager_1.default.getInstance();
        // 获取npc预制体
        this.npcPrefab = sm.getPrefab('npc');
        // 读取配置表
        this.npcConfig = sm.getConfig('visitor');
        // 获取通用口头禅
        this.phraseList = [];
        // NPC 配置数据初始化
        this.allNpcNum = this.npcNum = 0;
        this.upperLimit = 40;
    };
    /** 初始化 所有的开始 停留 结束 点*/
    NpcManager.prototype.initPoints = function () {
        var list = this.pointLayer.getObjects();
        for (var i = 0; i < list.length; i++) {
            // 临时变量， 只做接收list[i] 的值
            var temp = list[i];
            if (temp.pointType == 0) {
                this.inPointList.push({
                    x: temp.posx,
                    y: temp.posy
                });
            }
            else if (temp.pointType == 1) {
                var dirStr = '';
                switch (temp.direction) {
                    case 1:
                        dirStr = 'left';
                        break;
                    case 2:
                        dirStr = 'top';
                        break;
                    case 3:
                        dirStr = 'right';
                        break;
                    case 4:
                        dirStr = 'bottom';
                        break;
                }
                var data = {
                    x: temp.posx,
                    y: temp.posy,
                    direction: dirStr
                };
                // 保存所有展品的ID 和对应的信息
                this.allExhibitions[temp['id']] = data;
                // TEST
                this.freeExhibitions.push(data);
            }
            else if (temp.pointType == 2) {
                // this.outPointList.push({
                //   x: temp.posx,
                //   y: temp.posy
                // })
            }
        }
    };
    // NPC开始实例化, 不再交由Game类
    NpcManager.prototype.npcStart = function () {
        var _this = this;
        // 定时器开启, 每隔一段时间触发 实例化NPC进馆
        this.schedule(function () {
            //只有当前npc数量没有超出限制时 才会实例化 
            if (_this.npcNum < _this.upperLimit) {
                _this.instantiateNpc();
            }
        }, 5);
    };
    /** 添加游客上限*/
    NpcManager.prototype.addVisitorMax = function (num) {
        this.upperLimit += num;
    };
    // 事件绑定
    NpcManager.prototype.bindEvent = function () {
        // 参观完成
        cc.systemEvent.on('visitfinish', this.release.bind(this));
        // npc 期望离开
        // cc.systemEvent.on('leave', this.leave.bind(this))
    };
    // 实例化NPC
    NpcManager.prototype.instantiateNpc = function () {
        var _this = this;
        // 生成实例
        var node = cc.instantiate(this.npcPrefab);
        // 每实例化一个NPC总数+1
        this.npcNum++;
        this.allNpcNum++;
        // 挂载节点 onload 触发
        this.moveLayer.addUserNode(node);
        // 挂载脚本 再获取其身上的脚本组件 传入出生点坐标信息
        var npc = node.addComponent(NpcNormal_1.default);
        var config = this.npcConfig[~~(Math.random() * this.npcConfig.length)];
        // 增加一些基本口头禅用于进入
        config.visitor_phrase = config.visitor_phrase.concat(this.phraseList);
        // 初始化NPC的核心 一个NPC默认只是个模板，这也是npc初始化的必要步骤之一
        npc.soulInit(config);
        // 初始化出生点 ~~(Math.random() * this.inPointList.length)
        // npc.setBirthPoint(this.inPointList[~~(Math.random() * this.inPointList.length)])
        npc.setBirthPoint(this.inPointList[0]);
        // npc.setBirthPoint(this.findStrollPoint(this.wallLayer))
        // 这段函数太过耗时, 先让出执行权
        setTimeout(function () {
            // 资源调度
            _this.dispatch(npc);
        }, 100);
    };
    // 调度NPC 前往闲置的展台
    NpcManager.prototype.dispatch = function (npc) {
        var random = ~~(this.freeExhibitions.length * Math.random());
        // 从空闲展台中，拿取第一位，
        var visit = this.freeExhibitions.splice(random, 1)[0];
        // 如果有值的话说明有空位
        if (visit) {
            // 通知其行进至哪个地点
            var isFeasible = npc.go(visit);
            // 看下当前传入的坐标点是否可行 如果找不到路径， 那么返回false 否则返回true
            if (!isFeasible) {
                console.log('寻路失败');
                // 再次进行调度
                this.dispatch(npc);
                // 同时 当前点将会被清除
            }
        }
        else {
            // 先找一遍看下它在不在里面， 如果已经在里面就不添加进入
            var isInVisitFinish = this.visitFinish.find(function (item) { return item === npc; });
            if (isInVisitFinish == undefined) {
                // 将当前NPC先加入闲逛列表
                this.visitFinish.push(npc);
            }
            // 没有空位 NPC进入闲逛
            // 查找闲逛点 传入npc所在的墙的图层， 二是npc当前的位置
            var posi = this.findStrollPoint(npc.coordinate);
            // go go go
            var isFeasible = npc.go(posi);
            // 看下当前传入的坐标点是否可行 如果找不到路径， 那么返回false 否则返回true
            if (!isFeasible) {
                // 他都没有添加进去 清除个锤子
                if (isInVisitFinish == undefined) {
                    // 当然 得先清除下当前NPC在闲逛列表中的标记
                    this.visitFinish.pop();
                }
                // 再次进行调度
                this.dispatch(npc);
            }
        }
    };
    // 当npc参观完成后， 需要释放其身上的展台信息， 同时将该NPC加入空闲NPC列表中
    NpcManager.prototype.release = function (data) {
        // 接收到了节点
        var npc = data.getUserData();
        // 释放当前展台
        if (npc.targetCoordinate.direction != undefined) {
            // 只有当它记录了展台信息才释放回去
            this.freeExhibitions.push(npc.targetCoordinate);
        }
        // 判断当前是否有处于闲逛中的npc
        if (this.visitFinish.length > 0) {
            // 调度当前npc
            var freeNpc = this.visitFinish.shift();
            // 进入寻路
            this.dispatch(freeNpc);
        }
        // 调度
        this.dispatch(npc);
    };
    // 寻找空闲可用点 当展品坐标数量不足的情况下，npc可以去展馆内闲逛
    NpcManager.prototype.findStrollPoint = function (coordinate) {
        var len = this.strollList.length;
        if (len <= 0) {
            cc.warn('闲逛点数量为0, 已经安排npc前往应急点');
            return { x: 41, y: 105 };
        }
        else {
            var _a = this.strollList[~~(Math.random() * len)], x = _a.x, y = _a.y;
            if (coordinate.x !== x && coordinate.y !== y) { // 避免相同点
                return { x: x, y: y };
            }
            else {
                // 递归调用
                return this.findStrollPoint(coordinate);
            }
        }
    };
    var NpcManager_1;
    // 实例
    NpcManager.instance = null;
    __decorate([
        property(cc.Prefab)
    ], NpcManager.prototype, "npcPrefab", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcManager.prototype, "wallLayer", void 0);
    __decorate([
        property(cc.TiledObjectGroup)
    ], NpcManager.prototype, "pointLayer", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcManager.prototype, "moveLayer", void 0);
    NpcManager = NpcManager_1 = __decorate([
        ccclass
    ], NpcManager);
    return NpcManager;
}(cc.Component));
exports.default = NpcManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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