
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/EVA_npc/NpcSuper.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '4c5c4SRsBdHkbvo2x85R+vo', 'NpcSuper');
// scripts/EVA_npc/NpcSuper.ts

"use strict";
/*
  Npc 们的公共继承类
  决定了普通NPC和特殊NPC的原型
*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var AStarManager_1 = require("../AStar/AStarManager");
var ResLoaderManager_1 = require("../Manager/ResLoaderManager");
var NpcAniManager_1 = require("./NpcAniManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// 定义位置 常量
var Posi;
(function (Posi) {
    Posi[Posi["TOP"] = 0] = "TOP";
    Posi[Posi["RIGHT"] = 1] = "RIGHT";
    Posi[Posi["BOTTOM"] = 2] = "BOTTOM";
    Posi[Posi["LEFT"] = 3] = "LEFT";
})(Posi || (Posi = {}));
var NpcState;
(function (NpcState) {
    NpcState[NpcState["VISIT"] = 0] = "VISIT";
    NpcState[NpcState["WALK"] = 1] = "WALK";
    NpcState[NpcState["FREE"] = 2] = "FREE";
    NpcState[NpcState["LEAVE"] = 3] = "LEAVE";
    NpcState[NpcState["INTERACTIVE"] = 4] = "INTERACTIVE";
})(NpcState = exports.NpcState || (exports.NpcState = {}));
// NPC 的心情常量
var Mood;
(function (Mood) {
    Mood[Mood["AMAZEMENT"] = 0] = "AMAZEMENT";
    Mood[Mood["ANGER"] = 1] = "ANGER";
    Mood[Mood["CHERISH"] = 2] = "CHERISH";
    Mood[Mood["CRY"] = 3] = "CRY";
    Mood[Mood["CRYING"] = 4] = "CRYING";
    Mood[Mood["FIGHTING"] = 5] = "FIGHTING";
    Mood[Mood["LIKE"] = 6] = "LIKE";
    Mood[Mood["QUERY"] = 7] = "QUERY";
    Mood[Mood["SMILE"] = 8] = "SMILE";
    Mood[Mood["SUN_SMILE"] = 9] = "SUN_SMILE";
    Mood[Mood["SWEAT"] = 10] = "SWEAT";
})(Mood = exports.Mood || (exports.Mood = {}));
var NpcSupper = /** @class */ (function (_super) {
    __extends(NpcSupper, _super);
    function NpcSupper() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /*********特殊属性 决定npc的核心*********/
        // 当前npc在配置表中的ID 方便以后的操作
        _this.npcId = null;
        // 性别
        _this.sex = null;
        // 年龄
        _this.age = null;
        // 口头禅
        _this.phraseList = null;
        // 图集资源地址 每个NPC都有一个独一无二的标识地址, 程序会根据这个标识地址去添加固定字符串然后寻找特定图片
        _this.source = null;
        // npc名称
        _this.npcName = null;
        /*********特殊属性 决定npc的核心*********/
        // 墙的图层 用于做 坐标处理
        _this.wallLayer = null;
        /** 透明坐标图层*/
        _this.moveLayer = null;
        // npc 节点
        _this.npcNode = null;
        // npc 节点上的动画组件
        _this.npcAnim = null;
        // npc节点上的文字节点
        _this.npcStateWrap = null;
        // 描述NPC 状态信息的表情节点
        _this.npcMoodNode = null;
        // 描述NPC 状态信息的表情Sprite组件
        _this.npcMood = null;
        // 资源管理的实例
        _this.sm = null;
        // 移动的下标
        _this.moveIndex = null;
        // 移动的数组
        _this.moveList = null;
        // 当前npc所在的 x，y坐标
        _this.coordinate = null;
        // 外界要求前往的目标点
        _this.targetCoordinate = null;
        // 是否在参观展品还是在行走, 需要一个状态 
        _this.state = null;
        // npc 当前移动的方向
        _this.movePosi = null;
        // 已经参观过多少个展品
        _this.visited = null;
        // 期待参观数 当已参观数量大于等于 期待参观数时，就通知外界， 这个npc想要离开
        _this.visit = null;
        // 获取A* 管理器的实例
        _this.aStarInstance = null;
        // npc 的移动速度
        _this.ispeed = null;
        // npc 的移动动画执行速度
        _this.walkIspeed = null;
        // 所有NPC的动画配置对象
        _this.npcAnimConfig = null;
        // npc的标志
        _this.sign = null;
        return _this;
        // start() { }
        // update() { }
    }
    // 初始化数据
    NpcSupper.prototype.init = function () {
        // 获取表情节点
        this.npcMoodNode = this.node.getChildByName('look');
        // 获取表情节点的 Sprite 组件
        this.npcMood = this.npcMoodNode.getChildByName('icon').getComponent(cc.Sprite);
        // 获取文字容器
        this.npcStateWrap = this.node.getChildByName('stateWrap');
        // 初始化npc节点
        this.npcNode = cc.find('img_npc', this.node);
        // 获取动画组件
        this.npcAnim = this.npcNode.getComponent(cc.Animation);
        // 初始化npc的速度 最快0.5 - 1 保留2位有限小数
        var offset = +(Math.random() * 0.3 + 0.2).toFixed(2); // 一点小偏移
        this.ispeed = 1 - offset; // 这个是移动一段距离的时间
        // npc 的移动动画执行速度
        this.walkIspeed = 1 + offset;
        // 获取墙的图层
        var map = cc.find('Canvas/Baseview/obj_map/map100').getComponent(cc.TiledMap);
        this.wallLayer = map.getLayer('wall');
        this.moveLayer = map.getLayer('move');
        // 初始化已参观数
        this.visited = 0;
        // 初始化期待参观数
        this.visit = Number.MAX_VALUE;
        // 初始化A*实例
        this.aStarInstance = AStarManager_1.default.getInstance();
        // 初始化资源管理的实例
        var sm = this.sm = ResLoaderManager_1.default.getInstance();
        // 读取配置表
        this.npcAnimConfig = sm.getConfig('animation');
    };
    // 更改当前移动方向
    NpcSupper.prototype.changeMovePosi = function (state) {
        this.movePosi = state;
    };
    // 更改当前NPC状态
    NpcSupper.prototype.changeState = function (state) {
        this.state = state;
    };
    // 转向 将原先4个函数 合并成一个函数
    NpcSupper.prototype.turnACorner = function (direction, scaleX, animName) {
        // 避免重复触发
        if (this.movePosi === direction)
            return;
        // 改变行进方向
        this.changeMovePosi(direction);
        // 镜像翻转节点
        this.npcNode.scaleX = scaleX;
        // 播放动画
        this.npcAnim.play(animName);
    };
    // 从当前点, 移动到某一点
    NpcSupper.prototype.moveTo = function (target) {
        var _this = this;
        // 当前位置信息
        var coordinate = this.coordinate;
        // 坐标点比对
        if (coordinate.x - target.x > 0) {
            // 向左
            this.turnACorner(Posi.LEFT, 1, 'npc1_rear');
        }
        else if (coordinate.x - target.x < 0) {
            // 向右
            this.turnACorner(Posi.RIGHT, -1, 'npc1_front');
        }
        else if (coordinate.y - target.y > 0) { // 因为当前程序不走斜角， 所以可以连着esle
            // 向前
            this.turnACorner(Posi.TOP, -1, 'npc1_rear');
        }
        else if (coordinate.y - target.y < 0) {
            // 向后
            this.turnACorner(Posi.BOTTOM, 1, 'npc1_front');
        }
        // 切换坐标
        this.coordinate = target;
        // 判断是否透明点
        if (this.node.opacity !== 0) {
            this.moveLayer.getTileGIDAt(target.x, target.y) != 0 ? this.node.opacity = 127.5 : this.node.opacity = 255;
        }
        // 计算坐标位置
        var v2 = this.correctCoordinate(target);
        // 前往
        cc.tween(this.node)
            .to(this.ispeed, { position: v2 })
            .call(function () {
            // 因为需要多次访问 提前存下
            var len = _this.moveList.length;
            // 移动未结束
            if (_this.moveIndex < len - 1) {
                // 可以进行下一次移动
                _this.moveTo(_this.moveList[++_this.moveIndex]);
            }
            else {
                // 移动结束 进入分支 开始执行不同的程序
                _this.shunt();
            }
            // 在这里处理 当moveIndex 移动到倒数第二个格子的时候, 同时是离开的时候淡出
            if (_this.moveIndex === len - 2 && _this.visit === _this.visited) {
                // 淡出
                _this.fadeOut();
            }
        })
            .start();
    };
    // 由管理器决定终点位置
    NpcSupper.prototype.go = function (posi) {
        // 每次管理器调用这个函数时, 不管当前终点有无抵达, 一样切换行进坐标点 同时更改数组下标
        var moveList = this.aStarInstance.findPath(this.coordinate, posi);
        // 容错判断 如果没有查找到可行路径
        if (moveList === null) {
            // 先退出当前寻路
            // 丢弃当前点，直接进入下一次
            return false;
        }
        this.moveList = moveList;
        // 下标归零
        this.moveIndex = 0;
        // 决定目标点
        this.targetCoordinate = posi;
        // 如果npc 当前还在行走中, 你就切换终点, 那么就直接return 程序会自己接上去的
        if (this.state != NpcState.WALK) {
            // 迭代器启动
            this.moveTo(this.moveList[++this.moveIndex]);
        }
        // npc 状态进入 行走
        this.changeState(NpcState.WALK);
        // 路径可行
        return true;
    };
    // 分流 当moveTo抵达终点后, 有三种情况需要处理
    NpcSupper.prototype.shunt = function () {
        // 1 抵达是展台 那么进入参观阶段
        // 2 抵达的是闲逛点 那么进入等待阶段
        // 判断终点是否是展台并且没有参观完成 -1 是因为如果函数进入这里
        if (this.targetCoordinate.direction && this.visited < this.visit) {
            // npc需要去参观当前展台
            this.lookAround();
            // 是否未抵达参观数量要求
            if (this.visited < this.visit) {
                // 这个函数中有延迟器 逗留一段时间后 通知外界 npc需要前往下一个参观点
                this.delayGoNext(this.produce); // 传入的参数是一个函数， 这个函数是用于制作产出
            }
            else if (this.visited === this.visit) {
                // 该离开这里令人怀念的地方了
                this.leval();
            }
        }
        else if (!this.targetCoordinate.direction && this.visited < this.visit) {
            // 当前npc没有参观完成展台, 并且终点不是站台位置 说明处于闲逛中
            // 等待
            this.wait();
            // 我要前往下一个参观点
            this.delayGoNext();
        }
        else if (this.visited === this.visit) { // 因为每当npc移动到一个点后都会触发这个函数
            // 销毁阶段 
            this.node.removeFromParent();
        }
    };
    // NPC 处于等待状态 这只是个动画的切换, 它会根据你当前的方位执行等待动画
    NpcSupper.prototype.wait = function () {
        // 切换NPC状态
        this.changeState(NpcState.FREE);
        // 移动结束 移动方向置为空
        this.movePosi = null;
        Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
        // 镜像翻转
        this.npcNode.scaleX = 1;
    };
    // 参观
    NpcSupper.prototype.lookAround = function () {
        // 更改npc状态进入参观
        this.changeState(NpcState.VISIT);
        // 根据当前展台朝向 定义人物位置 依据的是展台朝向
        switch (this.targetCoordinate.direction) {
            case 'top':
                Math.random() > 0.5 ? this.npcAnim.play('stand_a') : this.npcAnim.play('action_a');
                // 镜像翻转
                this.npcNode.scaleX = -1;
                break;
            case 'right':
                Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
                // 镜像翻转
                this.npcNode.scaleX = -1;
                break;
            case 'bottom':
                Math.random() > 0.5 ? this.npcAnim.play('stand_b') : this.npcAnim.play('action_b');
                // 镜像翻转
                this.npcNode.scaleX = 1;
                break;
            case 'left':
                Math.random() > 0.5 ? this.npcAnim.play('stand_a') : this.npcAnim.play('action_a');
                // 镜像翻转
                this.npcNode.scaleX = 1;
                break;
        }
        // 移动结束 移动方向置为空
        this.movePosi = null;
        // 参观完成 参观数 ++
        this.visited++;
    };
    // 淡入
    NpcSupper.prototype.fadeIn = function (cb) {
        if (cb === void 0) { cb = function () { }; }
        // 新版API
        cc.tween(this.node)
            .to(.5, { opacity: 255 })
            .call(cb.bind(this))
            .start();
    };
    // 淡出
    NpcSupper.prototype.fadeOut = function (cb) {
        if (cb === void 0) { cb = function () { }; }
        // 
        cc.tween(this.node)
            .to(.5, { opacity: 0 })
            .call(cb.bind(this))
            .start();
    };
    // 离场
    NpcSupper.prototype.leval = function () {
        var _this = this;
        // 通知外界 我要离开
        this.scheduleOnce(function () {
            // 当参观展品数达到数量 那么就直接告诉外界, 我要离开
            var event = new cc.Event.EventCustom('leave', false);
            // 设置参数
            event.setUserData(_this);
            // 发送事件
            cc.systemEvent.dispatchEvent(event);
            // 最后一次金币生成
            _this.produce();
            // 更改状态
            _this.changeState(NpcState.LEAVE);
        }, 3);
    };
    // 对goNext进行一个延迟
    NpcSupper.prototype.delayGoNext = function (func) {
        var _this = this;
        // 延迟一段时间
        this.scheduleOnce(function () {
            // goNext 执行
            _this.goNext(func);
        }, Math.random() * 5 + 5);
        // 停留时间是 最低5秒 最长9.9秒 Math.random() * 5 + 5
    };
    // 前往下一个逗留点
    NpcSupper.prototype.goNext = function (func) {
        // 这个一般是等npc离开后产出金币用的
        func && func.call(this);
        // 参观一段时间通知管理， 当前npc 希望前往另一个参观点
        var event = new cc.Event.EventCustom('visitfinish', false);
        // 设置参数
        event.setUserData(this);
        // 发射
        cc.systemEvent.dispatchEvent(event);
    };
    // 计算并修正坐标
    NpcSupper.prototype.correctCoordinate = function (_a) {
        var x = _a.x, y = _a.y;
        var _b;
        (_b = this.wallLayer.getPositionAt(x, y), x = _b.x, y = _b.y);
        // 因为 坐标转换有些偏差， 需要矫正这些偏差.0
        return cc.v2(x + 32, y + 16);
    };
    // 根据管理器要求 设置出生点
    NpcSupper.prototype.setBirthPoint = function (posi) {
        // 赋值当前点坐标
        this.coordinate = posi;
        // 计算坐标 并赋值
        this.node.setPosition(this.correctCoordinate(posi));
    };
    // 外界调用 注入模板 暂时不要进行内部自己随机
    NpcSupper.prototype.soulInit = function (config) {
        var _this = this;
        // 需要初始化的信息包括 npc的外观，npc的口头禅， npc的年龄， npc的性别等类人信息
        this.phraseList = config.visitor_phrase; // 口头禅 是数组， 从中随机
        this.source = config.visitor_resources; // npc图集地址
        // 避免重复访问
        var npcAnim = this.npcAnim;
        var animId = config.animation_id;
        // 查询一次 如果一个没有，说明其他也没有
        var walkA1 = NpcAniManager_1.default.getAnimClip(animId, 'npc1_front');
        if (walkA1) { // 存在的情况
            // 更改动画速度
            var walkB1 = NpcAniManager_1.default.getAnimClip(animId, 'npc1_rear');
            walkA1.speed = this.walkIspeed;
            walkB1.speed = this.walkIspeed;
            // 添加动画帧
            npcAnim.addClip(walkA1);
            npcAnim.addClip(walkB1);
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'stand_a'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'stand_b'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'action_a'));
            npcAnim.addClip(NpcAniManager_1.default.getAnimClip(animId, 'action_b'));
        }
        else { // 没有的情况
            // 拿到对应的动画配置表
            var animConfig = this.npcAnimConfig[animId];
            // 动作集
            var walkA = animConfig.walk_a, walkB = animConfig.walk_b, standA = animConfig.stand_b_1, standB = animConfig.stand_a_1, actionA = animConfig.stand_b_2, actionB = animConfig.stand_a_2;
            // 获取图集资源 TEST
            var atlas = this.sm.getSpriteAtlasByName(this.source.split('/')[1]);
            // 创建动画帧并添加
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(walkA, atlas), 'npc1_front', this.walkIspeed));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(walkB, atlas), 'npc1_rear', this.walkIspeed));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(standA, atlas), 'stand_a', animConfig.stand_a_1_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(standB, atlas), 'stand_b', animConfig.stand_a_1_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(actionA, atlas), 'action_a', animConfig.stand_a_2_gap));
            npcAnim.addClip(NpcAniManager_1.default.createClip(animId, NpcAniManager_1.default.createFrames(actionB, atlas), 'action_b', animConfig.stand_a_2_gap));
        }
        // UI 渲染 过1秒钟左右后再获取最新的高度
        this.scheduleOnce(function () {
            _this.initEnd();
        }, 1);
    };
    // 当所有同步和异步操作都执行完成 执行这里的代码， 一般都是UI处理
    NpcSupper.prototype.initEnd = function () {
        // 处理节点高度问题 每个NPC高度都不一致 
        this.npcMoodNode.y = this.npcNode.height + 5;
        this.npcStateWrap.y = this.npcNode.height + 10;
    };
    // 产出人气
    NpcSupper.prototype.produce = function () {
    };
    NpcSupper.prototype.onLoad = function () {
        // 设置当前节点透明
        this.node.opacity = 0;
        // 初始化中
        this.init();
        // init 完成后 执行淡入
        this.fadeIn();
    };
    __decorate([
        property(cc.TiledLayer)
    ], NpcSupper.prototype, "wallLayer", void 0);
    __decorate([
        property(cc.TiledLayer)
    ], NpcSupper.prototype, "moveLayer", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcNode", void 0);
    __decorate([
        property(cc.Animation)
    ], NpcSupper.prototype, "npcAnim", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcStateWrap", void 0);
    __decorate([
        property(cc.Node)
    ], NpcSupper.prototype, "npcMoodNode", void 0);
    __decorate([
        property(cc.Sprite)
    ], NpcSupper.prototype, "npcMood", void 0);
    NpcSupper = __decorate([
        ccclass
    ], NpcSupper);
    return NpcSupper;
}(cc.Component));
exports.default = NpcSupper;
/*
  A* 优化
  寻找离终点最近的中转点
  判断是否离npc过远， 如果过远，再以当前中转点为距离
  寻找离当前点最近的中转点

  13.2 14.25 10.9 15.9 14.7
  68.95 / 5
  13.790000000000001

  18.0 20.1 20.6 16.5 17.8
  93 / 5
  18.6

  18.5 16.4 20.4 19.6 20.0
  94.9 / 5
  18.98

  对话处理
    相同特点 -> 框会根据字体动态拉伸大小， 而且是动画形式

    如何确定框的大小

    大声说话 -> 字体变大
    长句陈述 ->
    内心想法

*/ 

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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