
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/Manager/ResLoaderManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd4213eLzwdH/Kucjk55ZNdX', 'ResLoaderManager');
// scripts/Manager/ResLoaderManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** 资源加载路径 需要加载的所有资源*/
exports.SpAtlasPath = [
    // NPC 图集
    "npc/adult01",
];
/** 预制体资源路径*/
exports.PrefabPath = [
    "prefab/eva_npc/npc"
];
exports.JsonCfgPath = [
    "jsonCfg/animation",
    "jsonCfg/visitor",
];
/** 资源管理类*/
var ResLoaderManager = /** @class */ (function () {
    function ResLoaderManager() {
        /** 图集资源列表*/
        this.spAtlasDatas = new Map();
        /** 配置资源列表*/
        this.cfgDatas = new Map();
        /** 预制体资源列表*/
        this.prfDatas = new Map();
    }
    ResLoaderManager.getInstance = function () {
        if (!this._instance) {
            this._instance = new ResLoaderManager();
        }
        return this._instance;
    };
    ResLoaderManager.prototype.initSpriteAtlas = function (cb) {
        var _this = this;
        //初始加载所有游戏资源
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, resource) {
            if (err) {
                cc.error(err);
                return;
            }
            for (var i = 0; i < resource.length; i++) {
                var strArr = resource[i].name.split(".");
                _this.spAtlasDatas.set(strArr[0], resource[i]);
            }
        };
        cc.loader.loadResArray(exports.SpAtlasPath, cc.SpriteAtlas, progressCallback, completeCallback);
    };
    /** 配置数据加载*/
    ResLoaderManager.prototype.initJsonCfg = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, jsonArr) {
            if (err) {
                cc.error(err);
                return;
            }
            // 便利结果
            jsonArr.forEach(function (item) {
                // 获取配置文件名
                var name = item.name;
                _this.cfgDatas.set(name, item.json);
            });
            // cc.log(jsonArr);
        };
        cc.loader.loadResArray(exports.JsonCfgPath, cc.JsonAsset, progressCallback, completeCallback);
    };
    /** 预制体资源加载*/
    ResLoaderManager.prototype.initPrefaRes = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, prefabs) {
            if (err) {
                cc.error(err);
                return;
            }
            //cc.log(prefabs);
            prefabs.forEach(function (item) { return _this.prfDatas.set(item.name, item); });
        };
        cc.loader.loadResArray(exports.PrefabPath, cc.Prefab, progressCallback, completeCallback);
    };
    /** 根据名字获取某张图集*/
    ResLoaderManager.prototype.getSpriteAtlasByName = function (name) {
        var data = this.spAtlasDatas.get(name);
        return data;
    };
    /** 根据名字获取某个预制体*/
    ResLoaderManager.prototype.getPrefab = function (name) {
        return this.prfDatas.get(name);
    };
    /** 根据名字获取某个配置表*/
    ResLoaderManager.prototype.getConfig = function (name) {
        return this.cfgDatas.get(name);
    };
    return ResLoaderManager;
}());
exports.default = ResLoaderManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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