
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/util/MapControl.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1758aVZtK5Gzq+5vGDpXX2/', 'MapControl');
// scripts/util/MapControl.ts

"use strict";
/**
 * @author xshu
 * @date 2019-12-07
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var MapControl = /** @class */ (function (_super) {
    __extends(MapControl, _super);
    function MapControl() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.map = null;
        _this.scaleTime = null;
        _this.defaultScaling = 1;
        _this.minScale = 0.61; //小于这个会露底
        _this.maxScale = 1.5;
        _this.moveOffset = 2;
        _this.increaseRate = 10000;
        _this.locked = false; // 操作锁
        _this.singleTouchCb = null; // 点击回调函数
        _this.isMoving = false; // 是否拖动地图flag
        _this.mapTouchList = []; // 触摸点列表容器
        _this.isStrict = false; // 默认为非严格模式
        return _this;
    }
    MapControl.prototype.onLoad = function () {
        this.map = cc.find("obj_map", this.node);
    };
    MapControl.prototype.start = function () {
        this.addEvent();
        //this.smoothOperate(this.map, cc.Vec2.ZERO, this.defaultScaling); //cc.Vec2.ZERO   cc.v2(-3440, -1720)
    };
    // 有些设备单点过于灵敏，单点操作会触发TOUCH_MOVE回调，在这里作误差值判断
    MapControl.prototype.canStartMove = function (touch) {
        var startPos = touch.getStartLocation();
        var nowPos = touch.getLocation();
        // 有些设备单点过于灵敏，单点操作会触发TOUCH_MOVE回调，在这里作误差值判断
        return (Math.abs(nowPos.x - startPos.x) > this.moveOffset
            || Math.abs(nowPos.y - startPos.y) > this.moveOffset);
    };
    MapControl.prototype.addEvent = function () {
        var _this = this;
        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
            if (_this.locked)
                return;
            var touches = event.getTouches(); // 获取所有触摸点
            if (_this.isStrict) { // 严格模式下过滤掉初始点击位置不在目标节点范围内的触摸点
                touches
                    .filter(function (v) {
                    var startPos = cc.v2(v.getStartLocation()); // 触摸点最初的位置
                    var worldPos = _this.node.convertToWorldSpaceAR(cc.Vec2.ZERO);
                    var worldRect = cc.rect(worldPos.x - _this.node.width / 2, worldPos.y - _this.node.height / 2, _this.node.width, _this.node.height);
                    return worldRect.contains(startPos);
                })
                    .forEach(function (v) {
                    var intersection = _this.mapTouchList.filter(function (v1) { return v1.id === v.getID(); });
                    if (intersection.length === 0)
                        _this.mapTouchList[_this.mapTouchList.length] = ({ id: v.getID(), touch: v });
                });
                touches = _this.mapTouchList.map(function (v) { return v.touch; });
            }
            if (touches.length >= 2) {
                // multi touch
                _this.isMoving = true;
                var touch1 = touches[0];
                var touch2 = touches[1];
                var delta1 = cc.v2(touch1.getDelta());
                var delta2 = cc.v2(touch2.getDelta());
                var touchPoint1 = _this.map.convertToNodeSpaceAR(cc.v2(touch1.getLocation()));
                var touchPoint2 = _this.map.convertToNodeSpaceAR(cc.v2(touch2.getLocation()));
                var distance = touchPoint1.sub(touchPoint2);
                var delta = delta1.sub(delta2);
                var scale = 1;
                if (Math.abs(distance.x) > Math.abs(distance.y)) {
                    scale = (distance.x + delta.x) / distance.x * _this.map.scaleX;
                }
                else {
                    scale = (distance.y + delta.y) / distance.y * _this.map.scaleY;
                }
                var pos = touchPoint2.add(cc.v2(distance.x / 2, distance.y / 2));
                _this.smoothOperate(_this.map, pos, scale);
            }
            else if (touches.length === 1) {
                // single touch
                // cc.log(this.canStartMove(touches[0]));
                // cc.log(this.isMoving);
                if (_this.isMoving || _this.canStartMove(touches[0])) {
                    _this.isMoving = true;
                    var dir = cc.v2(touches[0].getDelta());
                    _this.dealMove(dir, _this.map, _this.node);
                }
            }
        });
        this.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (this.locked)
                return;
            var touches = this.isStrict ? this.mapTouchList : event.getTouches();
            if (touches.length <= 1) {
                if (!this.isMoving) {
                    var worldPos = cc.v2(event.getLocation());
                    var nodePos = this.map.convertToNodeSpaceAR(worldPos);
                    this.dealSelect(nodePos);
                }
                this.isMoving = false; // 当容器中仅剩最后一个触摸点时将移动flag还原
            }
            ;
            if (this.isStrict)
                this.removeTouchFromContent(event, this.mapTouchList);
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
            if (this.locked)
                return;
            var touches = this.isStrict ? this.mapTouchList : event.getTouches();
            // 当容器中仅剩最后一个触摸点时将移动flag还原
            if (touches.length <= 1)
                this.isMoving = false;
            if (this.isStrict)
                this.removeTouchFromContent(event, this.mapTouchList);
        }, this);
        //gun
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, function (event) {
            if (this.locked)
                return;
            var worldPos = cc.v2(event.getLocation());
            var scrollDelta = event.getScrollY();
            var scale = (this.map.scale + (scrollDelta / this.increaseRate));
            var target = this.map;
            var pos = target.convertToNodeSpaceAR(worldPos);
            this.smoothOperate(target, pos, scale);
        }, this);
    };
    MapControl.prototype.removeTouchFromContent = function (event, content) {
        var eventToucheIDs = event['getTouches']().map(function (v) { return v.getID(); });
        for (var len = content.length, i = len - 1; i >= 0; --i) {
            if (eventToucheIDs.indexOf(content[i].id) > -1)
                content.splice(i, 1); // 删除触摸
        }
    };
    MapControl.prototype.smoothOperate = function (target, pos, scale) {
        // 放大缩小
        if (this.minScale <= scale && scale <= this.maxScale) {
            // 当前缩放值与原来缩放值之差
            var deltaScale = scale - target.scaleX;
            // 当前点击的坐标与缩放值差像乘
            var gapPos = pos.scale(cc.v2(deltaScale, deltaScale));
            // 当前node坐标位置减去点击 点击坐标和缩放值的值
            var mapPos = target.getPosition().sub(gapPos);
            scale = Math.floor(scale * 100) / 100;
            target.scale = scale;
            this.dealScalePos(mapPos, target);
        }
        else {
            scale = cc.misc.clampf(scale, this.minScale, this.maxScale);
        }
        if (cc.isValid(this.scaleTime)) // 更新 label 显示
            this.scaleTime.string = "缩放：" + (Math.floor(scale * 100) + "%");
    };
    MapControl.prototype.dealScalePos = function (pos, target) {
        if (target.scale === 1) {
            pos = cc.Vec2.ZERO;
            //pos = cc.v2(-3440, -1720);
        }
        else {
            var worldPos = this.node.convertToWorldSpaceAR(pos);
            var nodePos = this.node.convertToNodeSpaceAR(worldPos);
            var edge = this.calculateEdge(target, this.node, nodePos);
            if (edge.left > 0) {
                pos.x -= edge.left;
            }
            if (edge.right > 0) {
                pos.x += edge.right;
            }
            if (edge.top > 0) {
                pos.y += edge.top;
            }
            if (edge.bottom > 0) {
                pos.y -= edge.bottom;
            }
        }
        target.setPosition(pos);
    };
    /** 处理移动*/
    MapControl.prototype.dealMove = function (dir, map, container) {
        var worldPos = map.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var nodePos = container.convertToNodeSpaceAR(worldPos);
        nodePos.x += dir.x;
        nodePos.y += dir.y;
        var edge = this.calculateEdge(map, container, nodePos);
        if (edge.left <= 0 && edge.right <= 0) {
            map.x += dir.x;
        }
        if (edge.top <= 0 && edge.bottom <= 0) {
            map.y += dir.y;
        }
    };
    MapControl.prototype.dealSelect = function (nodePos) {
        //cc.log(`click map on (${nodePos.x}, ${nodePos.y})`);
        // do sth
        if (this.singleTouchCb)
            this.singleTouchCb(nodePos);
    };
    // 计算map的四条边距离容器的距离，为负代表超出去
    MapControl.prototype.calculateEdge = function (target, container, nodePos) {
        // distance to the edge when anchor is (0.5, 0.5) 
        var horizontalDistance = (container.width - target.width * target.scaleX) / 2;
        var verticalDistance = (container.height - target.height * target.scaleY) / 2;
        // let left: number = horizontalDistance + nodePos.x;
        // let right: number = horizontalDistance - nodePos.x;
        // let top: number = verticalDistance - nodePos.y;
        // let bottom: number = verticalDistance + nodePos.y;
        var left = horizontalDistance + nodePos.x + 450;
        var right = horizontalDistance - nodePos.x + 444;
        var top = verticalDistance - nodePos.y + 178;
        var bottom = verticalDistance + nodePos.y + 261;
        // cc.log(left, right, top, bottom)
        // cc.log(nodePos.x, nodePos.y)
        return { left: left, right: right, top: top, bottom: bottom };
    };
    /**
     * @brief 设置是否严格模式，如果为严格模式，则会过滤不在目标身上的触摸点， 反之不作处理
     *              默认为非严格模式
     * @param isStrict
     */
    MapControl.prototype.setStrictPattern = function (isStrict) {
        this.isStrict = isStrict;
    };
    MapControl.prototype.getStrictPattern = function () {
        return this.isStrict;
    };
    __decorate([
        property({
            type: cc.Node,
            tooltip: '目标节点'
        })
    ], MapControl.prototype, "map", void 0);
    __decorate([
        property(cc.Label)
    ], MapControl.prototype, "scaleTime", void 0);
    __decorate([
        property({
            tooltip: '图片初始缩放'
        })
    ], MapControl.prototype, "defaultScaling", void 0);
    __decorate([
        property({
            tooltip: '图片缩放最小scale'
        })
    ], MapControl.prototype, "minScale", void 0);
    __decorate([
        property({
            tooltip: '图片缩放最大scale'
        })
    ], MapControl.prototype, "maxScale", void 0);
    __decorate([
        property({
            tooltip: '单点触摸容忍误差'
        })
    ], MapControl.prototype, "moveOffset", void 0);
    __decorate([
        property({
            tooltip: '滚轮缩放比率'
        })
    ], MapControl.prototype, "increaseRate", void 0);
    __decorate([
        property
    ], MapControl.prototype, "isStrict", void 0);
    MapControl = __decorate([
        ccclass
    ], MapControl);
    return MapControl;
}(cc.Component));
module.exports = MapControl;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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